/*
 * Decompiled with CFR 0.152.
 */
package cz.diribet.aqdef.parser;

import cz.diribet.aqdef.AqdefConstants;
import cz.diribet.aqdef.model.AqdefObjectModel;
import cz.diribet.aqdef.parser.ParserContext;
import cz.diribet.aqdef.parser.line.AbstractLineParser;
import cz.diribet.aqdef.parser.line.BinaryLineParser;
import cz.diribet.aqdef.parser.line.KKeyLineParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Path;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AqdefParser
implements AqdefConstants {
    private static final Logger LOG = LoggerFactory.getLogger(AqdefParser.class);
    private final AbstractLineParser kKeyLineParser = new KKeyLineParser();
    private final AbstractLineParser binaryLineParser = new BinaryLineParser();

    public AqdefObjectModel parse(String content) throws IOException {
        return this.parse(new StringReader(content));
    }

    public AqdefObjectModel parse(Path file, String encoding) throws IOException {
        return this.parse(file.toFile(), encoding);
    }

    public AqdefObjectModel parse(File file, String encoding) throws IOException {
        try (InputStream fileInputStream = this.createFileInputStream(file, encoding);){
            AqdefObjectModel aqdefObjectModel = this.parse(fileInputStream, encoding);
            return aqdefObjectModel;
        }
    }

    public AqdefObjectModel parse(InputStream inputStream, String encoding) throws IOException {
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, encoding);){
            AqdefObjectModel aqdefObjectModel = this.parse(inputStreamReader);
            return aqdefObjectModel;
        }
    }

    public AqdefObjectModel parse(Reader reader) throws IOException {
        AqdefObjectModel aqdefObjectModel = new AqdefObjectModel();
        ParserContext context = new ParserContext();
        int lineIndex = 1;
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                context.setCurrentLine(lineIndex);
                try {
                    line = line.trim();
                    if (StringUtils.isNotEmpty((CharSequence)line)) {
                        this.parseLine(line, aqdefObjectModel, context);
                    }
                }
                catch (Throwable e) {
                    throw new DfqParserException(context, e);
                }
                ++lineIndex;
            }
        }
        aqdefObjectModel.normalize();
        return aqdefObjectModel;
    }

    private void parseLine(String line, AqdefObjectModel aqdefObjectModel, ParserContext context) {
        if (this.kKeyLineParser.isLineSupported(line)) {
            this.kKeyLineParser.parseLine(line, aqdefObjectModel, context);
        } else if (this.binaryLineParser.isLineSupported(line)) {
            this.binaryLineParser.parseLine(line, aqdefObjectModel, context);
        } else {
            LOG.warn("{} Invalid line format. This line will be discarded. Line content: {}", (Object)ParserContext.lineLogContext(context), (Object)line);
        }
    }

    private InputStream createFileInputStream(File file, String encoding) throws FileNotFoundException {
        FileInputStream inputStream = new FileInputStream(file);
        if ("utf-8".equalsIgnoreCase(encoding)) {
            inputStream = new BOMInputStream((InputStream)inputStream);
        }
        return inputStream;
    }

    private static class DfqParserException
    extends RuntimeException {
        DfqParserException(ParserContext context, Throwable cause) {
            super(DfqParserException.message(context, cause), cause);
        }

        private static String message(ParserContext context, Throwable cause) {
            String message = "Failed to parse DFQ file. Error at line: " + context.getCurrentLine();
            if (cause != null && cause.getMessage() != null) {
                message = message + " Cause: " + cause.getMessage();
            }
            return message;
        }
    }
}

