/*
 * Decompiled with CFR 0.152.
 */
package cz.diribet.aqdef;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import cz.diribet.aqdef.IKKeyProvider;
import cz.diribet.aqdef.KKey;
import cz.diribet.aqdef.KKeyMetadata;
import cz.diribet.aqdef.convert.BooleanKKeyValueConverter;
import cz.diribet.aqdef.convert.custom.K0005ValueConverter;
import cz.diribet.aqdef.convert.custom.K0006ValueConverter;
import cz.diribet.aqdef.convert.custom.K0020ValueConverter;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class KKeyRepository {
    private static final KKeyRepository INSTANCE = new KKeyRepository();
    private final ImmutableMap<KKey, KKeyMetadata> kKeysWithMetadata;
    private final ImmutableList<KKey> allKKeys;
    private final ImmutableList<KKey> partKKeys;
    private final ImmutableList<KKey> characteristicKKeys;
    private final ImmutableList<KKey> valueKKeys;

    private KKeyRepository() {
        TreeMap<KKey, KKeyMetadata> kKeysWithMetadata = new TreeMap<KKey, KKeyMetadata>();
        kKeysWithMetadata.putAll(new DefaultKKeyProvider().createKKeysWithMetadata());
        kKeysWithMetadata.putAll(new CustomKKeyProvider().createKKeysWithMetadata());
        ServiceLoader<IKKeyProvider> thirdpartyProviders = ServiceLoader.load(IKKeyProvider.class);
        for (IKKeyProvider provider : thirdpartyProviders) {
            kKeysWithMetadata.putAll(provider.createKKeysWithMetadata());
        }
        this.kKeysWithMetadata = ImmutableMap.copyOf(kKeysWithMetadata);
        this.allKKeys = this.filteredKKeys((Map<KKey, KKeyMetadata>)this.kKeysWithMetadata, e -> true);
        this.partKKeys = this.filteredKKeys((Map<KKey, KKeyMetadata>)this.kKeysWithMetadata, e -> e.isPartLevel());
        this.characteristicKKeys = this.filteredKKeys((Map<KKey, KKeyMetadata>)this.kKeysWithMetadata, e -> e.isCharacteristicLevel());
        this.valueKKeys = this.filteredKKeys((Map<KKey, KKeyMetadata>)this.kKeysWithMetadata, e -> e.isValueLevel());
    }

    public static KKeyRepository getInstance() {
        return INSTANCE;
    }

    private ImmutableList<KKey> filteredKKeys(Map<KKey, KKeyMetadata> map, Predicate<KKey> predicate) {
        List filteredKKeys = map.keySet().stream().filter(predicate).sorted().collect(Collectors.toList());
        return ImmutableList.copyOf(filteredKKeys);
    }

    public KKeyMetadata getMetadataFor(KKey kKey) {
        return (KKeyMetadata)this.kKeysWithMetadata.get((Object)kKey);
    }

    public ImmutableList<KKey> getAllKKeys() {
        return this.allKKeys;
    }

    public ImmutableList<KKey> getPartKKeys() {
        return this.partKKeys;
    }

    public ImmutableList<KKey> getCharacteristicKKeys() {
        return this.characteristicKKeys;
    }

    public ImmutableList<KKey> getValueKKeys() {
        return this.valueKKeys;
    }

    private static class DefaultKKeyProvider
    implements IKKeyProvider {
        private DefaultKKeyProvider() {
        }

        @Override
        public Map<KKey, KKeyMetadata> createKKeysWithMetadata() {
            HashMap<KKey, KKeyMetadata> keys = new HashMap<KKey, KKeyMetadata>();
            keys.put(KKey.of("K1001"), KKeyMetadata.of("TETEILNR", String.class, 30));
            keys.put(KKey.of("K1002"), KKeyMetadata.of("TEBEZEICH", String.class, 80));
            keys.put(KKey.of("K1010"), KKeyMetadata.of("TEDPFLICHT", Integer.class, 3));
            keys.put(KKey.of("K1900"), KKeyMetadata.of("TEBEM", String.class, 255));
            keys.put(KKey.of("K1021"), KKeyMetadata.of("TEHERSTELLERNR", String.class, 20));
            keys.put(KKey.of("K1022"), KKeyMetadata.of("TEHERSTELLERBEZ", String.class, 80));
            keys.put(KKey.of("K1031"), KKeyMetadata.of("TEWERKSTOFFNR", String.class, 20));
            keys.put(KKey.of("K1032"), KKeyMetadata.of("TEWERKSTOFFBEZ", String.class, 40));
            keys.put(KKey.of("K1041"), KKeyMetadata.of("TEZEICHNUNGNR", String.class, 30));
            keys.put(KKey.of("K1042"), KKeyMetadata.of("TEZEICHNUNGAEND", String.class, 20));
            keys.put(KKey.of("K1043"), KKeyMetadata.of("TEZEICHNUNGINDEX", String.class, 40));
            keys.put(KKey.of("K1053"), KKeyMetadata.of("TEAUFTRAGSTR", String.class, 40));
            keys.put(KKey.of("K1051"), KKeyMetadata.of("TEAUFTRAGGBNR", String.class, 20));
            keys.put(KKey.of("K1052"), KKeyMetadata.of("TEAUFTRAGGBBEZ", String.class, 40));
            keys.put(KKey.of("K1061"), KKeyMetadata.of("TEKUNDENR", String.class, 20));
            keys.put(KKey.of("K1062"), KKeyMetadata.of("TEKUNDEBEZ", String.class, 40));
            keys.put(KKey.of("K1071"), KKeyMetadata.of("TELIEFERANTNR", String.class, 20));
            keys.put(KKey.of("K1072"), KKeyMetadata.of("TELIEFERANTBEZ", String.class, 40));
            keys.put(KKey.of("K1201"), KKeyMetadata.of("TEPREINRNR", String.class, 24));
            keys.put(KKey.of("K1202"), KKeyMetadata.of("TEPREINRBEZ", String.class, 40));
            keys.put(KKey.of("K1203"), KKeyMetadata.of("TEPRGRUNDBEZ", String.class, 80));
            keys.put(KKey.of("K1204"), KKeyMetadata.of("TEPRBEGINNSTR", String.class, 40));
            keys.put(KKey.of("K1205"), KKeyMetadata.of("TEPRENDESTR", String.class, 40));
            keys.put(KKey.of("K1003"), KKeyMetadata.of("TEKURZBEZEICH", String.class, 20));
            keys.put(KKey.of("K1004"), KKeyMetadata.of("TEAENDSTAND", String.class, 20));
            keys.put(KKey.of("K1005"), KKeyMetadata.of("TEERZEUGNIS", String.class, 40));
            keys.put(KKey.of("K1081"), KKeyMetadata.of("TEMASCHINENR", String.class, 24));
            keys.put(KKey.of("K1082"), KKeyMetadata.of("TEMASCHINEBEZ", String.class, 40));
            keys.put(KKey.of("K1085"), KKeyMetadata.of("TEMASCHINEORT", String.class, 40));
            keys.put(KKey.of("K1086"), KKeyMetadata.of("TEARBEITSGANG", String.class, 40));
            keys.put(KKey.of("K1100"), KKeyMetadata.of("TEBEREICH", String.class, 40));
            keys.put(KKey.of("K1101"), KKeyMetadata.of("TEABT", String.class, 40));
            keys.put(KKey.of("K1206"), KKeyMetadata.of("TEPRPLATZ", String.class, 40));
            keys.put(KKey.of("K1207"), KKeyMetadata.of("TEPPLANERST", String.class));
            keys.put(KKey.of("K1023"), KKeyMetadata.of("TEHERSTELLERKEY", Integer.class, 5));
            keys.put(KKey.of("K1033"), KKeyMetadata.of("TEWERKSTOFFKEY", Integer.class, 5));
            keys.put(KKey.of("K1044"), KKeyMetadata.of("TEZEICHNUNGKEY", Integer.class, 5));
            keys.put(KKey.of("K1054"), KKeyMetadata.of("TEAUFTRAGGBKEY", Integer.class, 5));
            keys.put(KKey.of("K1063"), KKeyMetadata.of("TEKUNDEKEY", Integer.class, 5));
            keys.put(KKey.of("K1073"), KKeyMetadata.of("TELIEFERANTKEY", Integer.class, 5));
            keys.put(KKey.of("K1083"), KKeyMetadata.of("TEMASCHINEKEY", Integer.class, 5));
            keys.put(KKey.of("K1208"), KKeyMetadata.of("TEPREINRKEY", Integer.class, 5));
            keys.put(KKey.of("K1007"), KKeyMetadata.of("TENRKURZ", String.class, 20));
            keys.put(KKey.of("K1102"), KKeyMetadata.of("TEWERKSTATT", String.class, 40));
            keys.put(KKey.of("K1211"), KKeyMetadata.of("TENORMNR", String.class, 20));
            keys.put(KKey.of("K1212"), KKeyMetadata.of("TENORMBEZ", String.class, 40));
            keys.put(KKey.of("K1215"), KKeyMetadata.of("TENORMAL", Integer.class, 5));
            keys.put(KKey.of("K1008"), KKeyMetadata.of("TETYP", String.class, 20));
            keys.put(KKey.of("K1009"), KKeyMetadata.of("TECODE", String.class, 20));
            keys.put(KKey.of("K1011"), KKeyMetadata.of("TEVARIANTE", String.class, 20));
            keys.put(KKey.of("K1012"), KKeyMetadata.of("TESACHNRZUS", String.class, 20));
            keys.put(KKey.of("K1013"), KKeyMetadata.of("TESACHNRIDX", String.class, 20));
            keys.put(KKey.of("K1014"), KKeyMetadata.of("TETEILIDENT", String.class, 20));
            keys.put(KKey.of("K1103"), KKeyMetadata.of("TEKOSTST", String.class, 40));
            keys.put(KKey.of("K1104"), KKeyMetadata.of("TESCHICHT", String.class, 20));
            keys.put(KKey.of("K1110"), KKeyMetadata.of("TEBESTNR", String.class, 20));
            keys.put(KKey.of("K1111"), KKeyMetadata.of("TEWARENEINNR", String.class, 20));
            keys.put(KKey.of("K1112"), KKeyMetadata.of("TEWUERFEL", String.class));
            keys.put(KKey.of("K1113"), KKeyMetadata.of("TEPOSITION", String.class));
            keys.put(KKey.of("K1114"), KKeyMetadata.of("TEVORRICHT", String.class));
            keys.put(KKey.of("K1115"), KKeyMetadata.of("TEFERTDAT", String.class));
            keys.put(KKey.of("K1209"), KKeyMetadata.of("TEPRUEFART", String.class, 20));
            keys.put(KKey.of("K1230"), KKeyMetadata.of("TEMESSRAUM", String.class, 40));
            keys.put(KKey.of("K1231"), KKeyMetadata.of("TEMESSPROGNR", String.class, 20));
            keys.put(KKey.of("K1232"), KKeyMetadata.of("TEMESSPROGVER", String.class, 20));
            keys.put(KKey.of("K1223"), KKeyMetadata.of("TEPRUEFERKEY", Integer.class, 5));
            keys.put(KKey.of("K1221"), KKeyMetadata.of("TEPRUEFERNR", String.class, 20));
            keys.put(KKey.of("K1222"), KKeyMetadata.of("TEPRUEFERNAME", String.class, 40));
            keys.put(KKey.of("K1016"), KKeyMetadata.of("TEZSB_1016", String.class, 30));
            keys.put(KKey.of("K1350"), KKeyMetadata.of("TEREPORTFILE_1350", String.class, 50));
            keys.put(KKey.of("K1045"), KKeyMetadata.of("TE_1045", String.class, 20));
            keys.put(KKey.of("K1046"), KKeyMetadata.of("TE_1046", String.class, 60));
            keys.put(KKey.of("K1047"), KKeyMetadata.of("TE_1047", String.class, 20));
            keys.put(KKey.of("K1300"), KKeyMetadata.of("TE_1300", Integer.class));
            keys.put(KKey.of("K1301"), KKeyMetadata.of("TE_1301", Integer.class, 5));
            keys.put(KKey.of("K1302"), KKeyMetadata.of("TE_1302", String.class, 40));
            keys.put(KKey.of("K1311"), KKeyMetadata.of("TE_1311", String.class, 40));
            keys.put(KKey.of("K1341"), KKeyMetadata.of("TE_1341", String.class, 20));
            keys.put(KKey.of("K1342"), KKeyMetadata.of("TE_1342", String.class, 40));
            keys.put(KKey.of("K1343"), KKeyMetadata.of("TE_1343", String.class, 20));
            keys.put(KKey.of("K1303"), KKeyMetadata.of("TEWERK", String.class, 40));
            keys.put(KKey.of("K1210"), KKeyMetadata.of("TEMESSTYP", Integer.class, 5));
            keys.put(KKey.of("K1344"), KKeyMetadata.of("TE_1344", String.class, 40));
            keys.put(KKey.of("K1015"), KKeyMetadata.of("TE_1015", Integer.class, 3));
            keys.put(KKey.of("K1017"), KKeyMetadata.of("TE_1017", Integer.class, 3));
            keys.put(KKey.of("K1087"), KKeyMetadata.of("TE_1087", String.class));
            keys.put(KKey.of("K1018"), KKeyMetadata.of("TE_1018", Integer.class));
            keys.put(KKey.of("K1401"), KKeyMetadata.of("TE_1401", Integer.class));
            keys.put(KKey.of("K1402"), KKeyMetadata.of("TE_1402", Integer.class));
            keys.put(KKey.of("K1403"), KKeyMetadata.of("TE_1403", Integer.class));
            keys.put(KKey.of("K1404"), KKeyMetadata.of("TE_1404", Integer.class));
            keys.put(KKey.of("K1405"), KKeyMetadata.of("TE_1405", Integer.class));
            keys.put(KKey.of("K1407"), KKeyMetadata.of("TE_1407", Integer.class));
            keys.put(KKey.of("K1408"), KKeyMetadata.of("TE_1408", Integer.class));
            keys.put(KKey.of("K1410"), KKeyMetadata.of("TE_1410", String.class));
            keys.put(KKey.of("K1411"), KKeyMetadata.of("TE_1411", Integer.class));
            keys.put(KKey.of("K1091"), KKeyMetadata.of("TE_1091", String.class));
            keys.put(KKey.of("K1092"), KKeyMetadata.of("TE_1092", String.class));
            keys.put(KKey.of("K1105"), KKeyMetadata.of("TE_1105", String.class));
            keys.put(KKey.of("K1106"), KKeyMetadata.of("TE_1106", String.class));
            keys.put(KKey.of("K1107"), KKeyMetadata.of("TE_1107", String.class));
            keys.put(KKey.of("K1108"), KKeyMetadata.of("TE_1108", String.class));
            keys.put(KKey.of("K1304"), KKeyMetadata.of("TE_1304", String.class));
            keys.put(KKey.of("K1048"), KKeyMetadata.of("TE_1048", String.class));
            keys.put(KKey.of("K0001"), KKeyMetadata.of("WVWERTNR", BigDecimal.class, 22));
            keys.put(KKey.of("K0002"), KKeyMetadata.of("WVATTRIBUT", Integer.class, 5));
            keys.put(KKey.of("K0008"), KKeyMetadata.of("WVPRUEFER", Integer.class, 10));
            keys.put(KKey.of("K0012"), KKeyMetadata.of("WVPRUEFMIT", Integer.class, 10));
            keys.put(KKey.of("K0010"), KKeyMetadata.of("WVMASCHINE", Integer.class, 10));
            keys.put(KKey.of("K0007"), KKeyMetadata.of("WVNEST", Integer.class, 10));
            keys.put(KKey.of("K0004"), KKeyMetadata.of("WVDATZEIT", Date.class));
            keys.put(KKey.of("K0006"), KKeyMetadata.of("WVCHARGE", String.class, 14));
            keys.put(KKey.of("K0053"), KKeyMetadata.of("WVAUFTRAG", String.class, 20));
            keys.put(KKey.of("K0031"), KKeyMetadata.of("WV0031", Integer.class));
            keys.put(KKey.of("K0034"), KKeyMetadata.of("WV0034", Integer.class));
            keys.put(KKey.of("K0009"), KKeyMetadata.of("WV0009", String.class, 255));
            keys.put(KKey.of("K0014"), KKeyMetadata.of("WV0014", String.class, 40));
            keys.put(KKey.of("K0015"), KKeyMetadata.of("WV0015", Integer.class, 5));
            keys.put(KKey.of("K0016"), KKeyMetadata.of("WV0016", String.class));
            keys.put(KKey.of("K0017"), KKeyMetadata.of("WV0017", String.class));
            keys.put(KKey.of("K0097"), KKeyMetadata.of("WV0097", UUID.class));
            keys.put(KKey.of("K2001"), KKeyMetadata.of("MEMERKNR", String.class, 20));
            keys.put(KKey.of("K2002"), KKeyMetadata.of("MEMERKBEZ", String.class, 80));
            keys.put(KKey.of("K2101"), KKeyMetadata.of("MENENNMAS", BigDecimal.class, 22));
            keys.put(KKey.of("K2120"), KKeyMetadata.of("MEARTUGW", Integer.class, 3));
            keys.put(KKey.of("K2121"), KKeyMetadata.of("MEARTOGW", Integer.class, 3));
            keys.put(KKey.of("K2240"), KKeyMetadata.of("MEARTPLAUSIUNT", Integer.class));
            keys.put(KKey.of("K2241"), KKeyMetadata.of("MEARTPLAUSIOB", Integer.class));
            keys.put(KKey.of("K2110"), KKeyMetadata.of("MEUGW", BigDecimal.class, 22));
            keys.put(KKey.of("K2111"), KKeyMetadata.of("MEOGW", BigDecimal.class, 22));
            keys.put(KKey.of("K2504"), KKeyMetadata.of("MEFSK", Integer.class, 3));
            keys.put(KKey.of("K2163"), KKeyMetadata.of("MEFEHLKOST", BigDecimal.class, 22));
            keys.put(KKey.of("K2006"), KKeyMetadata.of("MEDPFLICHT", Integer.class, 5));
            keys.put(KKey.of("K2141"), KKeyMetadata.of("MEEINHEIT", Integer.class, 5));
            keys.put(KKey.of("K2022"), KKeyMetadata.of("MEAUFLOES", Integer.class, 5));
            keys.put(KKey.of("K2013"), KKeyMetadata.of("MEKLASSENW", BigDecimal.class, 22));
            keys.put(KKey.of("K2311"), KKeyMetadata.of("MEFERTARTNR", String.class, 20));
            keys.put(KKey.of("K2312"), KKeyMetadata.of("MEFERTART", String.class, 40));
            keys.put(KKey.of("K2405"), KKeyMetadata.of("MEPRUEFMIT", Integer.class, 5));
            keys.put(KKey.of("K2403"), KKeyMetadata.of("MEPMGRUPPET", String.class, 80));
            keys.put(KKey.of("K2402"), KKeyMetadata.of("MEPRUEFMITT", String.class, 80));
            keys.put(KKey.of("K2401"), KKeyMetadata.of("MEPRUEFMITNRT", String.class, 40));
            keys.put(KKey.of("K2041"), KKeyMetadata.of("MEERFART", Integer.class, 3));
            keys.put(KKey.of("K2305"), KKeyMetadata.of("MEMASCHINE", Integer.class, 5));
            keys.put(KKey.of("K2900"), KKeyMetadata.of("MEBEMERK", String.class, 255));
            keys.put(KKey.of("K2205"), KKeyMetadata.of("MEUMFSTICH", Integer.class, 5));
            keys.put(KKey.of("K2220"), KKeyMetadata.of("MEANZPRUEF", Integer.class, 5));
            keys.put(KKey.of("K2221"), KKeyMetadata.of("MEANZWIED", Integer.class, 5));
            keys.put(KKey.of("K2205"), KKeyMetadata.of("MEANZTEILE", Integer.class, 5));
            keys.put(KKey.of("K2021"), KKeyMetadata.of("MEFORMEL", String.class, 255));
            keys.put(KKey.of("K2024"), KKeyMetadata.of("METRANSPA", BigDecimal.class, 22));
            keys.put(KKey.of("K2025"), KKeyMetadata.of("METRANSPB", BigDecimal.class, 22));
            keys.put(KKey.of("K2026"), KKeyMetadata.of("METRANSPC", BigDecimal.class, 22));
            keys.put(KKey.of("K2027"), KKeyMetadata.of("METRANSPD", BigDecimal.class, 22));
            keys.put(KKey.of("K2502"), KKeyMetadata.of("MEAUSWART", Integer.class, 3));
            keys.put(KKey.of("K2202"), KKeyMetadata.of("MEAUSWTYP", Integer.class, 3));
            keys.put(KKey.of("K2004"), KKeyMetadata.of("MEMERKART", Integer.class, 5));
            keys.put(KKey.of("K2011"), KKeyMetadata.of("MEVERTFORM", Integer.class, 5));
            keys.put(KKey.of("K2130"), KKeyMetadata.of("MEPLAUSIUN", BigDecimal.class, 22));
            keys.put(KKey.of("K2131"), KKeyMetadata.of("MEPLAUSIOB", BigDecimal.class, 22));
            keys.put(KKey.of("K2201"), KKeyMetadata.of("MEPROSTREU", BigDecimal.class, 22));
            keys.put(KKey.of("K2217"), KKeyMetadata.of("MENORMISTSTR", String.class, 80));
            keys.put(KKey.of("K2213"), KKeyMetadata.of("MENORMIST", BigDecimal.class, 22));
            keys.put(KKey.of("K2211"), KKeyMetadata.of("MENORMNR", String.class, 40));
            keys.put(KKey.of("K2212"), KKeyMetadata.of("MENORMBEZ", String.class, 40));
            keys.put(KKey.of("K2007"), KKeyMetadata.of("MESTEUERB", Integer.class, 5));
            keys.put(KKey.of("K2060"), KKeyMetadata.of("MEEREIGKAT", String.class, 50));
            keys.put(KKey.of("K2005"), KKeyMetadata.of("MEMERKKLASSE", Integer.class, 5));
            keys.put(KKey.of("K2009"), KKeyMetadata.of("MEUNTERSART", Integer.class));
            keys.put(KKey.of("K2234"), KKeyMetadata.of("MEANZORDKLASSE", Integer.class));
            keys.put(KKey.of("K2503"), KKeyMetadata.of("MEAUTOERKENNUNG", Integer.class, 3));
            keys.put(KKey.of("K2501"), KKeyMetadata.of("MEATTR", Integer.class, 3));
            keys.put(KKey.of("K2072"), KKeyMetadata.of("METRANSFEINGA", BigDecimal.class, 22));
            keys.put(KKey.of("K2071"), KKeyMetadata.of("METRANSFEINGB", BigDecimal.class, 22));
            keys.put(KKey.of("K2045"), KKeyMetadata.of("MEERFKANAL", String.class, 20));
            keys.put(KKey.of("K2046"), KKeyMetadata.of("MEERFSUBKANAL", String.class, 20));
            keys.put(KKey.of("K2012"), KKeyMetadata.of("MENACHARBEIT", Integer.class));
            keys.put(KKey.of("K2100"), KKeyMetadata.of("MEZIELWERT", BigDecimal.class, 22));
            keys.put(KKey.of("K2102"), KKeyMetadata.of("MEPMAX", BigDecimal.class, 22));
            keys.put(KKey.of("K2142"), KKeyMetadata.of("MEEINHEITTEXT", String.class, 20));
            keys.put(KKey.of("K2160"), KKeyMetadata.of("MELOSUMFANG", Integer.class, 5));
            keys.put(KKey.of("K2161"), KKeyMetadata.of("MEKOSTENNACHARBEIT", BigDecimal.class, 22));
            keys.put(KKey.of("K2162"), KKeyMetadata.of("MEKOSTENAUSSCHUSS", BigDecimal.class, 22));
            keys.put(KKey.of("K2301"), KKeyMetadata.of("MEMASCHNR", String.class, 20));
            keys.put(KKey.of("K2302"), KKeyMetadata.of("MEMASCHBEZ", String.class, 40));
            keys.put(KKey.of("K2303"), KKeyMetadata.of("MEABT", String.class, 40));
            keys.put(KKey.of("K2304"), KKeyMetadata.of("MESTANDORT", String.class, 40));
            keys.put(KKey.of("K2320"), KKeyMetadata.of("MEAUFTRNR", String.class, 20));
            keys.put(KKey.of("K2323"), KKeyMetadata.of("MEAUFTRAGGEBNR", Integer.class, 5));
            keys.put(KKey.of("K2321"), KKeyMetadata.of("MEAUFTRAGGEBNRT", String.class, 20));
            keys.put(KKey.of("K2322"), KKeyMetadata.of("MEAUFTRAGGEB", String.class, 40));
            keys.put(KKey.of("K2410"), KKeyMetadata.of("MEPRUEFORTT", String.class, 40));
            keys.put(KKey.of("K2411"), KKeyMetadata.of("MEPRUEFBEGINN", String.class, 80));
            keys.put(KKey.of("K2412"), KKeyMetadata.of("MEPRUEFENDE", String.class, 80));
            keys.put(KKey.of("K2423"), KKeyMetadata.of("MEPRUEFER", Integer.class, 5));
            keys.put(KKey.of("K2421"), KKeyMetadata.of("MEPRUEFERNR", String.class, 20));
            keys.put(KKey.of("K2422"), KKeyMetadata.of("MEPRUEFERNAME", String.class, 40));
            keys.put(KKey.of("K2901"), KKeyMetadata.of("MEPRUEFBEDING", String.class, 80));
            keys.put(KKey.of("K2019"), KKeyMetadata.of("MEPRUEFMITNR", Integer.class));
            keys.put(KKey.of("K2030"), KKeyMetadata.of("MEAUGROUP", Integer.class, 5));
            keys.put(KKey.of("K2151"), KKeyMetadata.of("METOLERANZTEXT", String.class, 20));
            keys.put(KKey.of("K2333"), KKeyMetadata.of("MEWERKSTCK", Integer.class, 5));
            keys.put(KKey.of("K2332"), KKeyMetadata.of("MEWERKSTCKTEXT", String.class, 40));
            keys.put(KKey.of("K2404"), KKeyMetadata.of("MEPMAUFLOES", BigDecimal.class, 22));
            keys.put(KKey.of("K2215"), KKeyMetadata.of("MENORMAL", Integer.class, 5));
            keys.put(KKey.of("K2214"), KKeyMetadata.of("MENORMALTEMP", BigDecimal.class, 22));
            keys.put(KKey.of("K2331"), KKeyMetadata.of("MEWERKSTCKNR", String.class, 20));
            keys.put(KKey.of("K2003"), KKeyMetadata.of("MEKURZBEZ", String.class, 20));
            keys.put(KKey.of("K2114"), KKeyMetadata.of("MEUGSCHROTT", BigDecimal.class, 22));
            keys.put(KKey.of("K2115"), KKeyMetadata.of("MEOGSCHROTT", BigDecimal.class, 22));
            keys.put(KKey.of("K2225"), KKeyMetadata.of("MECG", BigDecimal.class, 22));
            keys.put(KKey.of("K2226"), KKeyMetadata.of("MECGK", BigDecimal.class, 22));
            keys.put(KKey.of("K2227"), KKeyMetadata.of("MEABWGC", BigDecimal.class, 22));
            keys.put(KKey.of("K2243"), KKeyMetadata.of("MEZEICHN", String.class, 80));
            keys.put(KKey.of("K2313"), KKeyMetadata.of("MEFERTARTKEY", Integer.class, 5));
            keys.put(KKey.of("K2406"), KKeyMetadata.of("MEPMHERST", String.class, 40));
            keys.put(KKey.of("K2042"), KKeyMetadata.of("MEERFNR", Integer.class, 5));
            keys.put(KKey.of("K2043"), KKeyMetadata.of("MEERFNAME", String.class, 40));
            keys.put(KKey.of("K2044"), KKeyMetadata.of("MEERFINDEX", Integer.class, 5));
            keys.put(KKey.of("K2047"), KKeyMetadata.of("MEANFINDEX", Integer.class, 3));
            keys.put(KKey.of("K2051"), KKeyMetadata.of("MEINTERFACE", Integer.class, 3));
            keys.put(KKey.of("K2052"), KKeyMetadata.of("MEBAUD", Integer.class, 5));
            keys.put(KKey.of("K2053"), KKeyMetadata.of("MEIRQ", Integer.class, 3));
            keys.put(KKey.of("K2054"), KKeyMetadata.of("MEPARITY", Integer.class, 3));
            keys.put(KKey.of("K2055"), KKeyMetadata.of("MEDATA", Integer.class, 3));
            keys.put(KKey.of("K2056"), KKeyMetadata.of("MESTOP", Integer.class, 3));
            keys.put(KKey.of("K2061"), KKeyMetadata.of("MEPZPKAT", Integer.class, 5));
            keys.put(KKey.of("K2152"), KKeyMetadata.of("METOLERANZCALC", BigDecimal.class, 22));
            keys.put(KKey.of("K2306"), KKeyMetadata.of("MEBEREICH", String.class, 40));
            keys.put(KKey.of("K2307"), KKeyMetadata.of("MEPTM", String.class, 40));
            keys.put(KKey.of("K2341"), KKeyMetadata.of("MEPPLANNRT", String.class, 20));
            keys.put(KKey.of("K2342"), KKeyMetadata.of("MEPPLAN", String.class, 40));
            keys.put(KKey.of("K2343"), KKeyMetadata.of("MEPPLANDAT", String.class, 20));
            keys.put(KKey.of("K2344"), KKeyMetadata.of("MEPPLANERST", String.class, 40));
            keys.put(KKey.of("K2407"), KKeyMetadata.of("MESPCNR", String.class, 20));
            keys.put(KKey.of("K2408"), KKeyMetadata.of("MESPCHERST", String.class, 20));
            keys.put(KKey.of("K2409"), KKeyMetadata.of("MESPCTYP", String.class, 20));
            keys.put(KKey.of("K2116"), KKeyMetadata.of("MENORMISTUN", BigDecimal.class));
            keys.put(KKey.of("K2117"), KKeyMetadata.of("MENORMISTOB", BigDecimal.class));
            keys.put(KKey.of("K2216"), KKeyMetadata.of("MENORMALSERNR", String.class, 20));
            keys.put(KKey.of("K2415"), KKeyMetadata.of("MEPRUEFMITSERNR", String.class, 20));
            keys.put(KKey.of("K2416"), KKeyMetadata.of("MEANZGERAET", String.class, 40));
            keys.put(KKey.of("K2261"), KKeyMetadata.of("MEREFTEILNRSTR", String.class, 40));
            keys.put(KKey.of("K2262"), KKeyMetadata.of("MEREFTEILBEZ", String.class, 40));
            keys.put(KKey.of("K2263"), KKeyMetadata.of("MEREFTEILIST", BigDecimal.class, 22));
            keys.put(KKey.of("K2264"), KKeyMetadata.of("MEREFTEILTEMP", BigDecimal.class, 22));
            keys.put(KKey.of("K2265"), KKeyMetadata.of("MEREFTEILNR", Integer.class, 3));
            keys.put(KKey.of("K2266"), KKeyMetadata.of("MEREFTEILSERNR", String.class, 40));
            keys.put(KKey.of("K2271"), KKeyMetadata.of("MEKALTEILUNRSTR", String.class));
            keys.put(KKey.of("K2272"), KKeyMetadata.of("MEKALTEILUBEZ", String.class));
            keys.put(KKey.of("K2273"), KKeyMetadata.of("MEKALTEILUIST", BigDecimal.class));
            keys.put(KKey.of("K2274"), KKeyMetadata.of("MEKALTEILUTEMP", BigDecimal.class));
            keys.put(KKey.of("K2275"), KKeyMetadata.of("MEKALTEILUNR", Integer.class));
            keys.put(KKey.of("K2276"), KKeyMetadata.of("MEKALTEILUSERNR", String.class));
            keys.put(KKey.of("K2281"), KKeyMetadata.of("MEKALTEILMNRSTR", String.class, 40));
            keys.put(KKey.of("K2282"), KKeyMetadata.of("MEKALTEILMBEZ", String.class, 40));
            keys.put(KKey.of("K2283"), KKeyMetadata.of("MEKALTEILMIST", BigDecimal.class, 22));
            keys.put(KKey.of("K2284"), KKeyMetadata.of("MEKALTEILMTEMP", BigDecimal.class, 22));
            keys.put(KKey.of("K2285"), KKeyMetadata.of("MEKALTEILMNR", Integer.class, 3));
            keys.put(KKey.of("K2286"), KKeyMetadata.of("MEKALTEILMSERNR", String.class, 40));
            keys.put(KKey.of("K2291"), KKeyMetadata.of("MEKALTEILONRSTR", String.class));
            keys.put(KKey.of("K2292"), KKeyMetadata.of("MEKALTEILOBEZ", String.class));
            keys.put(KKey.of("K2293"), KKeyMetadata.of("MEKALTEILOIST", BigDecimal.class));
            keys.put(KKey.of("K2294"), KKeyMetadata.of("MEKALTEILOTEMP", BigDecimal.class));
            keys.put(KKey.of("K2295"), KKeyMetadata.of("MEKALTEILONR", Integer.class));
            keys.put(KKey.of("K2296"), KKeyMetadata.of("MEKALTEILOSERNR", String.class));
            keys.put(KKey.of("K2048"), KKeyMetadata.of("MEUEBERKAN", Integer.class, 3));
            keys.put(KKey.of("K2090"), KKeyMetadata.of("MEMERKCODE", String.class, 40));
            keys.put(KKey.of("K2091"), KKeyMetadata.of("MEMERKINDEX", String.class, 20));
            keys.put(KKey.of("K2092"), KKeyMetadata.of("MEMERKTEXT", String.class, 50));
            keys.put(KKey.of("K2093"), KKeyMetadata.of("MEBEARBZUST", String.class, 80));
            keys.put(KKey.of("K2095"), KKeyMetadata.of("MEELEMCODE", String.class, 40));
            keys.put(KKey.of("K2096"), KKeyMetadata.of("MEELEMINDEX", String.class, 20));
            keys.put(KKey.of("K2097"), KKeyMetadata.of("MEELEMTEXT", String.class, 50));
            keys.put(KKey.of("K2098"), KKeyMetadata.of("MEELEMADR", String.class, 20));
            keys.put(KKey.of("K2074"), KKeyMetadata.of("MECALIBADD", BigDecimal.class, 22));
            keys.put(KKey.of("K2075"), KKeyMetadata.of("MECALIBMULT", BigDecimal.class, 22));
            keys.put(KKey.of("K2105"), KKeyMetadata.of("MEANZNIAUSGEF", Integer.class, 5));
            keys.put(KKey.of("K2203"), KKeyMetadata.of("MEGCKONVART", Integer.class));
            keys.put(KKey.of("K2222"), KKeyMetadata.of("MEANZREF", Integer.class, 5));
            keys.put(KKey.of("K2244"), KKeyMetadata.of("MEREFPKTX", Integer.class, 5));
            keys.put(KKey.of("K2245"), KKeyMetadata.of("MEREFPKTY", Integer.class, 5));
            keys.put(KKey.of("K2246"), KKeyMetadata.of("MEREFPKTZ", Integer.class, 5));
            keys.put(KKey.of("K2430"), KKeyMetadata.of("ME_2430", Integer.class, 5));
            keys.put(KKey.of("K2432"), KKeyMetadata.of("ME_2432", Integer.class, 5));
            keys.put(KKey.of("K2434"), KKeyMetadata.of("ME_2434", Integer.class, 5));
            keys.put(KKey.of("K2436"), KKeyMetadata.of("ME_2436", String.class, 10));
            keys.put(KKey.of("K2438"), KKeyMetadata.of("ME_2438", String.class, 10));
            keys.put(KKey.of("K2440"), KKeyMetadata.of("ME_2440", String.class, 40));
            keys.put(KKey.of("K2442"), KKeyMetadata.of("ME_2442", String.class, 12));
            keys.put(KKey.of("K2444"), KKeyMetadata.of("ME_2444", String.class, 40));
            keys.put(KKey.of("K2448"), KKeyMetadata.of("ME_2446", String.class, 40));
            keys.put(KKey.of("K2448"), KKeyMetadata.of("ME_2448", String.class, 40));
            keys.put(KKey.of("K2073"), KKeyMetadata.of("ME_2073", BigDecimal.class, 22));
            keys.put(KKey.of("K2107"), KKeyMetadata.of("ME_2107", BigDecimal.class));
            keys.put(KKey.of("K2170"), KKeyMetadata.of("ME_2170", BigDecimal.class, 22));
            keys.put(KKey.of("K2171"), KKeyMetadata.of("ME_2171", BigDecimal.class, 22));
            keys.put(KKey.of("K2172"), KKeyMetadata.of("ME_2172", BigDecimal.class, 22));
            keys.put(KKey.of("K2173"), KKeyMetadata.of("ME_2173", BigDecimal.class, 22));
            keys.put(KKey.of("K2228"), KKeyMetadata.of("ME_2228", BigDecimal.class, 22));
            keys.put(KKey.of("K2229"), KKeyMetadata.of("ME_2229", BigDecimal.class));
            keys.put(KKey.of("K2230"), KKeyMetadata.of("ME_2230", BigDecimal.class));
            keys.put(KKey.of("K2231"), KKeyMetadata.of("ME_2231", BigDecimal.class));
            keys.put(KKey.of("K2232"), KKeyMetadata.of("ME_2232", BigDecimal.class));
            keys.put(KKey.of("K2233"), KKeyMetadata.of("ME_2233", BigDecimal.class, 22));
            keys.put(KKey.of("K2235"), KKeyMetadata.of("ME_2235", BigDecimal.class, 22));
            keys.put(KKey.of("K2236"), KKeyMetadata.of("ME_2236", BigDecimal.class, 22));
            keys.put(KKey.of("K2016"), KKeyMetadata.of("ME_2016", Integer.class, 3));
            keys.put(KKey.of("K8500"), KKeyMetadata.of("MEUMFPROZ", Integer.class, 5));
            keys.put(KKey.of("K8501"), KKeyMetadata.of("MEGLEITSTUMF", Integer.class, 3));
            keys.put(KKey.of("K8502"), KKeyMetadata.of("MESTIFREQT", String.class, 40));
            keys.put(KKey.of("K8504"), KKeyMetadata.of("MESTIFREQ", Integer.class, 5));
            keys.put(KKey.of("K8510"), KKeyMetadata.of("MECP", BigDecimal.class, 22));
            keys.put(KKey.of("K8511"), KKeyMetadata.of("MECPK", BigDecimal.class, 22));
            keys.put(KKey.of("K8520"), KKeyMetadata.of("MEVORGCP", BigDecimal.class, 22));
            keys.put(KKey.of("K8521"), KKeyMetadata.of("MEVORGCPK", BigDecimal.class, 22));
            keys.put(KKey.of("K8522"), KKeyMetadata.of("MECPFIX", BigDecimal.class, 22));
            keys.put(KKey.of("K8523"), KKeyMetadata.of("MECPKFIX", BigDecimal.class, 22));
            keys.put(KKey.of("K8530"), KKeyMetadata.of("ME_8530", Integer.class, 5));
            keys.put(KKey.of("K8531"), KKeyMetadata.of("ME_8531", BigDecimal.class, 22));
            keys.put(KKey.of("K8532"), KKeyMetadata.of("ME_8532", BigDecimal.class, 22));
            keys.put(KKey.of("K8540"), KKeyMetadata.of("ME_8540", Integer.class, 5));
            keys.put(KKey.of("K8600"), KKeyMetadata.of("MEKORRSTRAT", Integer.class, 3));
            keys.put(KKey.of("K8610"), KKeyMetadata.of("MEUKG", BigDecimal.class, 22));
            keys.put(KKey.of("K8611"), KKeyMetadata.of("MEOKG", BigDecimal.class, 22));
            keys.put(KKey.of("K8612"), KKeyMetadata.of("MEPUFFERSIZE", Integer.class, 3));
            keys.put(KKey.of("K8613"), KKeyMetadata.of("MEKORRZIEL", BigDecimal.class, 22));
            return keys;
        }
    }

    private static class CustomKKeyProvider
    implements IKKeyProvider {
        private CustomKKeyProvider() {
        }

        @Override
        public Map<KKey, KKeyMetadata> createKKeysWithMetadata() {
            HashMap<KKey, KKeyMetadata> keys = new HashMap<KKey, KKeyMetadata>();
            keys.put(KKey.of("K0001"), KKeyMetadata.builder().columnName("WVWERT").dataType(BigDecimal.class).respectsCharacteristicDecimalSettings(true).build());
            keys.put(KKey.of("K2100"), KKeyMetadata.builder().columnName("MEZIELWERT").dataType(BigDecimal.class).respectsCharacteristicDecimalSettings(true).build());
            keys.put(KKey.of("K2101"), KKeyMetadata.builder().columnName("MENENNMAS").dataType(BigDecimal.class).respectsCharacteristicDecimalSettings(true).build());
            keys.put(KKey.of("K2110"), KKeyMetadata.builder().columnName("MEUGW").dataType(BigDecimal.class).respectsCharacteristicDecimalSettings(true).build());
            keys.put(KKey.of("K2111"), KKeyMetadata.builder().columnName("MEOGW").dataType(BigDecimal.class).respectsCharacteristicDecimalSettings(true).build());
            keys.put(KKey.of("K2114"), KKeyMetadata.builder().columnName("MEUGSCHROTT").dataType(BigDecimal.class).respectsCharacteristicDecimalSettings(true).build());
            keys.put(KKey.of("K2115"), KKeyMetadata.builder().columnName("MEOGSCHROTT").dataType(BigDecimal.class).respectsCharacteristicDecimalSettings(true).build());
            keys.put(KKey.of("K2116"), KKeyMetadata.builder().columnName("MENORMISTUN").dataType(BigDecimal.class).respectsCharacteristicDecimalSettings(true).build());
            keys.put(KKey.of("K2117"), KKeyMetadata.builder().columnName("MENORMISTOB").dataType(BigDecimal.class).respectsCharacteristicDecimalSettings(true).build());
            keys.put(KKey.of("K2130"), KKeyMetadata.builder().columnName("MEPLAUSIUN").dataType(BigDecimal.class).respectsCharacteristicDecimalSettings(true).build());
            keys.put(KKey.of("K2131"), KKeyMetadata.builder().columnName("MEPLAUSIOB").dataType(BigDecimal.class).respectsCharacteristicDecimalSettings(true).build());
            keys.put(KKey.of("K0005"), KKeyMetadata.builder().columnName("WV0005").dataType(List.class, new K0005ValueConverter()).build());
            keys.put(KKey.of("K0006"), KKeyMetadata.builder().columnName("WVCHARGE").dataType(String.class, new K0006ValueConverter()).build());
            keys.put(KKey.of("K0011"), KKeyMetadata.of("WV0011", String.class));
            keys.put(KKey.of("K1000"), KKeyMetadata.of("TETEIL", Integer.class, false));
            keys.put(KKey.of("K2000"), KKeyMetadata.of("MEMERKMAL", Integer.class, false));
            keys.put(KKey.of("K0000"), KKeyMetadata.of("WVWERTNR", Integer.class, false));
            keys.put(KKey.of("K1017"), KKeyMetadata.builder().columnName("TE_1017").dataType(Boolean.class, new BooleanKKeyValueConverter()).build());
            keys.put(KKey.of("K2112"), KKeyMetadata.builder().columnName("?K2112?").dataType(BigDecimal.class).saveToDb(false).respectsCharacteristicDecimalSettings(true).build());
            keys.put(KKey.of("K2113"), KKeyMetadata.builder().columnName("?K2113?").dataType(BigDecimal.class).saveToDb(false).respectsCharacteristicDecimalSettings(true).build());
            keys.put(KKey.of("K0020"), KKeyMetadata.builder().columnName("?K0020?").dataType(Integer.class, new K0020ValueConverter()).saveToDb(false).build());
            keys.put(KKey.of("K0021"), KKeyMetadata.of("?K0021?", Integer.class, false));
            keys.put(KKey.of("K1040"), KKeyMetadata.of("?K1040?", Integer.class, 5, false));
            keys.put(KKey.of("K2008"), KKeyMetadata.of("MEPRUEFORT", Integer.class));
            keys.put(KKey.of("K2015"), KKeyMetadata.of("MEGLMITT", Integer.class, 3));
            keys.put(KKey.of("K2023"), KKeyMetadata.of("METRANSART", Integer.class, 3));
            keys.put(KKey.of("K2031"), KKeyMetadata.of("MEUPPERMERKMAL", Integer.class, 5));
            keys.put(KKey.of("K2076"), KKeyMetadata.of("MEPRUEFBEGINND", Date.class));
            keys.put(KKey.of("K2080"), KKeyMetadata.of("MEMASSN", Integer.class, 5));
            keys.put(KKey.of("K2143"), KKeyMetadata.of("MEEINHREL", String.class, 20));
            keys.put(KKey.of("K2144"), KKeyMetadata.of("MEADDFAKREL", BigDecimal.class));
            keys.put(KKey.of("K2145"), KKeyMetadata.of("MEMULFAKREL", BigDecimal.class));
            keys.put(KKey.of("K2437"), KKeyMetadata.of("MEPRUEFENDED", Date.class));
            keys.put(KKey.of("K2630"), KKeyMetadata.of("?K2630?", BigDecimal.class, false));
            keys.put(KKey.of("K2631"), KKeyMetadata.of("?K2631?", BigDecimal.class, false));
            keys.put(KKey.of("K2017"), KKeyMetadata.of("?K2017?", Integer.class, 3, false));
            keys.put(KKey.of("K2018"), KKeyMetadata.of("?K2018?", Integer.class, 3, false));
            keys.put(KKey.of("K2028"), KKeyMetadata.of("?K2028?", Integer.class, 3, false));
            keys.put(KKey.of("K2049"), KKeyMetadata.of("?K2049?", Integer.class, 3, false));
            keys.put(KKey.of("K2062"), KKeyMetadata.of("?K2062?", Integer.class, 5, false));
            keys.put(KKey.of("K2063"), KKeyMetadata.of("?K2063?", Integer.class, 5, false));
            keys.put(KKey.of("K2064"), KKeyMetadata.of("?K2064?", Integer.class, 5, false));
            keys.put(KKey.of("K2065"), KKeyMetadata.of("?K2065?", Integer.class, 5, false));
            keys.put(KKey.of("K2066"), KKeyMetadata.of("?K2066?", Integer.class, 5, false));
            keys.put(KKey.of("K2067"), KKeyMetadata.of("?K2067?", Integer.class, 5, false));
            keys.put(KKey.of("K2068"), KKeyMetadata.of("?K2068?", Integer.class, 5, false));
            keys.put(KKey.of("K2146"), KKeyMetadata.of("?K2146?", Integer.class, 3, false));
            keys.put(KKey.of("K2175"), KKeyMetadata.of("?K2175?", Integer.class, 3, false));
            keys.put(KKey.of("K2176"), KKeyMetadata.of("?K2176?", Integer.class, 3, false));
            keys.put(KKey.of("K2206"), KKeyMetadata.of("?K2206?", Integer.class, 5, false));
            keys.put(KKey.of("K2207"), KKeyMetadata.of("?K2207?", Integer.class, 5, false));
            keys.put(KKey.of("K2654"), KKeyMetadata.of("?K2654?", Integer.class, 3, false));
            keys.put(KKey.of("K2997"), KKeyMetadata.of("?K2997?", String.class, 100, false));
            keys.put(KKey.of("K0054"), KKeyMetadata.of("WV0054", String.class, 32));
            keys.put(KKey.of("K0055"), KKeyMetadata.of("WV0055", String.class, 32));
            keys.put(KKey.of("K0056"), KKeyMetadata.of("WV0056", String.class, 32));
            keys.put(KKey.of("K0057"), KKeyMetadata.of("WV0057", String.class, 32));
            keys.put(KKey.of("K0058"), KKeyMetadata.of("WV0058", String.class, 32));
            keys.put(KKey.of("K0059"), KKeyMetadata.of("WV0059", String.class, 32));
            keys.put(KKey.of("K0060"), KKeyMetadata.of("WV0060", String.class, 32));
            keys.put(KKey.of("K0061"), KKeyMetadata.of("WV0061", Integer.class, 10));
            keys.put(KKey.of("K0062"), KKeyMetadata.of("WV0062", Integer.class, 10));
            keys.put(KKey.of("K0063"), KKeyMetadata.of("WV0063", Integer.class, 10));
            keys.put(KKey.of("K0080"), KKeyMetadata.of("WV0080", String.class, 64));
            keys.put(KKey.of("K0081"), KKeyMetadata.of("WV0081", Integer.class, 5));
            keys.put(KKey.of("K5001"), KKeyMetadata.of("MEMERKNR", String.class, 20));
            keys.put(KKey.of("K5002"), KKeyMetadata.of("MEMERKBEZ", String.class, 80));
            keys.put(KKey.of("K5003"), KKeyMetadata.of("MEKURZBEZ", String.class, 20));
            keys.put(KKey.of("K5007"), KKeyMetadata.of("?K5007?", String.class, 20, false));
            keys.put(KKey.of("K5045"), KKeyMetadata.of("?K5045?", String.class, 80, false));
            keys.put(KKey.of("K5090"), KKeyMetadata.of("?K5090?", String.class, 255, false));
            keys.put(KKey.of("K5101"), KKeyMetadata.of("?K5101?", Integer.class, false));
            keys.put(KKey.of("K5102"), KKeyMetadata.of("?K5102?", Integer.class, false));
            keys.put(KKey.of("K5103"), KKeyMetadata.of("?K5103?", Integer.class, false));
            keys.put(KKey.of("K5111"), KKeyMetadata.of("?K5111?", Integer.class, false));
            keys.put(KKey.of("K5112"), KKeyMetadata.of("?K5112?", Integer.class, false));
            keys.put(KKey.of("K5113"), KKeyMetadata.of("?K5113?", Integer.class, false));
            keys.put(KKey.of("K8006"), KKeyMetadata.of("?K8006?", BigDecimal.class, false));
            keys.put(KKey.of("K8007"), KKeyMetadata.of("?K8007?", BigDecimal.class, false));
            keys.put(KKey.of("K8010"), KKeyMetadata.of("?K8010?", String.class, false));
            keys.put(KKey.of("K8011"), KKeyMetadata.of("?K8011?", BigDecimal.class, false));
            keys.put(KKey.of("K8012"), KKeyMetadata.of("?K8012?", BigDecimal.class, false));
            keys.put(KKey.of("K8013"), KKeyMetadata.of("?K8013?", BigDecimal.class, false));
            keys.put(KKey.of("K8014"), KKeyMetadata.of("?K8014?", BigDecimal.class, false));
            keys.put(KKey.of("K8015"), KKeyMetadata.of("?K8015?", BigDecimal.class, false));
            keys.put(KKey.of("K8106"), KKeyMetadata.of("?K8106?", BigDecimal.class, false));
            keys.put(KKey.of("K8107"), KKeyMetadata.of("?K8107?", BigDecimal.class, false));
            keys.put(KKey.of("K8110"), KKeyMetadata.of("?K8110?", String.class, false));
            keys.put(KKey.of("K8111"), KKeyMetadata.of("?K8111?", BigDecimal.class, false));
            keys.put(KKey.of("K8112"), KKeyMetadata.of("?K8112?", BigDecimal.class, false));
            keys.put(KKey.of("K8113"), KKeyMetadata.of("?K8113?", BigDecimal.class, false));
            keys.put(KKey.of("K8114"), KKeyMetadata.of("?K8114?", BigDecimal.class, false));
            keys.put(KKey.of("K8115"), KKeyMetadata.of("?K8115?", BigDecimal.class, false));
            keys.put(KKey.of("K8503"), KKeyMetadata.of("METRANSART", Integer.class, 3));
            keys.put(KKey.of("K8505"), KKeyMetadata.of("?K8505?", Integer.class, 5, false));
            keys.put(KKey.of("K8524"), KKeyMetadata.of("?K8524?", BigDecimal.class, false));
            keys.put(KKey.of("K8525"), KKeyMetadata.of("?K8525?", BigDecimal.class, false));
            keys.put(KKey.of("K1800"), KKeyMetadata.of("?K1800?", String.class, 50, false));
            keys.put(KKey.of("K1801"), KKeyMetadata.of("?K1801?", String.class, 1, false));
            keys.put(KKey.of("K1802"), KKeyMetadata.of("?K1802?", String.class, 255, false));
            keys.put(KKey.of("K1810"), KKeyMetadata.of("?K1810?", String.class, 50, false));
            keys.put(KKey.of("K1811"), KKeyMetadata.of("?K1811?", String.class, 1, false));
            keys.put(KKey.of("K1812"), KKeyMetadata.of("?K1812?", String.class, 255, false));
            keys.put(KKey.of("K1820"), KKeyMetadata.of("?K1820?", String.class, 50, false));
            keys.put(KKey.of("K1821"), KKeyMetadata.of("?K1821?", String.class, 1, false));
            keys.put(KKey.of("K1822"), KKeyMetadata.of("?K1822?", String.class, 255, false));
            keys.put(KKey.of("K1830"), KKeyMetadata.of("?K1830?", String.class, 50, false));
            keys.put(KKey.of("K1831"), KKeyMetadata.of("?K1831?", String.class, 1, false));
            keys.put(KKey.of("K1832"), KKeyMetadata.of("?K1832?", String.class, 255, false));
            keys.put(KKey.of("K1840"), KKeyMetadata.of("?K1840?", String.class, 50, false));
            keys.put(KKey.of("K1841"), KKeyMetadata.of("?K1841?", String.class, 1, false));
            keys.put(KKey.of("K1842"), KKeyMetadata.of("?K1842?", String.class, 255, false));
            keys.put(KKey.of("K1850"), KKeyMetadata.of("?K1850?", String.class, 50, false));
            keys.put(KKey.of("K1851"), KKeyMetadata.of("?K1851?", String.class, 1, false));
            keys.put(KKey.of("K1852"), KKeyMetadata.of("?K1852?", String.class, 255, false));
            keys.put(KKey.of("K1860"), KKeyMetadata.of("?K1860?", String.class, 50, false));
            keys.put(KKey.of("K1861"), KKeyMetadata.of("?K1861?", String.class, 1, false));
            keys.put(KKey.of("K1862"), KKeyMetadata.of("?K1862?", String.class, 255, false));
            keys.put(KKey.of("K1870"), KKeyMetadata.of("?K1870?", String.class, 50, false));
            keys.put(KKey.of("K1871"), KKeyMetadata.of("?K1871?", String.class, 1, false));
            keys.put(KKey.of("K1872"), KKeyMetadata.of("?K1872?", String.class, 255, false));
            keys.put(KKey.of("K1880"), KKeyMetadata.of("?K1880?", String.class, 50, false));
            keys.put(KKey.of("K1881"), KKeyMetadata.of("?K1881?", String.class, 1, false));
            keys.put(KKey.of("K1882"), KKeyMetadata.of("?K1882?", String.class, 255, false));
            keys.put(KKey.of("K1890"), KKeyMetadata.of("?K1890?", String.class, 50, false));
            keys.put(KKey.of("K1891"), KKeyMetadata.of("?K1891?", String.class, 1, false));
            keys.put(KKey.of("K1892"), KKeyMetadata.of("?K1892?", String.class, 255, false));
            keys.put(KKey.of("K2800"), KKeyMetadata.of("?K2800?", String.class, 50, false));
            keys.put(KKey.of("K2801"), KKeyMetadata.of("?K2801?", String.class, 1, false));
            keys.put(KKey.of("K2802"), KKeyMetadata.of("?K2802?", String.class, 255, false));
            keys.put(KKey.of("K2810"), KKeyMetadata.of("?K2810?", String.class, 50, false));
            keys.put(KKey.of("K2811"), KKeyMetadata.of("?K2811?", String.class, 1, false));
            keys.put(KKey.of("K2812"), KKeyMetadata.of("?K2812?", String.class, 255, false));
            keys.put(KKey.of("K2820"), KKeyMetadata.of("?K2820?", String.class, 50, false));
            keys.put(KKey.of("K2821"), KKeyMetadata.of("?K2821?", String.class, 1, false));
            keys.put(KKey.of("K2822"), KKeyMetadata.of("?K2822?", String.class, 255, false));
            keys.put(KKey.of("K2830"), KKeyMetadata.of("?K2830?", String.class, 50, false));
            keys.put(KKey.of("K2831"), KKeyMetadata.of("?K2831?", String.class, 1, false));
            keys.put(KKey.of("K2832"), KKeyMetadata.of("?K2832?", String.class, 255, false));
            keys.put(KKey.of("K2840"), KKeyMetadata.of("?K2840?", String.class, 50, false));
            keys.put(KKey.of("K2841"), KKeyMetadata.of("?K2841?", String.class, 1, false));
            keys.put(KKey.of("K2842"), KKeyMetadata.of("?K2842?", String.class, 255, false));
            keys.put(KKey.of("K2850"), KKeyMetadata.of("?K2850?", String.class, 50, false));
            keys.put(KKey.of("K2851"), KKeyMetadata.of("?K2851?", String.class, 1, false));
            keys.put(KKey.of("K2852"), KKeyMetadata.of("?K2852?", String.class, 255, false));
            keys.put(KKey.of("K2860"), KKeyMetadata.of("?K2860?", String.class, 50, false));
            keys.put(KKey.of("K2861"), KKeyMetadata.of("?K2861?", String.class, 1, false));
            keys.put(KKey.of("K2862"), KKeyMetadata.of("?K2862?", String.class, 255, false));
            keys.put(KKey.of("K2870"), KKeyMetadata.of("?K2870?", String.class, 50, false));
            keys.put(KKey.of("K2871"), KKeyMetadata.of("?K2871?", String.class, 1, false));
            keys.put(KKey.of("K2872"), KKeyMetadata.of("?K2872?", String.class, 255, false));
            keys.put(KKey.of("K2880"), KKeyMetadata.of("?K2880?", String.class, 50, false));
            keys.put(KKey.of("K2881"), KKeyMetadata.of("?K2881?", String.class, 1, false));
            keys.put(KKey.of("K2882"), KKeyMetadata.of("?K2882?", String.class, 255, false));
            keys.put(KKey.of("K2890"), KKeyMetadata.of("?K2890?", String.class, 50, false));
            keys.put(KKey.of("K2891"), KKeyMetadata.of("?K2891?", String.class, 1, false));
            keys.put(KKey.of("K2892"), KKeyMetadata.of("?K2892?", String.class, 255, false));
            return keys;
        }
    }
}

