/*
 * Decompiled with CFR 0.152.
 */
package cz.diribet.aqdef.parser.line;

import cz.diribet.aqdef.AqdefConstants;
import cz.diribet.aqdef.KKey;
import cz.diribet.aqdef.KKeyMetadata;
import cz.diribet.aqdef.KKeyRepository;
import cz.diribet.aqdef.convert.IKKeyValueConverter;
import cz.diribet.aqdef.model.AqdefObjectModel;
import cz.diribet.aqdef.parser.ParserContext;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLineParser
implements AqdefConstants {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLineParser.class);
    private final KKeyRepository kKeyRepository = KKeyRepository.getInstance();
    private boolean suppressInvalidKKeyLogging = false;
    private Set<KKey> suppressInvalidKKeyLoggingFor;

    public abstract boolean isLineSupported(String var1);

    public abstract void parseLine(String var1, AqdefObjectModel var2, ParserContext var3);

    protected Object convertValue(KKey key, String valueString, ParserContext parserContext) throws UnknownKKeyException, ValueConversionException {
        if (StringUtils.isBlank((CharSequence)valueString)) {
            return null;
        }
        KKeyMetadata kKeyMetadata = this.kKeyRepository.getMetadataFor(key);
        if (kKeyMetadata == null) {
            if (this.isInvalidKKeyLoggingEnabled(key)) {
                LOG.warn("{} Unknown k-key: {}. Value will be discarded.", (Object)ParserContext.lineLogContext(parserContext), (Object)key);
            }
            throw new UnknownKKeyException(key);
        }
        IKKeyValueConverter<?> converter = kKeyMetadata.getConverter();
        try {
            return converter.convert(valueString);
        }
        catch (Throwable e) {
            if (this.isInvalidKKeyLoggingEnabled(key)) {
                String message = ParserContext.lineLogContext(parserContext) + " Failed to convert value: " + valueString + " of K-key: " + key + " using converter: " + converter + ". The value will be discarded.";
                LOG.warn(message, e);
            }
            throw new ValueConversionException(valueString, key, converter, e);
        }
    }

    protected boolean isInvalidKKeyLoggingEnabled(KKey kKey) {
        if (this.suppressInvalidKKeyLogging) {
            return false;
        }
        return this.suppressInvalidKKeyLoggingFor == null || !this.suppressInvalidKKeyLoggingFor.contains(kKey);
    }

    public KKeyRepository getKKeyRepository() {
        return this.kKeyRepository;
    }

    public boolean isSuppressInvalidKKeyLogging() {
        return this.suppressInvalidKKeyLogging;
    }

    public Set<KKey> getSuppressInvalidKKeyLoggingFor() {
        return this.suppressInvalidKKeyLoggingFor;
    }

    public void setSuppressInvalidKKeyLogging(boolean suppressInvalidKKeyLogging) {
        this.suppressInvalidKKeyLogging = suppressInvalidKKeyLogging;
    }

    public void setSuppressInvalidKKeyLoggingFor(Set<KKey> suppressInvalidKKeyLoggingFor) {
        this.suppressInvalidKKeyLoggingFor = suppressInvalidKKeyLoggingFor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractLineParser)) {
            return false;
        }
        AbstractLineParser other = (AbstractLineParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuppressInvalidKKeyLogging() != other.isSuppressInvalidKKeyLogging()) {
            return false;
        }
        KKeyRepository this$kKeyRepository = this.getKKeyRepository();
        KKeyRepository other$kKeyRepository = other.getKKeyRepository();
        if (this$kKeyRepository == null ? other$kKeyRepository != null : !this$kKeyRepository.equals(other$kKeyRepository)) {
            return false;
        }
        Set<KKey> this$suppressInvalidKKeyLoggingFor = this.getSuppressInvalidKKeyLoggingFor();
        Set<KKey> other$suppressInvalidKKeyLoggingFor = other.getSuppressInvalidKKeyLoggingFor();
        return !(this$suppressInvalidKKeyLoggingFor == null ? other$suppressInvalidKKeyLoggingFor != null : !((Object)this$suppressInvalidKKeyLoggingFor).equals(other$suppressInvalidKKeyLoggingFor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractLineParser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuppressInvalidKKeyLogging() ? 79 : 97);
        KKeyRepository $kKeyRepository = this.getKKeyRepository();
        result = result * 59 + ($kKeyRepository == null ? 43 : $kKeyRepository.hashCode());
        Set<KKey> $suppressInvalidKKeyLoggingFor = this.getSuppressInvalidKKeyLoggingFor();
        result = result * 59 + ($suppressInvalidKKeyLoggingFor == null ? 43 : ((Object)$suppressInvalidKKeyLoggingFor).hashCode());
        return result;
    }

    public String toString() {
        return "AbstractLineParser(kKeyRepository=" + this.getKKeyRepository() + ", suppressInvalidKKeyLogging=" + this.isSuppressInvalidKKeyLogging() + ", suppressInvalidKKeyLoggingFor=" + this.getSuppressInvalidKKeyLoggingFor() + ")";
    }

    static class ValueConversionException
    extends Exception {
        private final String value;
        private final KKey key;
        private final IKKeyValueConverter<?> converter;

        ValueConversionException(String value, KKey key, IKKeyValueConverter<?> converter, Throwable cause) {
            super(cause);
            this.value = value;
            this.key = key;
            this.converter = converter;
        }

        public String getValue() {
            return this.value;
        }

        public KKey getKey() {
            return this.key;
        }

        public IKKeyValueConverter<?> getConverter() {
            return this.converter;
        }
    }

    static class UnknownKKeyException
    extends Exception {
        private final KKey key;

        public UnknownKKeyException(KKey key) {
            this.key = key;
        }

        public KKey getKey() {
            return this.key;
        }
    }
}

