/*
 * Decompiled with CFR 0.152.
 */
package cz.diribet.aqdef.parser.line;

import cz.diribet.aqdef.AqdefValidityException;
import cz.diribet.aqdef.KKey;
import cz.diribet.aqdef.convert.BigDecimalKKeyValueConverter;
import cz.diribet.aqdef.convert.KKeyValueConversionException;
import cz.diribet.aqdef.model.AqdefObjectModel;
import cz.diribet.aqdef.model.CharacteristicIndex;
import cz.diribet.aqdef.model.PartIndex;
import cz.diribet.aqdef.model.ValueIndex;
import cz.diribet.aqdef.parser.ParserContext;
import cz.diribet.aqdef.parser.line.AbstractLineParser;
import lombok.NonNull;

public class BinaryLineParser
extends AbstractLineParser {
    private static final String IGNORED_BINARY_KEY = "ignore";
    private static final String[] BINARY_VALUE_PORTIONS = new String[]{"K0001", "K0002", "K0004", "K0005", "K0006", "K0007", "K0008", "K0010", "K0011", "K0012"};
    private static final String[] BINARY_ATTRIBUTE_VALUE_PORTIONS = new String[]{"K0020", "K0021", "ignore", "K0002", "K0004", "K0005", "K0006", "K0007", "K0008", "K0010", "K0011", "K0012"};

    @Override
    public boolean isLineSupported(@NonNull String line) {
        if (line == null) {
            throw new NullPointerException("line is marked non-null but is null");
        }
        if (line.contains(MEASURED_VALUES_CHARACTERISTIC_SEPARATOR) || line.contains(MEASURED_VALUES_DATA_SEPARATOR)) {
            return true;
        }
        try {
            new BigDecimalKKeyValueConverter().convert(line);
            return true;
        }
        catch (KKeyValueConversionException kKeyValueConversionException) {
            return false;
        }
    }

    @Override
    public void parseLine(@NonNull String line, @NonNull AqdefObjectModel aqdefObjectModel, @NonNull ParserContext parserContext) {
        if (line == null) {
            throw new NullPointerException("line is marked non-null but is null");
        }
        if (aqdefObjectModel == null) {
            throw new NullPointerException("aqdefObjectModel is marked non-null but is null");
        }
        if (parserContext == null) {
            throw new NullPointerException("parserContext is marked non-null but is null");
        }
        String[] characteristicPortions = line.split(MEASURED_VALUES_CHARACTERISTIC_SEPARATOR);
        int characteristicIntIndex = 1;
        for (String characteristicPortion : characteristicPortions) {
            Integer characteristicType;
            String[] dataPortions = characteristicPortion.split(MEASURED_VALUES_DATA_SEPARATOR);
            PartIndex partIndex = aqdefObjectModel.findPartIndexForCharacteristic(characteristicIntIndex);
            if (partIndex == null) {
                throw new AqdefValidityException("Characteristic with index " + characteristicIntIndex + " was not found. Can't parse value.");
            }
            CharacteristicIndex characteristicIndex = CharacteristicIndex.of(partIndex, (Integer)characteristicIntIndex);
            Boolean isAttributeCharacteristic = null;
            AqdefObjectModel.CharacteristicEntries characteristicEntries = aqdefObjectModel.getCharacteristicEntries(characteristicIndex);
            if (characteristicEntries != null && (characteristicType = (Integer)characteristicEntries.getValue("K2004")) != null) {
                switch (characteristicType) {
                    case 1: 
                    case 5: 
                    case 6: {
                        isAttributeCharacteristic = true;
                        break;
                    }
                    default: {
                        isAttributeCharacteristic = false;
                    }
                }
            }
            if (isAttributeCharacteristic == null) {
                isAttributeCharacteristic = dataPortions.length > 10;
            }
            String[] dataPortionKeys = isAttributeCharacteristic != false ? BINARY_ATTRIBUTE_VALUE_PORTIONS : BINARY_VALUE_PORTIONS;
            for (int i = 0; i < dataPortions.length; ++i) {
                Object value;
                String dataPortion = dataPortions[i];
                String key = dataPortionKeys[i];
                if (IGNORED_BINARY_KEY.equals(key)) continue;
                KKey kKey = KKey.of(key);
                try {
                    value = this.convertValue(kKey, dataPortion, parserContext);
                }
                catch (AbstractLineParser.UnknownKKeyException | AbstractLineParser.ValueConversionException e) {
                    value = null;
                }
                if (value == null) continue;
                ValueIndex valueIndex = parserContext.getValueIndexCounter().getIndex(characteristicIndex, kKey);
                aqdefObjectModel.putValueEntry(kKey, valueIndex, value);
            }
            ++characteristicIntIndex;
        }
    }
}

