/*
 * Decompiled with CFR 0.152.
 */
package cz.diribet.aqdef.model;

import cz.diribet.aqdef.KKey;
import cz.diribet.aqdef.model.IHasKKeyValues;
import java.util.Objects;

public class CharacteristicEntriesAggregator
implements IHasKKeyValues {
    private final IHasKKeyValues partEntries;
    private final IHasKKeyValues characteristicEntries;

    public CharacteristicEntriesAggregator(IHasKKeyValues partEntries, IHasKKeyValues characteristicEntries) {
        this.partEntries = Objects.requireNonNull(partEntries);
        this.characteristicEntries = Objects.requireNonNull(characteristicEntries);
    }

    @Override
    public <T> T getValue(KKey kKey) {
        KKey.Level level = kKey.getLevel();
        switch (level) {
            case PART: 
            case CUSTOM_PART: {
                return this.partEntries.getValue(kKey);
            }
            case CHARACTERISTIC: 
            case CUSTOM_CHARACTERISTIC: {
                return this.characteristicEntries.getValue(kKey);
            }
        }
        return null;
    }

    public IHasKKeyValues getPartEntries() {
        return this.partEntries;
    }

    public IHasKKeyValues getCharacteristicEntries() {
        return this.characteristicEntries;
    }
}

