/*
 * Decompiled with CFR 0.152.
 */
package cz.diribet.aqdef.model.builder;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import cz.diribet.aqdef.AqdefConstants;
import cz.diribet.aqdef.KKey;
import cz.diribet.aqdef.model.AqdefHierarchy;
import cz.diribet.aqdef.model.CharacteristicIndex;
import cz.diribet.aqdef.model.NodeIndex;
import cz.diribet.aqdef.model.PartIndex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AqdefHierarchyBuilder
implements AqdefConstants {
    private static final Logger LOG = LoggerFactory.getLogger(AqdefHierarchyBuilder.class);
    private boolean containsHierarchy = false;
    private final List<AbstractHierarchyNode> nodes = new ArrayList<AbstractHierarchyNode>();
    private final List<AbstractNodeBindingToParent> nodeBindings = new ArrayList<AbstractNodeBindingToParent>();
    private final Map<Integer, Integer> partIndexToHierarchyNodeIndex = new HashMap<Integer, Integer>();
    private final BiMap<CharacteristicId, Integer> characteristicIdToHierarchyNodeIndex = HashBiMap.create();

    AqdefHierarchyBuilder() {
    }

    public AqdefHierarchy getHierarchy() {
        AqdefHierarchy hierarchy = new AqdefHierarchy();
        if (this.containsHierarchy) {
            try {
                this.writeNodes(hierarchy);
                this.writeNodeBindings(hierarchy);
            }
            catch (InvalidHierarchyException e) {
                LOG.warn("AQDEF hierarchy was not created. Reason: {}", (Object)e.getMessage());
                hierarchy = new AqdefHierarchy();
            }
        }
        return hierarchy;
    }

    private void writeNodes(AqdefHierarchy hierarchy) {
        for (AbstractHierarchyNode node : this.nodes) {
            hierarchy.putEntry(node.createEntry());
        }
    }

    private void writeNodeBindings(AqdefHierarchy hierarchy) throws InvalidHierarchyException {
        for (AbstractNodeBindingToParent nodeBinding : this.nodeBindings) {
            Integer identifier;
            KKey kKey;
            Integer parentNodeIndex;
            CharacteristicId parentCharacteristicId = nodeBinding.getParentCharacteristicId();
            if (parentCharacteristicId.getCharacteristicId() == null) {
                Integer partIndex = nodeBinding.getParentCharacteristicId().getPartIndex();
                parentNodeIndex = this.partIndexToHierarchyNodeIndex.get(partIndex);
                if (parentNodeIndex == null) {
                    String message = "Part with index (" + partIndex + ") was not found in given data.";
                    throw new InvalidHierarchyException(message);
                }
            } else {
                parentNodeIndex = (Integer)this.characteristicIdToHierarchyNodeIndex.get((Object)parentCharacteristicId);
                if (parentNodeIndex == null) {
                    String message = "Characteristic with part index " + parentCharacteristicId.getPartIndex() + " and characteristic id " + parentCharacteristicId.getCharacteristicId() + " was not found in given data.";
                    throw new InvalidHierarchyException(message);
                }
            }
            if (this.isNode(nodeBinding)) {
                kKey = KKey.of("K5103");
                identifier = nodeBinding.getHierarchyNodeIndex();
            } else {
                if (!(nodeBinding instanceof CharacteristicNodeBindingToParent)) {
                    throw new IllegalStateException("Binding should be CharacteristicNodeBindingToParent.");
                }
                CharacteristicNodeBindingToParent characteristicNodeBinding = (CharacteristicNodeBindingToParent)nodeBinding;
                identifier = characteristicNodeBinding.getCharacteristicIndex();
                kKey = KKey.of("K5102");
            }
            AqdefHierarchy.HierarchyEntry entry = new AqdefHierarchy.HierarchyEntry(kKey, NodeIndex.of(parentNodeIndex), identifier);
            hierarchy.putEntry(entry);
        }
    }

    private boolean isNode(AbstractNodeBindingToParent nodeBinding) {
        return nodeBinding instanceof GroupNodeBindingToParent || this.characteristicContainsChildCharacteristics(nodeBinding.getHierarchyNodeIndex());
    }

    private boolean characteristicContainsChildCharacteristics(Integer hierarchyNodeIndex) {
        CharacteristicId characteristicId = (CharacteristicId)this.characteristicIdToHierarchyNodeIndex.inverse().get((Object)hierarchyNodeIndex);
        return this.nodeBindings.stream().anyMatch(nodeBinding -> {
            CharacteristicId parentCharacteristicId = nodeBinding.getParentCharacteristicId();
            return parentCharacteristicId != null && parentCharacteristicId.equals(characteristicId);
        });
    }

    public void createHierarchyNodeOfPart(int hierarchyNodeIndex, int partIndex) {
        this.nodes.add(new PartHierarchyNode(hierarchyNodeIndex, partIndex));
        this.partIndexToHierarchyNodeIndex.put(partIndex, hierarchyNodeIndex);
    }

    public void createHierarchyNodeOfCharacteristic(int hierarchyNodeIndex, int partIndex, int characteristicIndex, int characteristicId, Integer parentCharacteristicId) {
        parentCharacteristicId = this.resolveEmptyParentCharacteristicId(parentCharacteristicId);
        this.nodes.add(new CharacteristicHierarchyNode(hierarchyNodeIndex, partIndex, characteristicIndex));
        this.characteristicIdToHierarchyNodeIndex.put((Object)new CharacteristicId(partIndex, characteristicId), (Object)hierarchyNodeIndex);
        this.nodeBindings.add(new CharacteristicNodeBindingToParent(hierarchyNodeIndex, new CharacteristicId(partIndex, parentCharacteristicId), characteristicIndex));
        if (parentCharacteristicId != null) {
            this.containsHierarchy = true;
        }
    }

    public void createHierarchyNodeOfGroup(int hierarchyNodeIndex, int partIndex, int groupIndex, int characteristicId, Integer parentCharacteristicId) {
        parentCharacteristicId = this.resolveEmptyParentCharacteristicId(parentCharacteristicId);
        this.nodes.add(new GroupHierarchyNode(hierarchyNodeIndex, partIndex, groupIndex));
        this.characteristicIdToHierarchyNodeIndex.put((Object)new CharacteristicId(partIndex, characteristicId), (Object)hierarchyNodeIndex);
        this.nodeBindings.add(new GroupNodeBindingToParent(hierarchyNodeIndex, new CharacteristicId(partIndex, parentCharacteristicId)));
        this.containsHierarchy = true;
    }

    private Integer resolveEmptyParentCharacteristicId(Integer parentCharacteristicId) {
        if (parentCharacteristicId != null && parentCharacteristicId == 0) {
            return null;
        }
        return parentCharacteristicId;
    }

    private static class InvalidHierarchyException
    extends Exception {
        public InvalidHierarchyException(String message) {
            super(message);
        }
    }

    public static class GroupHierarchyNode
    extends AbstractHierarchyNode {
        private final PartIndex partIndex;
        private final int groupIndex;

        public GroupHierarchyNode(int nodeIndex, Integer partIndex, int groupIndex) {
            super(nodeIndex);
            this.partIndex = PartIndex.of(partIndex);
            this.groupIndex = groupIndex;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.partIndex == null ? 0 : this.partIndex.hashCode());
            result = 31 * result + this.groupIndex;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof GroupHierarchyNode)) {
                return false;
            }
            GroupHierarchyNode other = (GroupHierarchyNode)obj;
            if (this.partIndex == null ? other.partIndex != null : !this.partIndex.equals(other.partIndex)) {
                return false;
            }
            return this.groupIndex == other.groupIndex;
        }

        @Override
        protected AqdefHierarchy.HierarchyEntry createEntry() {
            return new AqdefHierarchy.HierarchyEntry(KKey.of("K5113"), this.getNodeIndex(), this.groupIndex);
        }
    }

    public static class CharacteristicHierarchyNode
    extends AbstractHierarchyNode {
        private final CharacteristicIndex characteristicIndex;

        public CharacteristicHierarchyNode(int nodeIndex, Integer partIndex, int characteristicIndex) {
            super(nodeIndex);
            this.characteristicIndex = CharacteristicIndex.of(partIndex, (Integer)characteristicIndex);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.characteristicIndex == null ? 0 : this.characteristicIndex.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof CharacteristicHierarchyNode)) {
                return false;
            }
            CharacteristicHierarchyNode other = (CharacteristicHierarchyNode)obj;
            return !(this.characteristicIndex == null ? other.characteristicIndex != null : !this.characteristicIndex.equals(other.characteristicIndex));
        }

        @Override
        protected AqdefHierarchy.HierarchyEntry createEntry() {
            return new AqdefHierarchy.HierarchyEntry(KKey.of("K5112"), this.getNodeIndex(), this.characteristicIndex.getCharacteristicIndex());
        }
    }

    public static class PartHierarchyNode
    extends AbstractHierarchyNode {
        private final PartIndex partIndex;

        public PartHierarchyNode(int nodeIndex, int partIndex) {
            super(nodeIndex);
            this.partIndex = PartIndex.of(partIndex);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.partIndex == null ? 0 : this.partIndex.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof PartHierarchyNode)) {
                return false;
            }
            PartHierarchyNode other = (PartHierarchyNode)obj;
            return !(this.partIndex == null ? other.partIndex != null : !this.partIndex.equals(other.partIndex));
        }

        @Override
        protected AqdefHierarchy.HierarchyEntry createEntry() {
            return new AqdefHierarchy.HierarchyEntry(KKey.of("K5111"), this.getNodeIndex(), this.partIndex.getIndex());
        }
    }

    public static abstract class AbstractHierarchyNode {
        private final int nodeIndex;

        public AbstractHierarchyNode(int nodeIndex) {
            this.nodeIndex = nodeIndex;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.nodeIndex;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof AbstractHierarchyNode)) {
                return false;
            }
            AbstractHierarchyNode other = (AbstractHierarchyNode)obj;
            return this.nodeIndex == other.nodeIndex;
        }

        public NodeIndex getNodeIndex() {
            return NodeIndex.of(this.nodeIndex);
        }

        protected abstract AqdefHierarchy.HierarchyEntry createEntry();
    }

    private static class CharacteristicId {
        private final Integer partIndex;
        private final Integer characteristicId;

        public CharacteristicId(Integer partIndex, Integer characteristicId) {
            this.partIndex = partIndex;
            this.characteristicId = characteristicId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.partIndex == null ? 0 : this.partIndex.hashCode());
            result = 31 * result + (this.characteristicId == null ? 0 : this.characteristicId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof CharacteristicId)) {
                return false;
            }
            CharacteristicId other = (CharacteristicId)obj;
            if (this.partIndex == null ? other.partIndex != null : !this.partIndex.equals(other.partIndex)) {
                return false;
            }
            return !(this.characteristicId == null ? other.characteristicId != null : !this.characteristicId.equals(other.characteristicId));
        }

        public Integer getPartIndex() {
            return this.partIndex;
        }

        public Integer getCharacteristicId() {
            return this.characteristicId;
        }
    }

    private static class GroupNodeBindingToParent
    extends AbstractNodeBindingToParent {
        public GroupNodeBindingToParent(int hierarchyNodeIndex, CharacteristicId parentCharacteristicId) {
            super(hierarchyNodeIndex, parentCharacteristicId);
        }
    }

    private static class CharacteristicNodeBindingToParent
    extends AbstractNodeBindingToParent {
        private final int characteristicIndex;

        public CharacteristicNodeBindingToParent(int hierarchyNodeIndex, CharacteristicId parentCharacteristicId, int characteristicIndex) {
            super(hierarchyNodeIndex, parentCharacteristicId);
            this.characteristicIndex = characteristicIndex;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.characteristicIndex;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof CharacteristicNodeBindingToParent)) {
                return false;
            }
            CharacteristicNodeBindingToParent other = (CharacteristicNodeBindingToParent)obj;
            return this.characteristicIndex == other.characteristicIndex;
        }

        public int getCharacteristicIndex() {
            return this.characteristicIndex;
        }
    }

    private static abstract class AbstractNodeBindingToParent {
        private final int hierarchyNodeIndex;
        private final CharacteristicId parentCharacteristicId;

        public AbstractNodeBindingToParent(int hierarchyNodeIndex, CharacteristicId parentCharacteristicId) {
            this.hierarchyNodeIndex = hierarchyNodeIndex;
            this.parentCharacteristicId = parentCharacteristicId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.hierarchyNodeIndex;
            result = 31 * result + (this.parentCharacteristicId == null ? 0 : this.parentCharacteristicId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof AbstractNodeBindingToParent)) {
                return false;
            }
            AbstractNodeBindingToParent other = (AbstractNodeBindingToParent)obj;
            if (this.hierarchyNodeIndex != other.hierarchyNodeIndex) {
                return false;
            }
            return !(this.parentCharacteristicId == null ? other.parentCharacteristicId != null : !this.parentCharacteristicId.equals(other.parentCharacteristicId));
        }

        public int getHierarchyNodeIndex() {
            return this.hierarchyNodeIndex;
        }

        public CharacteristicId getParentCharacteristicId() {
            return this.parentCharacteristicId;
        }
    }
}

