/*
 * Decompiled with CFR 0.152.
 */
package cz.diribet.aqdef.writer;

import cz.diribet.aqdef.AqdefConstants;
import cz.diribet.aqdef.KKey;
import cz.diribet.aqdef.convert.IKKeyValueConverter;
import cz.diribet.aqdef.model.AqdefHierarchy;
import cz.diribet.aqdef.model.AqdefObjectModel;
import cz.diribet.aqdef.model.CharacteristicIndex;
import cz.diribet.aqdef.model.GroupIndex;
import cz.diribet.aqdef.model.NodeIndex;
import cz.diribet.aqdef.model.PartIndex;
import cz.diribet.aqdef.model.ValueIndex;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Comparator;
import lombok.NonNull;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.commons.lang3.StringUtils;

public class AqdefWriter
implements AqdefConstants {
    public String writeToString(@NonNull AqdefObjectModel aqdefObjectModel) {
        if (aqdefObjectModel == null) {
            throw new NullPointerException("aqdefObjectModel is marked non-null but is null");
        }
        StringBuilderWriter fileContent = new StringBuilderWriter();
        try {
            this.writeTo(aqdefObjectModel, (Writer)fileContent);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write AQDFQ model content", e);
        }
        return fileContent.toString();
    }

    public void writeTo(@NonNull AqdefObjectModel aqdefObjectModel, @NonNull Writer writer) throws IOException {
        if (aqdefObjectModel == null) {
            throw new NullPointerException("aqdefObjectModel is marked non-null but is null");
        }
        if (writer == null) {
            throw new NullPointerException("writer is marked non-null but is null");
        }
        this.writeEntries(aqdefObjectModel, writer);
    }

    private void writeEntries(AqdefObjectModel aqdefObjectModel, Writer writer) throws IOException {
        aqdefObjectModel.normalize();
        try {
            this.write("K0100", null, Integer.toString(aqdefObjectModel.getCharacteristicCount()), writer);
            aqdefObjectModel.forEachPart(part -> {
                this.write(part, writer);
                aqdefObjectModel.forEachCharacteristic(part, characteristic -> {
                    this.write(characteristic, writer);
                    aqdefObjectModel.forEachValue(part, characteristic, value -> this.write(value, writer));
                });
                aqdefObjectModel.forEachGroup(part, group -> this.write(group, writer));
            });
            aqdefObjectModel.getHierarchy().forEachNodeDefinition(nodeDefinition -> this.write((AqdefHierarchy.HierarchyEntry)nodeDefinition, writer));
            aqdefObjectModel.getHierarchy().forEachNodeBinding(nodeBinding -> this.write((AqdefHierarchy.HierarchyEntry)nodeBinding, writer));
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private void write(AqdefObjectModel.PartEntries part, Writer writer) throws UncheckedIOException {
        part.values().stream().sorted(Comparator.comparing(AqdefObjectModel.AbstractEntry::getKey)).forEach(partEntry -> this.write((AqdefObjectModel.PartEntry)partEntry, writer));
    }

    private void write(AqdefObjectModel.PartEntry entry, Writer writer) throws UncheckedIOException {
        KKey kKey = entry.getKey();
        this.write(kKey.getKey(), ((PartIndex)entry.getIndex()).getIndex(), this.convertValueOfKKey(kKey, entry.getValue()), writer);
    }

    private void write(AqdefObjectModel.CharacteristicEntries characteristic, Writer writer) throws UncheckedIOException {
        characteristic.values().stream().sorted(Comparator.comparing(AqdefObjectModel.AbstractEntry::getKey)).forEach(characteristicEntry -> this.write((AqdefObjectModel.CharacteristicEntry)characteristicEntry, writer));
    }

    private void write(AqdefObjectModel.CharacteristicEntry entry, Writer writer) throws UncheckedIOException {
        KKey kKey = entry.getKey();
        this.write(kKey.getKey(), ((CharacteristicIndex)entry.getIndex()).getCharacteristicIndex(), this.convertValueOfKKey(kKey, entry.getValue()), writer);
    }

    private void write(AqdefObjectModel.GroupEntries group, Writer writer) throws UncheckedIOException {
        group.values().stream().sorted(Comparator.comparing(AqdefObjectModel.AbstractEntry::getKey)).forEach(characteristicEntry -> this.write((AqdefObjectModel.GroupEntry)characteristicEntry, writer));
    }

    private void write(AqdefObjectModel.GroupEntry entry, Writer writer) throws UncheckedIOException {
        KKey kKey = entry.getKey();
        this.write(kKey.getKey(), ((GroupIndex)entry.getIndex()).getGroupIndex(), this.convertValueOfKKey(kKey, entry.getValue()), writer);
    }

    private void write(AqdefObjectModel.ValueEntries value, Writer writer) throws UncheckedIOException {
        value.values().stream().sorted(Comparator.comparing(AqdefObjectModel.AbstractEntry::getKey)).forEach(valueEntry -> this.write((AqdefObjectModel.ValueEntry)valueEntry, writer));
    }

    private void write(AqdefObjectModel.ValueEntry entry, Writer writer) throws UncheckedIOException {
        KKey kKey = entry.getKey();
        Integer characteristicIndex = ((ValueIndex)entry.getIndex()).getCharacteristicIndex().getCharacteristicIndex();
        String value = this.convertValueOfKKey(kKey, entry.getValue());
        this.write(kKey.getKey(), characteristicIndex, value, writer);
    }

    private void write(AqdefHierarchy.HierarchyEntry entry, Writer writer) throws UncheckedIOException {
        KKey kKey = entry.getKey();
        this.write(kKey.getKey(), ((NodeIndex)entry.getIndex()).getIndex(), this.convertValueOfKKey(kKey, entry.getValue()), writer);
    }

    private void write(String key, Integer index, String value, Writer writer) throws UncheckedIOException {
        try {
            writer.write(key);
            if (index != null) {
                writer.write("/");
                writer.write(index.toString());
            }
            writer.write(" ");
            writer.write(StringUtils.defaultString((String)value, (String)""));
            writer.write("\r\n");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String convertValueOfKKey(KKey kKey, Object value) {
        try {
            IKKeyValueConverter<?> converter = kKey.getConverter();
            if (converter == null) {
                throw new IllegalArgumentException("Can't find converter for k-key " + kKey);
            }
            return converter.toString(value);
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to convert value (" + value + ") of k-key " + kKey + " to string", e);
        }
    }
}

