/*
 * Decompiled with CFR 0.152.
 */
package cz.diribet.aqdef.parser.line;

import cz.diribet.aqdef.AqdefValidityException;
import cz.diribet.aqdef.KKey;
import cz.diribet.aqdef.model.AqdefObjectModel;
import cz.diribet.aqdef.model.CharacteristicIndex;
import cz.diribet.aqdef.model.GroupIndex;
import cz.diribet.aqdef.model.PartIndex;
import cz.diribet.aqdef.model.ValueIndex;
import cz.diribet.aqdef.parser.ParserContext;
import cz.diribet.aqdef.parser.line.AbstractLineParser;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KKeyLineParser
extends AbstractLineParser {
    private static final Logger LOG = LoggerFactory.getLogger(KKeyLineParser.class);
    private static final String[] IGNORED_KEYS = new String[]{"K0100", "K100", "K0101", "K101"};
    private static final String[] PROPRIETARY_QDAS_KEYS = new String[]{"K2999", "K5098", "K5080"};

    @Override
    public boolean isLineSupported(@NonNull String line) {
        if (line == null) {
            throw new NullPointerException("line is marked non-null but is null");
        }
        return line.startsWith("K");
    }

    @Override
    public void parseLine(@NonNull String line, @NonNull AqdefObjectModel aqdefObjectModel, @NonNull ParserContext parserContext) {
        Object value;
        String indexString;
        int firstSpaceIndex;
        if (line == null) {
            throw new NullPointerException("line is marked non-null but is null");
        }
        if (aqdefObjectModel == null) {
            throw new NullPointerException("aqdefObjectModel is marked non-null but is null");
        }
        if (parserContext == null) {
            throw new NullPointerException("parserContext is marked non-null but is null");
        }
        if (this.shouldIgnoreKKeyLine(line)) {
            return;
        }
        String key = line.substring(0, 5);
        KKey kKey = KKey.of(key);
        boolean hasIndex = false;
        if (line.length() > 5) {
            boolean bl = hasIndex = line.charAt(5) == '/';
        }
        if ((firstSpaceIndex = line.indexOf(" ", 5)) == -1) {
            firstSpaceIndex = line.length();
        }
        int index = 1;
        Integer valueIndexNumber = null;
        if (hasIndex && StringUtils.isNotBlank((CharSequence)(indexString = line.substring(6, firstSpaceIndex)))) {
            int valueIndexSeparatorPosition = indexString.indexOf("/");
            if (valueIndexSeparatorPosition == -1) {
                try {
                    index = Integer.parseInt(indexString);
                }
                catch (NumberFormatException e) {
                    throw new AqdefValidityException("K-key index is invalid: " + indexString, e);
                }
            } else if (kKey.isValueLevel()) {
                try {
                    index = Integer.parseInt(indexString.substring(0, valueIndexSeparatorPosition));
                    valueIndexNumber = Integer.valueOf(indexString.substring(valueIndexSeparatorPosition + 1));
                }
                catch (NumberFormatException e) {
                    throw new AqdefValidityException("K-key index is invalid: " + indexString, e);
                }
            } else {
                throw new AqdefValidityException("K-key index (" + indexString + ") contains a value index but the K-key (" + String.valueOf(kKey) + ") is not a value key.");
            }
        }
        String valueString = line.substring(firstSpaceIndex).trim();
        try {
            value = this.convertValue(kKey, valueString, parserContext);
        }
        catch (AbstractLineParser.UnknownKKeyException | AbstractLineParser.ValueConversionException e) {
            value = null;
        }
        if (value == null && !kKey.isValueLevel()) {
            return;
        }
        KKeyContext kKeyContext = KKeyContext.of(kKey, value, index, valueIndexNumber);
        if (kKey.isPartLevel()) {
            this.handlePartLevel(aqdefObjectModel, kKeyContext, parserContext);
        } else if (kKey.isCharacteristicLevel()) {
            this.handleCharacteristicLevel(aqdefObjectModel, kKeyContext, parserContext);
        } else if (kKey.isGroupLevel()) {
            this.handleGroupLevel(aqdefObjectModel, kKeyContext, parserContext);
        } else if (kKey.isValueLevel()) {
            this.handleValueLevel(aqdefObjectModel, kKeyContext, parserContext);
        } else if (kKey.isHierarchyLevel() || kKey.isSimpleHierarchyLevel()) {
            aqdefObjectModel.putHierarchyEntry(kKey, index, value);
        } else if (this.isInvalidKKeyLoggingEnabled(kKey)) {
            LOG.warn("{} Unknown level of k-key {}. Key will be ignored! ", (Object)ParserContext.lineLogContext(parserContext), (Object)kKey);
        }
    }

    private boolean shouldIgnoreKKeyLine(String line) {
        if (line.length() < 5) {
            return true;
        }
        for (String ignoredKey : IGNORED_KEYS) {
            if (!line.startsWith(ignoredKey + " ") && !line.startsWith(ignoredKey + "/")) continue;
            return true;
        }
        for (String proprietaryKey : PROPRIETARY_QDAS_KEYS) {
            if (!line.startsWith(proprietaryKey)) continue;
            return true;
        }
        return false;
    }

    private void handlePartLevel(AqdefObjectModel aqdefObjectModel, KKeyContext kKeyContext, ParserContext parserContext) {
        PartIndex partIndex = PartIndex.of(kKeyContext.getIndex());
        aqdefObjectModel.putPartEntry(kKeyContext.getKKey(), partIndex, kKeyContext.getValue());
        parserContext.setCurrentPartIndex(partIndex);
    }

    private void handleCharacteristicLevel(AqdefObjectModel aqdefObjectModel, KKeyContext kKeyContext, ParserContext parserContext) {
        PartIndex partIndex = this.getPartIndexForCharacteristicOrGroup(kKeyContext, parserContext);
        CharacteristicIndex characteristicIndex = CharacteristicIndex.of(partIndex, (Integer)kKeyContext.getIndex());
        aqdefObjectModel.putCharacteristicEntry(kKeyContext.getKKey(), characteristicIndex, kKeyContext.getValue());
    }

    private void handleGroupLevel(AqdefObjectModel aqdefObjectModel, KKeyContext kKeyContext, ParserContext parserContext) {
        PartIndex partIndex = this.getPartIndexForCharacteristicOrGroup(kKeyContext, parserContext);
        GroupIndex groupIndex = GroupIndex.of(partIndex, (Integer)kKeyContext.getIndex());
        aqdefObjectModel.putGroupEntry(kKeyContext.getKKey(), groupIndex, kKeyContext.getValue());
    }

    private PartIndex getPartIndexForCharacteristicOrGroup(KKeyContext kKeyContext, ParserContext parserContext) {
        if (kKeyContext.getIndex() == 0) {
            return PartIndex.of(0);
        }
        PartIndex partIndex = parserContext.getCurrentPartIndex();
        if (partIndex == null || partIndex.getIndex() == null || partIndex.getIndex() == 0) {
            partIndex = PartIndex.of(1);
        }
        return partIndex;
    }

    private void handleValueLevel(AqdefObjectModel aqdefObjectModel, KKeyContext kKeyContext, ParserContext parserContext) {
        PartIndex partIndex;
        KKey kKey = kKeyContext.getKKey();
        int index = kKeyContext.getIndex();
        Integer valueIndexNumber = kKeyContext.getValueIndexNumber();
        if (index == 0) {
            partIndex = PartIndex.of(0);
        } else {
            partIndex = aqdefObjectModel.findPartIndexForCharacteristic(index);
            if (partIndex == null) {
                throw new AqdefValidityException("Characteristic with index " + index + " was not found. Can't parse value.");
            }
        }
        CharacteristicIndex characteristicIndex = CharacteristicIndex.of(partIndex, (Integer)index);
        ValueIndex valueIndex = valueIndexNumber == null ? parserContext.getValueIndexCounter().getIndex(characteristicIndex, kKey) : ValueIndex.of(characteristicIndex, valueIndexNumber);
        aqdefObjectModel.putValueEntry(kKey, valueIndex, kKeyContext.getValue());
    }

    private static class KKeyContext {
        private final KKey kKey;
        private final Object value;
        private final int index;
        private final Integer valueIndexNumber;

        private KKeyContext(KKey kKey, Object value, int index, Integer valueIndexNumber) {
            this.kKey = kKey;
            this.value = value;
            this.index = index;
            this.valueIndexNumber = valueIndexNumber;
        }

        public static KKeyContext of(KKey kKey, Object value, int index, Integer valueIndexNumber) {
            return new KKeyContext(kKey, value, index, valueIndexNumber);
        }

        public KKey getKKey() {
            return this.kKey;
        }

        public Object getValue() {
            return this.value;
        }

        public int getIndex() {
            return this.index;
        }

        public Integer getValueIndexNumber() {
            return this.valueIndexNumber;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KKeyContext)) {
                return false;
            }
            KKeyContext other = (KKeyContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getIndex() != other.getIndex()) {
                return false;
            }
            Integer this$valueIndexNumber = this.getValueIndexNumber();
            Integer other$valueIndexNumber = other.getValueIndexNumber();
            if (this$valueIndexNumber == null ? other$valueIndexNumber != null : !((Object)this$valueIndexNumber).equals(other$valueIndexNumber)) {
                return false;
            }
            KKey this$kKey = this.getKKey();
            KKey other$kKey = other.getKKey();
            if (this$kKey == null ? other$kKey != null : !((Object)this$kKey).equals(other$kKey)) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof KKeyContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getIndex();
            Integer $valueIndexNumber = this.getValueIndexNumber();
            result = result * 59 + ($valueIndexNumber == null ? 43 : ((Object)$valueIndexNumber).hashCode());
            KKey $kKey = this.getKKey();
            result = result * 59 + ($kKey == null ? 43 : ((Object)$kKey).hashCode());
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "KKeyLineParser.KKeyContext(kKey=" + String.valueOf(this.getKKey()) + ", value=" + String.valueOf(this.getValue()) + ", index=" + this.getIndex() + ", valueIndexNumber=" + this.getValueIndexNumber() + ")";
        }
    }
}

