/*
 * Decompiled with CFR 0.152.
 */
package cz.diribet.chystat.api.client.impl;

import com.google.gson.Gson;
import cz.diribet.chystat.api.client.IApiClient;
import cz.diribet.chystat.api.client.InvalidResponseException;
import cz.diribet.chystat.api.client.ResponsePayload;
import cz.diribet.chystat.api.client.impl.OkHttpLogInterceptor;
import java.io.IOException;
import java.util.Objects;
import lombok.NonNull;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttpApiClient
implements IApiClient {
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private final Gson gson;
    private final String baseUrl;
    private OkHttpClient httpClient;

    public OkHttpApiClient(String baseUrl, @NonNull Gson gson) {
        if (gson == null) {
            throw new NullPointerException("gson is marked non-null but is null");
        }
        Objects.requireNonNull(baseUrl, "URL of the API is required");
        this.gson = gson;
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl.substring(0, baseUrl.length() - 1) : baseUrl;
    }

    @Override
    public ResponsePayload get(String path) throws IOException, InvalidResponseException {
        Request request = this.requestBuilder(path).get().build();
        return this.execute(request);
    }

    @Override
    public ResponsePayload post(String path, Object payload) throws IOException, InvalidResponseException {
        String payloadJson = this.toPayloadString(payload);
        RequestBody requestBody = RequestBody.create((String)payloadJson, (MediaType)JSON);
        Request request = this.requestBuilder(path).post(requestBody).build();
        return this.execute(request);
    }

    @Override
    public ResponsePayload put(String path, Object payload) throws IOException, InvalidResponseException {
        String payloadJson = this.toPayloadString(payload);
        RequestBody requestBody = RequestBody.create((String)payloadJson, (MediaType)JSON);
        Request request = this.requestBuilder(path).put(requestBody).build();
        return this.execute(request);
    }

    @Override
    public ResponsePayload patch(String path, Object payload) throws IOException, InvalidResponseException {
        String payloadJson = this.toPayloadString(payload);
        RequestBody requestBody = RequestBody.create((String)payloadJson, (MediaType)JSON);
        Request request = this.requestBuilder(path).patch(requestBody).build();
        return this.execute(request);
    }

    @Override
    public ResponsePayload delete(String path) throws IOException, InvalidResponseException {
        Request request = this.requestBuilder(path).delete().build();
        return this.execute(request);
    }

    private String toPayloadString(Object payload) {
        if (payload instanceof String) {
            return (String)payload;
        }
        return this.gson.toJson(payload);
    }

    protected Request.Builder requestBuilder(String path) {
        String url = this.baseUrl + path;
        return new Request.Builder().url(url);
    }

    protected OkHttpClient.Builder clientBuilder() {
        return new OkHttpClient.Builder().addNetworkInterceptor((Interceptor)OkHttpLogInterceptor.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponsePayload execute(Request request) throws IOException, InvalidResponseException {
        OkHttpApiClient okHttpApiClient = this;
        synchronized (okHttpApiClient) {
            if (this.httpClient == null) {
                this.httpClient = this.clientBuilder().build();
            }
        }
        try (Response response = this.httpClient.newCall(request).execute();){
            String body = response.body().string();
            if (response.isSuccessful()) {
                ResponsePayload responsePayload = new ResponsePayload(body, this.gson);
                return responsePayload;
            }
            throw new InvalidResponseException(response.code(), body);
        }
    }
}

