/*
 * Decompiled with CFR 0.152.
 */
package cz.diribet.chystat.api.client.jwt;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import cz.diribet.chystat.api.client.jwt.JwtTokenProvider;
import java.time.Duration;
import java.util.concurrent.ExecutionException;

public abstract class CachingJwtTokenProvider
implements JwtTokenProvider {
    private static final Object CACHE_KEY = new Object();
    private final LoadingCache<Object, String> cache;

    public CachingJwtTokenProvider() {
        CacheLoader cacheLoader = CacheLoader.from(this::getFreshJwtToken);
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(9L)).build(cacheLoader);
    }

    @Override
    public String getJwtToken() {
        try {
            return (String)this.cache.get(CACHE_KEY);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed to get JWT token from cache", e);
        }
    }

    protected abstract String getFreshJwtToken();
}

