/*
 * Decompiled with CFR 0.152.
 */
package cz.diribet.chystat.api.client.jwt;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import cz.diribet.chystat.api.client.jwt.CachingJwtTokenProvider;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import lombok.NonNull;

public class DefaultJwtTokenProvider
extends CachingJwtTokenProvider {
    @NonNull
    private final String tokenId;
    @NonNull
    private final String secret;

    @Override
    protected String getFreshJwtToken() {
        ZonedDateTime dateTime = ZonedDateTime.now(ZoneOffset.UTC);
        Date currentDate = Date.from(dateTime.toInstant());
        Algorithm signAlgorithm = Algorithm.HMAC256((String)this.secret);
        return JWT.create().withIssuedAt(currentDate).withSubject(this.tokenId).sign(signAlgorithm);
    }

    public DefaultJwtTokenProvider(@NonNull String tokenId, @NonNull String secret) {
        if (tokenId == null) {
            throw new NullPointerException("tokenId is marked non-null but is null");
        }
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        this.tokenId = tokenId;
        this.secret = secret;
    }
}

