/*
 * Decompiled with CFR 0.152.
 */
package cz.diribet.chystat.api.client.impl;

import com.google.gson.Gson;
import cz.diribet.chystat.api.client.impl.OkHttpApiClient;
import cz.diribet.chystat.api.client.jwt.JwtTokenProvider;
import okhttp3.Request;

public class ChystatApiClient
extends OkHttpApiClient {
    private final JwtTokenProvider jwtTokenProvider;

    public ChystatApiClient(String baseUrl, JwtTokenProvider jwtTokenProvider) {
        this(baseUrl, new Gson(), jwtTokenProvider);
    }

    public ChystatApiClient(String baseUrl, Gson gson, JwtTokenProvider jwtTokenProvider) {
        super(baseUrl, gson);
        this.jwtTokenProvider = jwtTokenProvider;
    }

    @Override
    protected Request.Builder requestBuilder(String path) {
        Request.Builder requestBuilder = super.requestBuilder(path);
        requestBuilder.header("Authorization", this.createAuthorizationHeaderValue());
        return requestBuilder;
    }

    private String createAuthorizationHeaderValue() {
        String jwtToken = this.jwtTokenProvider.getJwtToken();
        return "Bearer " + jwtToken;
    }
}

