/*
 * Decompiled with CFR 0.152.
 */
package cz.diribet.chystat.api.client.impl;

import com.google.gson.Gson;
import cz.diribet.chystat.api.client.impl.OkHttpApiClient;
import cz.diribet.chystat.api.client.jwt.JwtTokenProvider;
import java.time.Duration;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public class ChystatApiClient
extends OkHttpApiClient {
    private static final Duration READ_TIMEOUT = Duration.ofMinutes(1L);
    private final JwtTokenProvider jwtTokenProvider;

    public ChystatApiClient(String baseUrl, JwtTokenProvider jwtTokenProvider) {
        this(baseUrl, new Gson(), jwtTokenProvider);
    }

    public ChystatApiClient(String baseUrl, Gson gson, JwtTokenProvider jwtTokenProvider) {
        super(baseUrl, gson);
        this.jwtTokenProvider = jwtTokenProvider;
    }

    @Override
    protected OkHttpClient.Builder clientBuilder() {
        OkHttpClient.Builder builder = super.clientBuilder();
        builder.readTimeout(READ_TIMEOUT);
        return builder;
    }

    @Override
    protected Request.Builder requestBuilder(String path) {
        Request.Builder requestBuilder = super.requestBuilder(path);
        requestBuilder.header("Authorization", this.createAuthorizationHeaderValue());
        return requestBuilder;
    }

    private String createAuthorizationHeaderValue() {
        String jwtToken = this.jwtTokenProvider.getJwtToken();
        return "Bearer " + jwtToken;
    }
}

