/*
 * Decompiled with CFR 0.152.
 */
package cz.diribet.chystat.api.client.impl;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OkHttpLogInterceptor
implements Interceptor {
    private static final Logger LOG = LoggerFactory.getLogger(OkHttpLogInterceptor.class);
    public static final OkHttpLogInterceptor INSTANCE = new OkHttpLogInterceptor();
    private final HttpLoggingInterceptor loggingInterceptor;

    private OkHttpLogInterceptor() {
        HttpLoggingInterceptor.Logger logger = arg_0 -> ((Logger)LOG).debug(arg_0);
        this.loggingInterceptor = new HttpLoggingInterceptor(logger);
        this.loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        this.loggingInterceptor.redactHeader("Authorization");
        this.loggingInterceptor.redactHeader("Cookie");
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        if (LOG.isDebugEnabled()) {
            return this.loggingInterceptor.intercept(chain);
        }
        return chain.proceed(chain.request());
    }
}

