/*
 * Decompiled with CFR 0.152.
 */
package cz.encircled.jput;

import cz.encircled.jput.GenericJunitRunner;
import cz.encircled.jput.context.JPutContextKt;
import cz.encircled.jput.model.MethodConfiguration;
import cz.encircled.jput.model.PerfTestExecution;
import cz.encircled.jput.recorder.ResultRecorder;
import cz.encircled.jput.trend.TrendAnalyzer;
import cz.encircled.jput.trend.TrendResult;
import cz.encircled.jput.unit.PerformanceTest;
import cz.encircled.jput.unit.UnitPerformanceAnalyzer;
import cz.encircled.jput.unit.UnitPerformanceResult;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import junit.framework.AssertionFailedError;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.junit.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0019"}, d2={"Lcz/encircled/jput/GenericJunitRunnerImpl;", "Lcz/encircled/jput/GenericJunitRunner;", "()V", "executeTest", "", "frameworkMethod", "Lorg/junit/runners/model/FrameworkMethod;", "description", "Lorg/junit/runner/Description;", "statement", "Lorg/junit/runners/model/Statement;", "notifier", "Lorg/junit/runner/notification/RunNotifier;", "performAnalysis", "performanceAnalyzer", "Lcz/encircled/jput/unit/UnitPerformanceAnalyzer;", "execution", "Lcz/encircled/jput/model/PerfTestExecution;", "conf", "Lcz/encircled/jput/model/MethodConfiguration;", "trendAnalyzer", "Lcz/encircled/jput/trend/TrendAnalyzer;", "performExecution", "", "", "jput-core"})
public final class GenericJunitRunnerImpl
implements GenericJunitRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeTest(@NotNull FrameworkMethod frameworkMethod, @NotNull Description description, @NotNull Statement statement, @NotNull RunNotifier notifier) {
        Intrinsics.checkParameterIsNotNull((Object)frameworkMethod, (String)"frameworkMethod");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
        Intrinsics.checkParameterIsNotNull((Object)notifier, (String)"notifier");
        EachTestNotifier eachNotifier = new EachTestNotifier(notifier, description);
        eachNotifier.fireTestStarted();
        try {
            PerformanceTest annotation = (PerformanceTest)frameworkMethod.getAnnotation(PerformanceTest.class);
            if (annotation == null || !JPutContextKt.getContext().isPerformanceTestEnabled()) {
                statement.evaluate();
            } else {
                MethodConfiguration conf = MethodConfiguration.Companion.fromAnnotation(annotation);
                UnitPerformanceAnalyzer unitPerformanceAnalyzer = JPutContextKt.getContext().getUnitPerformanceAnalyzer();
                Method method = frameworkMethod.getMethod();
                Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"frameworkMethod.method");
                PerfTestExecution execution = unitPerformanceAnalyzer.buildTestExecution(conf, method);
                List<Long> result = this.performExecution(conf, statement);
                JPutContextKt.getContext().getUnitPerformanceAnalyzer().addTestExecutions(execution, result);
                this.performAnalysis(JPutContextKt.getContext().getUnitPerformanceAnalyzer(), execution, conf, JPutContextKt.getContext().getTrendAnalyzer());
                Iterable $receiver$iv = JPutContextKt.getContext().getResultRecorders();
                for (Object element$iv : $receiver$iv) {
                    ResultRecorder it = (ResultRecorder)element$iv;
                    boolean bl = false;
                    it.flush();
                }
            }
        }
        catch (AssumptionViolatedException e) {
            eachNotifier.addFailedAssumption((org.junit.internal.AssumptionViolatedException)e);
        }
        catch (Throwable e) {
            eachNotifier.addFailure(e);
        }
        finally {
            eachNotifier.fireTestFinished();
        }
    }

    private final void performAnalysis(UnitPerformanceAnalyzer performanceAnalyzer, PerfTestExecution execution, MethodConfiguration conf, TrendAnalyzer trendAnalyzer) {
        UnitPerformanceResult result = performanceAnalyzer.analyzeUnitTrend(execution, conf);
        if (result.isError()) {
            throw (Throwable)new AssertionFailedError("Unit performance test failed" + performanceAnalyzer.buildErrorMessage(result, conf));
        }
        if (conf.getTrendConfiguration() != null) {
            TrendResult trendResult;
            List<Long> sample = JPutContextKt.getContext().getResultRecorders().get(0).getSample(execution, conf.getTrendConfiguration());
            if (sample.size() >= conf.getTrendConfiguration().getSampleSize() && (trendResult = trendAnalyzer.analyzeTestTrend(conf.getTrendConfiguration(), execution, sample)).isError()) {
                throw (Throwable)new AssertionFailedError("Trend performance test failed" + trendAnalyzer.buildErrorMessage(trendResult, conf));
            }
            Iterable $receiver$iv = JPutContextKt.getContext().getResultRecorders();
            for (Object element$iv : $receiver$iv) {
                ResultRecorder it = (ResultRecorder)element$iv;
                boolean bl = false;
                it.appendTrendResult(execution);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Long> performExecution(MethodConfiguration conf, Statement statement) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        int n = conf.getWarmUp();
        int n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int it = n2++;
            boolean bl = false;
            statement.evaluate();
        }
        n = 1;
        Iterable iterable = $receiver$iv = (Iterable)new IntRange(n, conf.getRepeats());
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            int item$iv$iv;
            int n4 = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            long start = System.nanoTime();
            statement.evaluate();
            Long l = (System.nanoTime() - start) / 1000000L;
            collection.add(l);
        }
        return (List)destination$iv$iv;
    }
}

