/*
 * Decompiled with CFR 0.152.
 */
package cz.encircled.jput;

import cz.encircled.jput.JPutCommons;
import cz.encircled.jput.model.PerfTestExecution;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nJ\"\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\f\u001a\u00020\bJ\u0014\u0010\r\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nJ\u0014\u0010\u000e\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nJ\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\b\u00a8\u0006\u0012"}, d2={"Lcz/encircled/jput/Statistics;", "", "()V", "averageExecutionTime", "", "execution", "Lcz/encircled/jput/model/PerfTestExecution;", "getAverage", "", "input", "", "getPercentile", "percentile", "getStandardDeviation", "getVariance", "maxExecutionTime", "round", "value", "jput-core"})
public final class Statistics {
    public static final Statistics INSTANCE;

    public final double getAverage(@NotNull List<Long> input) {
        Intrinsics.checkParameterIsNotNull(input, (String)"input");
        double sum = 0.0;
        Iterator<Long> iterator = input.iterator();
        while (iterator.hasNext()) {
            long a = ((Number)iterator.next()).longValue();
            sum += (double)a;
        }
        return sum / (double)input.size();
    }

    public final double getStandardDeviation(@NotNull List<Long> input) {
        Intrinsics.checkParameterIsNotNull(input, (String)"input");
        double average = this.getAverage(input);
        double temp = 0.0;
        Iterator<Long> iterator = input.iterator();
        while (iterator.hasNext()) {
            long a = ((Number)iterator.next()).longValue();
            temp += ((double)a - average) * ((double)a - average);
        }
        return temp / (double)input.size();
    }

    public final double getVariance(@NotNull List<Long> input) {
        Intrinsics.checkParameterIsNotNull(input, (String)"input");
        return Math.sqrt(this.getStandardDeviation(input));
    }

    public final long round(double value) {
        return Math.round(value);
    }

    @NotNull
    public final List<Long> getPercentile(@NotNull List<Long> input, double percentile) {
        Intrinsics.checkParameterIsNotNull(input, (String)"input");
        JPutCommons.INSTANCE.validatePercentile(percentile);
        return input.subList(0, (int)Math.round((double)input.size() * percentile));
    }

    public final long maxExecutionTime(@NotNull PerfTestExecution execution) {
        Intrinsics.checkParameterIsNotNull((Object)execution, (String)"execution");
        Long l = (Long)CollectionsKt.max((Iterable)execution.getExecutionResult());
        if (l == null) {
            throw (Throwable)new IllegalStateException();
        }
        return l;
    }

    public final long averageExecutionTime(@NotNull PerfTestExecution execution) {
        Intrinsics.checkParameterIsNotNull((Object)execution, (String)"execution");
        double avg = CollectionsKt.averageOfLong((Iterable)execution.getExecutionResult());
        if (avg == DoubleCompanionObject.INSTANCE.getNaN()) {
            throw (Throwable)new IllegalStateException();
        }
        return Math.round(avg);
    }

    private Statistics() {
    }

    static {
        Statistics statistics;
        INSTANCE = statistics = new Statistics();
    }
}

