/*
 * Decompiled with CFR 0.152.
 */
package cz.encircled.jput.recorder;

import cz.encircled.jput.context.JPutContextKt;
import cz.encircled.jput.context.PropertySource;
import cz.encircled.jput.model.MethodTrendConfiguration;
import cz.encircled.jput.model.PerfTestExecution;
import cz.encircled.jput.recorder.ThreadsafeResultRecorder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u000bH\u0016J\u0016\u0010\r\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f2\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcz/encircled/jput/recorder/ElasticsearchResultRecorder;", "Lcz/encircled/jput/recorder/ThreadsafeResultRecorder;", "client", "Lorg/elasticsearch/client/RestHighLevelClient;", "(Lorg/elasticsearch/client/RestHighLevelClient;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "createIndexIfNeeded", "", "destroy", "doFlush", "data", "", "Lcz/encircled/jput/model/PerfTestExecution;", "getSample", "", "execution", "config", "Lcz/encircled/jput/model/MethodTrendConfiguration;", "jput-core"})
public final class ElasticsearchResultRecorder
extends ThreadsafeResultRecorder {
    private final Logger log;
    private final RestHighLevelClient client;

    public final Logger getLog() {
        return this.log;
    }

    @Override
    @NotNull
    public List<Long> getSample(@NotNull PerfTestExecution execution, @NotNull MethodTrendConfiguration config) {
        Object object;
        Object it;
        Collection collection;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        SearchResponse searchResponse;
        Intrinsics.checkParameterIsNotNull((Object)execution, (String)"execution");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        String string = execution.getTestId();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        sourceBuilder.query((QueryBuilder)QueryBuilders.matchQuery((String)"testId", (Object)string));
        SearchRequest request = new SearchRequest(new String[]{"jput"}).types(new String[]{"perf"}).source(sourceBuilder);
        SearchResponse searchResponse2 = searchResponse = this.client.search(request, RequestOptions.DEFAULT);
        Intrinsics.checkExpressionValueIsNotNull((Object)searchResponse2, (String)"searchResponse");
        SearchHits searchHits = searchResponse2.getHits();
        Intrinsics.checkExpressionValueIsNotNull((Object)searchHits, (String)"searchResponse.hits");
        Object[] objectArray = searchHits.getHits();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"searchResponse.hits.hits");
        List sample = this.subList(ArraysKt.toList((Object[])objectArray), config.getSampleSize(), config.getSampleSelectionStrategy());
        Iterable iterable = sample;
        void var8_8 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            Object runs;
            SearchHit searchHit = (SearchHit)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void v4 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"it");
            Object v = runs = v4.getSourceAsMap().get("runs");
            if (v == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<*>");
            }
            object = (List)v;
            collection.add(object);
        }
        $receiver$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            long l;
            Object item$iv$iv;
            it = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl = false;
            if (it instanceof Integer) {
                l = ((Number)it).intValue();
            } else {
                Object t = it;
                if (t == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Long");
                }
                l = (Long)t;
            }
            object = l;
            collection.add(object);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doFlush(@NotNull List<PerfTestExecution> data) {
        String string;
        String $receiver$iv$iv$iv;
        CharSequence $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        this.log.info("Do flush to Elasticsearch: " + data);
        String string2 = "jput.storage.elastic.type";
        String defaultValue$iv = "default";
        boolean $i$f$getProperty = false;
        Iterable iterable = JPutContextKt.getContext().getPropertySources();
        void var7_7 = $receiver$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv$iv = $receiver$iv$iv$iv;
        Iterator iterator = $receiver$iv$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string3;
            void key$iv;
            Object element$iv$iv$iv$iv;
            Object element$iv$iv$iv = element$iv$iv$iv$iv = iterator.next();
            PropertySource it$iv = (PropertySource)element$iv$iv$iv;
            boolean bl = false;
            if (it$iv.getProperty((String)key$iv) == null) continue;
            String it$iv$iv$iv = string3;
            destination$iv$iv$iv.add(it$iv$iv$iv);
        }
        String value$iv = (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv$iv));
        $receiver$iv$iv = value$iv;
        if ($receiver$iv$iv == null || StringsKt.isBlank((CharSequence)$receiver$iv$iv)) {
            string = defaultValue$iv;
        } else {
            $receiver$iv$iv = Reflection.getOrCreateKotlinClass(String.class);
            if (Intrinsics.areEqual((Object)$receiver$iv$iv, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                $receiver$iv$iv$iv = value$iv;
                string = (String)((Object)Boolean.valueOf(Boolean.parseBoolean($receiver$iv$iv$iv)));
            } else if (Intrinsics.areEqual((Object)$receiver$iv$iv, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                $receiver$iv$iv$iv = value$iv;
                string = (String)((Object)Integer.valueOf(Integer.parseInt($receiver$iv$iv$iv)));
            } else {
                string = value$iv;
                if (string == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
            }
        }
        String type = string;
        Iterable $receiver$iv = data;
        for (Object element$iv : $receiver$iv) {
            PerfTestExecution it = (PerfTestExecution)element$iv;
            boolean bl = false;
            Map jsonMap = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"executionId", (Object)JPutContextKt.getContext().getExecutionId()), TuplesKt.to((Object)"testId", (Object)it.getTestId()), TuplesKt.to((Object)"runs", it.getExecutionResult())});
            jsonMap.putAll(this.getUserDefinedEnvParams());
            IndexRequest indexRequest = Requests.indexRequest((String)"jput").type(type).source(jsonMap);
            this.client.index(indexRequest, RequestOptions.DEFAULT);
        }
        this.log.info("Flush to Elasticsearch done");
    }

    @Override
    public void destroy() {
        try {
            this.client.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void createIndexIfNeeded() {
        boolean exists = this.client.indices().exists((GetIndexRequest)new GetIndexRequest().indices(new String[]{"jput"}), RequestOptions.DEFAULT);
        if (!exists) {
            CreateIndexRequest createRequest = new CreateIndexRequest("jput");
            this.client.indices().create(createRequest, RequestOptions.DEFAULT);
        }
    }

    public ElasticsearchResultRecorder(@NotNull RestHighLevelClient client) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        this.client = client;
        this.log = LoggerFactory.getLogger(ElasticsearchResultRecorder.class);
        this.createIndexIfNeeded();
    }
}

