/*
 * Decompiled with CFR 0.152.
 */
package cz.encircled.jput.trend;

import cz.encircled.jput.Statistics;
import cz.encircled.jput.model.MethodConfiguration;
import cz.encircled.jput.model.MethodTrendConfiguration;
import cz.encircled.jput.model.PerfTestExecution;
import cz.encircled.jput.trend.TrendAnalyzer;
import cz.encircled.jput.trend.TrendResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0012\u00a8\u0006\u0013"}, d2={"Lcz/encircled/jput/trend/SampleBasedTrendAnalyzer;", "Lcz/encircled/jput/trend/TrendAnalyzer;", "()V", "analyzeTestTrend", "Lcz/encircled/jput/trend/TrendResult;", "configuration", "Lcz/encircled/jput/model/MethodTrendConfiguration;", "execution", "Lcz/encircled/jput/model/PerfTestExecution;", "sample", "", "", "buildErrorMessage", "", "result", "conf", "Lcz/encircled/jput/model/MethodConfiguration;", "collectRuns", "", "jput-core"})
public final class SampleBasedTrendAnalyzer
implements TrendAnalyzer {
    @Override
    @NotNull
    public TrendResult analyzeTestTrend(@NotNull MethodTrendConfiguration configuration, @NotNull PerfTestExecution execution, @NotNull List<Long> sample) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)execution, (String)"execution");
        Intrinsics.checkParameterIsNotNull(sample, (String)"sample");
        List<Long> sortedSample = CollectionsKt.sorted((Iterable)sample);
        if (configuration.getNoisePercentile() > 0.0) {
            sortedSample = Statistics.INSTANCE.getPercentile(sortedSample, configuration.getNoisePercentile());
        }
        double sampleAvg = Statistics.INSTANCE.getAverage(sortedSample);
        double avgThreshold = configuration.getUseSampleVarianceAsThreshold() ? Statistics.INSTANCE.getVariance(sortedSample) : sampleAvg * configuration.getAverageTimeThreshold();
        double executionAvg = Statistics.INSTANCE.getAverage(execution.getExecutionResult());
        if (executionAvg > sampleAvg + avgThreshold) {
            TrendResult trendResult = new TrendResult(false, 0L, 0L, 0L, 15, null);
            trendResult.setAverageMet(false);
            trendResult.setRunAverageTime(Statistics.INSTANCE.round(executionAvg));
            trendResult.setDeviation(Statistics.INSTANCE.round(avgThreshold));
            trendResult.setStandardAverage(Statistics.INSTANCE.round(sampleAvg));
            return trendResult;
        }
        return new TrendResult(false, 0L, 0L, 0L, 15, null);
    }

    @Override
    @NotNull
    public String buildErrorMessage(@NotNull TrendResult result, @NotNull MethodConfiguration conf) {
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        Intrinsics.checkParameterIsNotNull((Object)conf, (String)"conf");
        String msg = "";
        if (!result.isAverageMet()) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "\nStandard avg time = %d ms (%d + %d deviation) \nActual avg time = %d ms";
            Object[] objectArray = new Object[]{result.getStandardAverage() + result.getDeviation(), result.getStandardAverage(), result.getDeviation(), result.getRunAverageTime()};
            StringBuilder stringBuilder = new StringBuilder().append(msg);
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            msg = stringBuilder.append(string3).toString();
        }
        return msg;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Long> collectRuns(@NotNull Collection<PerfTestExecution> sample) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(sample, (String)"sample");
        Iterable iterable = $receiver$iv = (Iterable)sample;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            PerfTestExecution perfTestExecution = (PerfTestExecution)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List<Long> list = it.getExecutionResult();
            collection.add(list);
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }
}

