/*
 * Decompiled with CFR 0.152.
 */
package cz.encircled.jput.unit;

import cz.encircled.jput.Statistics;
import cz.encircled.jput.context.JPutContextKt;
import cz.encircled.jput.model.MethodConfiguration;
import cz.encircled.jput.model.PerfTestExecution;
import cz.encircled.jput.unit.UnitPerformanceAnalyzer;
import cz.encircled.jput.unit.UnitPerformanceResult;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\rH\u0002\u00a8\u0006\u0016"}, d2={"Lcz/encircled/jput/unit/UnitPerformanceAnalyzerImpl;", "Lcz/encircled/jput/unit/UnitPerformanceAnalyzer;", "()V", "addTestExecutions", "", "execution", "Lcz/encircled/jput/model/PerfTestExecution;", "elapsedTimes", "", "", "analyzeUnitTrend", "Lcz/encircled/jput/unit/UnitPerformanceResult;", "conf", "Lcz/encircled/jput/model/MethodConfiguration;", "buildErrorMessage", "", "result", "buildTestExecution", "configuration", "method", "Ljava/lang/reflect/Method;", "toString", "jput-core"})
public final class UnitPerformanceAnalyzerImpl
implements UnitPerformanceAnalyzer {
    @Override
    @NotNull
    public PerfTestExecution buildTestExecution(@NotNull MethodConfiguration configuration, @NotNull Method method) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        PerfTestExecution run = new PerfTestExecution(MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)JPutContextKt.getContext().getExecutionId())), null, null, 6, null);
        StringBuilder stringBuilder = new StringBuilder();
        Class<?> clazz = method.getDeclaringClass();
        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"method.declaringClass");
        run.setTestId(stringBuilder.append(clazz.getName()).append("#").append(method.getName()).toString());
        return run;
    }

    private final String toString(PerfTestExecution execution, MethodConfiguration configuration) {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "[ averageTime = %d ms, maxTime = %d ms]";
        Object[] objectArray = new Object[]{Statistics.INSTANCE.averageExecutionTime(execution), Statistics.INSTANCE.maxExecutionTime(execution)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        String stats = string2;
        return "PerfTestExecution{testId= " + execution.getTestId() + ", configuration = " + configuration + ", execution = " + stats + "}";
    }

    @Override
    public void addTestExecutions(@NotNull PerfTestExecution execution, @NotNull List<Long> elapsedTimes) {
        Intrinsics.checkParameterIsNotNull((Object)execution, (String)"execution");
        Intrinsics.checkParameterIsNotNull(elapsedTimes, (String)"elapsedTimes");
        execution.getExecutionResult().addAll((Collection<Long>)elapsedTimes);
    }

    @Override
    @NotNull
    public UnitPerformanceResult analyzeUnitTrend(@NotNull PerfTestExecution execution, @NotNull MethodConfiguration conf) {
        Intrinsics.checkParameterIsNotNull((Object)execution, (String)"execution");
        Intrinsics.checkParameterIsNotNull((Object)conf, (String)"conf");
        UnitPerformanceResult result = new UnitPerformanceResult(false, false, 0L, 0L, 15, null);
        result.setExecutionAvgTime(Statistics.INSTANCE.averageExecutionTime(execution));
        if (result.getExecutionAvgTime() > conf.getAverageTimeLimit()) {
            result.setAverageLimitMet(false);
        }
        result.setRunMaxTime(Statistics.INSTANCE.maxExecutionTime(execution));
        if (result.getRunMaxTime() > conf.getMaxTimeLimit()) {
            result.setMaxLimitMet(false);
        }
        return result;
    }

    @Override
    @NotNull
    public String buildErrorMessage(@NotNull UnitPerformanceResult result, @NotNull MethodConfiguration conf) {
        String string;
        StringBuilder stringBuilder;
        Object[] objectArray;
        String string2;
        StringCompanionObject stringCompanionObject;
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        Intrinsics.checkParameterIsNotNull((Object)conf, (String)"conf");
        String msg = "";
        if (!result.isAverageLimitMet()) {
            stringCompanionObject = StringCompanionObject.INSTANCE;
            string2 = "\nLimit avg time = %d ms\nActual avg time = %d ms";
            objectArray = new Object[]{conf.getAverageTimeLimit(), result.getExecutionAvgTime()};
            stringBuilder = new StringBuilder().append(msg);
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
            string = string3;
            msg = stringBuilder.append(string).toString();
        }
        if (!result.isMaxLimitMet()) {
            if (!result.isAverageLimitMet()) {
                msg = msg + "\n";
            }
            stringCompanionObject = StringCompanionObject.INSTANCE;
            string2 = "\nLimit max time = %d ms\nActual max time = %d ms";
            objectArray = new Object[]{conf.getMaxTimeLimit(), result.getRunMaxTime()};
            stringBuilder = new StringBuilder().append(msg);
            String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
            string = string4;
            msg = stringBuilder.append(string).toString();
        }
        return msg;
    }
}

