/*
 * Decompiled with CFR 0.152.
 */
package cz.encircled.jput.runner;

import cz.encircled.jput.context.JPutContextKt;
import cz.encircled.jput.model.PerfConstraintViolation;
import cz.encircled.jput.model.PerfTestConfiguration;
import cz.encircled.jput.model.PerfTestExecution;
import cz.encircled.jput.model.PerfTestResult;
import cz.encircled.jput.recorder.ResultRecorder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcz/encircled/jput/runner/BaseTestExecutor;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "analyzeExecutionResults", "Lcz/encircled/jput/model/PerfTestResult;", "execution", "Lcz/encircled/jput/model/PerfTestExecution;", "conf", "Lcz/encircled/jput/model/PerfTestConfiguration;", "executeTest", "config", "statement", "Lkotlin/Function0;", "", "performExecution", "writeResults", "jput-core"})
public class BaseTestExecutor {
    private final Logger log = LoggerFactory.getLogger(BaseTestExecutor.class);

    @NotNull
    public final PerfTestExecution executeTest(@NotNull PerfTestConfiguration config, @NotNull Function0<Unit> statement) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull(statement, (String)"statement");
        PerfTestExecution execution2 = new PerfTestExecution(config, MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"id", (Object)JPutContextKt.getContext().getExecutionId())}), null, null, 12, null);
        this.performExecution(execution2, statement);
        execution2.setResult(this.analyzeExecutionResults(execution2, config));
        this.writeResults(execution2);
        return execution2;
    }

    private final PerfTestResult analyzeExecutionResults(PerfTestExecution execution2, PerfTestConfiguration conf) {
        boolean bl = false;
        List result = new ArrayList();
        List<PerfConstraintViolation> unitViolations = JPutContextKt.getContext().getUnitPerformanceAnalyzer().analyzeUnitTrend(execution2);
        result.addAll((Collection)unitViolations);
        if (conf.getTrendConfiguration() != null) {
            Collection collection = JPutContextKt.getContext().getResultRecorders();
            boolean bl2 = false;
            if (!collection.isEmpty()) {
                List<Long> sample = JPutContextKt.getContext().getResultRecorders().get(0).getSample(execution2);
                if (sample.size() >= conf.getTrendConfiguration().getSampleSize()) {
                    List<PerfConstraintViolation> trendViolations = JPutContextKt.getContext().getTrendAnalyzer().analyzeTestTrend(execution2, sample);
                    result.addAll((Collection)trendViolations);
                } else {
                    this.log.info("Skipping performance trend assertions since current sample size is too small [current is " + sample.size() + ']');
                }
            }
        }
        return new PerfTestResult(result);
    }

    private final void writeResults(PerfTestExecution execution2) {
        Iterable $this$forEach$iv = JPutContextKt.getContext().getResultRecorders();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResultRecorder it = (ResultRecorder)element$iv;
            boolean bl = false;
            it.appendTrendResult(execution2);
        }
    }

    private final void performExecution(PerfTestExecution execution2, Function0<Unit> statement) {
        int it;
        JPutContextKt.getContext().getTestExecutions().put(execution2.getConf().getTestId(), execution2);
        int n = execution2.getConf().getWarmUp();
        boolean bl = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            it = n2++;
            boolean bl2 = false;
            statement.invoke();
        }
        n = execution2.getConf().getRepeats();
        bl = false;
        n2 = 0;
        n3 = n;
        for (n2 = 0; n2 < n3; ++n2) {
            it = n2;
            boolean bl3 = false;
            execution2.startNextExecution();
            statement.invoke();
            execution2.finishExecution();
            if (execution2.getConf().getDelay() <= 0L) continue;
            Thread.sleep(execution2.getConf().getDelay());
        }
    }
}

