/*
 * Decompiled with CFR 0.152.
 */
package cz.encircled.jput.trend;

import cz.encircled.jput.StatisticsKt;
import cz.encircled.jput.model.PerfConstraintViolation;
import cz.encircled.jput.model.PerfTestExecution;
import cz.encircled.jput.model.TrendTestConfiguration;
import cz.encircled.jput.trend.TrendAnalyzer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007H\u0016J\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u000eR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcz/encircled/jput/trend/SampleBasedTrendAnalyzer;", "Lcz/encircled/jput/trend/TrendAnalyzer;", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "analyzeTestTrend", "", "Lcz/encircled/jput/model/PerfConstraintViolation;", "execution", "Lcz/encircled/jput/model/PerfTestExecution;", "sample", "", "collectRuns", "", "jput-core"})
public final class SampleBasedTrendAnalyzer
implements TrendAnalyzer {
    private final Logger log = LoggerFactory.getLogger(SampleBasedTrendAnalyzer.class);

    @Override
    @NotNull
    public List<PerfConstraintViolation> analyzeTestTrend(@NotNull PerfTestExecution execution2, @NotNull List<Long> sample) {
        double avgThreshold;
        TrendTestConfiguration trend;
        Intrinsics.checkParameterIsNotNull((Object)execution2, (String)"execution");
        Intrinsics.checkParameterIsNotNull(sample, (String)"sample");
        TrendTestConfiguration trendTestConfiguration = execution2.getConf().getTrendConfiguration();
        if (trendTestConfiguration == null) {
            Intrinsics.throwNpe();
        }
        List<Long> sortedSample = (trend = trendTestConfiguration).getNoisePercentile() > 0.0 ? StatisticsKt.percentile(CollectionsKt.sorted((Iterable)sample), trend.getNoisePercentile()) : CollectionsKt.sorted((Iterable)sample);
        double d = avgThreshold = trend.getUseStandardDeviationAsThreshold() ? trend.getAverageTimeThreshold() + StatisticsKt.deviation(sortedSample) : trend.getAverageTimeThreshold();
        if (avgThreshold <= 0.0) {
            this.log.warn("Average time threshold is not set, skipping performance trend test");
            return CollectionsKt.emptyList();
        }
        this.log.info("Average time threshold is " + avgThreshold);
        double avgLimit = CollectionsKt.averageOfLong((Iterable)sortedSample) + avgThreshold;
        execution2.getExecutionParams().put("avgLimit", avgLimit);
        return (double)execution2.getExecutionAvg() > avgLimit ? CollectionsKt.listOf((Object)((Object)PerfConstraintViolation.TREND_AVG)) : CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Long> collectRuns(@NotNull Collection<PerfTestExecution> sample) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(sample, (String)"sample");
        Iterable $this$map$iv = sample;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PerfTestExecution perfTestExecution = (PerfTestExecution)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List<Long> list = it.getElapsedTimes();
            collection.add(list);
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }
}

