/*
 * Decompiled with CFR 0.152.
 */
package cz.encircled.jput.reporter;

import cz.encircled.jput.model.PerfTestExecution;
import cz.encircled.jput.reporter.JPutReporter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010\u000f\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcz/encircled/jput/reporter/JPutConsoleReporter;", "Lcz/encircled/jput/reporter/JPutReporter;", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "afterClass", "", "clazz", "Ljava/lang/Class;", "afterTest", "execution", "Lcz/encircled/jput/model/PerfTestExecution;", "beforeClass", "beforeTest", "jput-core"})
public final class JPutConsoleReporter
implements JPutReporter {
    private final Logger log = LoggerFactory.getLogger(JPutConsoleReporter.class);

    public final Logger getLog() {
        return this.log;
    }

    @Override
    public void beforeClass(@NotNull Class<?> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        this.log.info("Starting JPut performance tests for " + clazz.getSimpleName());
    }

    @Override
    public void beforeTest(@NotNull PerfTestExecution execution2) {
        Intrinsics.checkParameterIsNotNull((Object)execution2, (String)"execution");
    }

    @Override
    public void afterTest(@NotNull PerfTestExecution execution2) {
        Intrinsics.checkParameterIsNotNull((Object)execution2, (String)"execution");
        this.log.info("Test " + execution2.getConf().getTestId() + ":\n" + "avg: " + execution2.getExecutionAvg() + "ms, max: " + execution2.getExecutionMax() + "ms, " + "50%: " + execution2.executionPercentile(0.5) + "ms, " + "90%: " + execution2.executionPercentile(0.9) + "ms, " + "95%: " + execution2.executionPercentile(0.95) + "ms, " + "99%: " + execution2.executionPercentile(0.99) + "ms, " + "success count: " + execution2.successResults().size() + ", " + "total count: " + execution2.getExecutionResult().size());
    }

    @Override
    public void afterClass(@NotNull Class<?> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
    }
}

