/*
 * Decompiled with CFR 0.152.
 */
package cz.encircled.jput.runner;

import cz.encircled.jput.JPut;
import cz.encircled.jput.JPutImpl;
import cz.encircled.jput.context.JPutContextKt;
import cz.encircled.jput.model.ExecutionRun;
import cz.encircled.jput.model.PerfConstraintViolation;
import cz.encircled.jput.model.PerfTestConfiguration;
import cz.encircled.jput.model.PerfTestExecution;
import cz.encircled.jput.model.RunResult;
import cz.encircled.jput.recorder.ResultRecorder;
import cz.encircled.jput.reporter.JPutReporter;
import cz.encircled.jput.unit.UnitPerformanceAnalyzer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J&\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\f2\u0016\u0010\u000f\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0010J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0016\u0010\u000f\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0010H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcz/encircled/jput/runner/ThreadBasedTestExecutor;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "analyzeExecutionResults", "", "Lcz/encircled/jput/model/PerfConstraintViolation;", "execution", "Lcz/encircled/jput/model/PerfTestExecution;", "conf", "Lcz/encircled/jput/model/PerfTestConfiguration;", "executeTest", "config", "statement", "Lkotlin/Function1;", "Lcz/encircled/jput/JPut;", "performExecution", "", "writeResults", "jput-core"})
public class ThreadBasedTestExecutor {
    private final Logger log = LoggerFactory.getLogger(ThreadBasedTestExecutor.class);

    @NotNull
    public final PerfTestExecution executeTest(@NotNull PerfTestConfiguration config, @NotNull Function1<? super JPut, ? extends Object> statement) {
        JPutReporter it;
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull(statement, (String)"statement");
        PerfTestExecution execution2 = new PerfTestExecution(config, MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"id", (Object)JPutContextKt.getContext().getExecutionId())}), System.nanoTime(), null, null, 24, null);
        Iterable $this$forEach$iv = JPutContextKt.getContext().getResultReporters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (JPutReporter)element$iv;
            boolean bl = false;
            it.beforeTest(execution2);
        }
        this.performExecution(execution2, statement);
        execution2.getViolations().addAll((Collection<PerfConstraintViolation>)this.analyzeExecutionResults(execution2, config));
        this.writeResults(execution2);
        $this$forEach$iv = JPutContextKt.getContext().getResultReporters();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (JPutReporter)element$iv;
            boolean bl = false;
            it.afterTest(execution2);
        }
        return execution2;
    }

    private final List<PerfConstraintViolation> analyzeExecutionResults(PerfTestExecution execution2, PerfTestConfiguration conf) {
        boolean bl = false;
        List result = new ArrayList();
        Iterable $this$forEach$iv = JPutContextKt.getContext().getUnitPerformanceAnalyzers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UnitPerformanceAnalyzer it = (UnitPerformanceAnalyzer)element$iv;
            boolean bl2 = false;
            result.addAll((Collection)it.analyzeUnitTrend(execution2));
        }
        if (conf.getTrendConfiguration() != null) {
            $this$forEach$iv = JPutContextKt.getContext().getResultRecorders();
            $i$f$forEach = false;
            if (!$this$forEach$iv.isEmpty()) {
                List<Long> sample = JPutContextKt.getContext().getResultRecorders().get(0).getSample(execution2);
                if (sample.size() >= conf.getTrendConfiguration().getSampleSize()) {
                    List<PerfConstraintViolation> trendViolations = JPutContextKt.getContext().getTrendAnalyzer().analyzeTestTrend(execution2, sample);
                    result.addAll((Collection)trendViolations);
                } else {
                    this.log.info("Skipping performance trend assertions since current sample size is too small [current is " + sample.size() + ']');
                }
            }
        }
        return result;
    }

    private final void writeResults(PerfTestExecution execution2) {
        Iterable $this$forEach$iv = JPutContextKt.getContext().getResultRecorders();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResultRecorder it = (ResultRecorder)element$iv;
            boolean bl = false;
            it.appendTrendResult(execution2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void performExecution(@NotNull PerfTestExecution execution2, @NotNull Function1<? super JPut, ? extends Object> statement) {
        void $this$mapTo$iv$iv;
        Future<Object> future;
        Collection collection;
        Iterable $this$mapTo$iv$iv2;
        Intrinsics.checkParameterIsNotNull((Object)execution2, (String)"execution");
        Intrinsics.checkParameterIsNotNull(statement, (String)"statement");
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(execution2.getConf().getParallelCount());
        long rampUp = execution2.getConf().getRampUp() > 0L ? execution2.getConf().getRampUp() / (long)(execution2.getConf().getParallelCount() - 1) : 0L;
        int n = 1;
        Iterable $this$map$iv = (Iterable)new IntRange(n, execution2.getConf().getWarmUp());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            int item$iv$iv;
            int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            future = executor.submit(new Runnable(executor, statement){
                final /* synthetic */ ScheduledExecutorService $executor$inlined;
                final /* synthetic */ Function1 $statement$inlined;
                {
                    this.$executor$inlined = scheduledExecutorService;
                    this.$statement$inlined = function1;
                }

                public final void run() {
                    this.$statement$inlined.invoke(null);
                }
            });
            collection.add(future);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv2 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Future it = (Future)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            future = it.get();
            collection.add(future);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        $this$map$iv = new Ref.IntRef();
        ((Ref.IntRef)$this$map$iv).element = 0;
        int $this$mapTo$iv$iv22 = 1;
        int destination$iv$iv2 = execution2.getConf().getRepeats() / execution2.getConf().getParallelCount();
        $i$f$mapTo = false;
        int repeatsPerThread = Math.max($this$mapTo$iv$iv22, destination$iv$iv2);
        Iterable $this$map$iv2 = (Iterable)RangesKt.until((int)0, (int)execution2.getConf().getParallelCount());
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo2 = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo3 = false;
        Iterator it = $this$mapTo$iv$iv.iterator();
        while (it.hasNext()) {
            void scheduledCount;
            void index;
            int item$iv$iv;
            int n3 = item$iv$iv = ((IntIterator)it).nextInt();
            collection = destination$iv$iv3;
            boolean bl = false;
            int r = index == execution2.getConf().getParallelCount() - 1 ? execution2.getConf().getRepeats() - scheduledCount.element : repeatsPerThread;
            scheduledCount.element += r;
            future = executor.schedule(new Runnable(r, this, execution2, (Ref.IntRef)scheduledCount, repeatsPerThread, executor, statement, rampUp){
                final /* synthetic */ int $r;
                final /* synthetic */ ThreadBasedTestExecutor this$0;
                final /* synthetic */ PerfTestExecution $execution$inlined;
                final /* synthetic */ Ref.IntRef $scheduledCount$inlined;
                final /* synthetic */ int $repeatsPerThread$inlined;
                final /* synthetic */ ScheduledExecutorService $executor$inlined;
                final /* synthetic */ Function1 $statement$inlined;
                final /* synthetic */ long $rampUp$inlined;
                {
                    this.$r = n;
                    this.this$0 = threadBasedTestExecutor;
                    this.$execution$inlined = perfTestExecution;
                    this.$scheduledCount$inlined = intRef;
                    this.$repeatsPerThread$inlined = n2;
                    this.$executor$inlined = scheduledExecutorService;
                    this.$statement$inlined = function1;
                    this.$rampUp$inlined = l;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    int n = this.$r;
                    boolean bl = false;
                    int n2 = 0;
                    int n3 = n;
                    for (n2 = 0; n2 < n3; ++n2) {
                        block8: {
                            int it = n2;
                            boolean bl2 = false;
                            ExecutionRun repeat = this.$execution$inlined.startNextExecution();
                            try {
                                Object testResult = this.$statement$inlined.invoke((Object)new JPutImpl(repeat));
                                if (testResult instanceof RunResult) {
                                    repeat.setResultDetails((RunResult)testResult);
                                }
                            }
                            catch (Exception e) {
                                if (this.$execution$inlined.getConf().getContinueOnException()) {
                                    ThreadBasedTestExecutor.access$getLog$p(this.this$0).debug("Exception occurred during test run", (Throwable)e);
                                    repeat.setResultDetails(new RunResult(500, e, null, 4, null));
                                    break block8;
                                }
                                throw (Throwable)e;
                            }
                            finally {
                                repeat.measureElapsed();
                            }
                        }
                        if (this.$execution$inlined.getConf().getDelay() <= 0L) continue;
                        Thread.sleep(this.$execution$inlined.getConf().getDelay());
                    }
                }
            }, rampUp * (long)index, TimeUnit.MILLISECONDS);
            collection.add(future);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv3;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScheduledFuture it2 = (ScheduledFuture)element$iv;
            boolean bl = false;
            it2.get();
        }
    }

    public static final /* synthetic */ Logger access$getLog$p(ThreadBasedTestExecutor $this) {
        return $this.log;
    }
}

