/*
 * Decompiled with CFR 0.152.
 */
package cz.encircled.jput.runner;

import cz.encircled.jput.context.JPutContextKt;
import cz.encircled.jput.model.SuiteConfiguration;
import cz.encircled.jput.reporter.JPutReporter;
import cz.encircled.jput.unit.PerformanceSuite;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.RunnerScheduler;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0002J\u0012\u0010\t\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bR\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcz/encircled/jput/runner/JUnitTestRunnerSupport;", "", "clazz", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "parallelize", "", "runner", "Lorg/junit/runners/ParentRunner;", "prepareRunner", "jput-core"})
public final class JUnitTestRunnerSupport {
    private final Class<?> clazz;

    public final void prepareRunner(@NotNull ParentRunner<?> runner) {
        Intrinsics.checkParameterIsNotNull(runner, (String)"runner");
        JPutContextKt.getContext().init();
        Iterable $this$forEach$iv = JPutContextKt.getContext().getResultReporters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JPutReporter it = (JPutReporter)element$iv;
            boolean bl = false;
            it.beforeClass(this.clazz);
        }
        PerformanceSuite suite = this.clazz.getAnnotation(PerformanceSuite.class);
        JPutContextKt.getContext().setCurrentSuite(SuiteConfiguration.Companion.fromAnnotation(this.clazz, suite));
        SuiteConfiguration suiteConfiguration = JPutContextKt.getContext().getCurrentSuite();
        if (suiteConfiguration == null) {
            Intrinsics.throwNpe();
        }
        if (suiteConfiguration.isParallel()) {
            this.parallelize(runner);
        }
    }

    private final void parallelize(ParentRunner<?> runner) {
        runner.setScheduler(new RunnerScheduler(){
            @NotNull
            private final ExecutorService fService;

            @NotNull
            public final ExecutorService getFService() {
                return this.fService;
            }

            public void schedule(@NotNull Runnable childStatement) {
                Intrinsics.checkParameterIsNotNull((Object)childStatement, (String)"childStatement");
                this.fService.submit(childStatement);
            }

            public void finished() {
                try {
                    this.fService.shutdown();
                    this.fService.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace(System.err);
                }
            }
            {
                ExecutorService executorService = Executors.newCachedThreadPool();
                Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"Executors.newCachedThreadPool()");
                this.fService = executorService;
            }
        });
    }

    public JUnitTestRunnerSupport(@NotNull Class<?> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        this.clazz = clazz;
    }
}

