/*
 * Decompiled with CFR 0.152.
 */
package cz.encircled.jput.recorder;

import cz.encircled.jput.JPutUtils;
import cz.encircled.jput.context.JPutContextKt;
import cz.encircled.jput.context.PropertySource;
import cz.encircled.jput.context.PropertySourceKt;
import cz.encircled.jput.model.ExecutionRun;
import cz.encircled.jput.model.PerfTestExecution;
import cz.encircled.jput.model.TrendTestConfiguration;
import cz.encircled.jput.recorder.ElasticsearchClient;
import cz.encircled.jput.recorder.ElasticsearchResultRecorder;
import cz.encircled.jput.recorder.ThreadsafeResultRecorder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Requests;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u000e\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00100\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\u00020\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u000fH\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u000f2\u0006\u0010\u001d\u001a\u00020\u0013H\u0016J \u0010\u001e\u001a\n \r*\u0004\u0018\u00010\u001f0\u001f2\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcz/encircled/jput/recorder/ElasticsearchResultRecorder;", "Lcz/encircled/jput/recorder/ThreadsafeResultRecorder;", "client", "Lcz/encircled/jput/recorder/ElasticsearchClient;", "(Lcz/encircled/jput/recorder/ElasticsearchClient;)V", "indexName", "", "getIndexName", "()Ljava/lang/String;", "indexName$delegate", "Lkotlin/Lazy;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "convertToECSDocument", "", "", "", "it", "Lcz/encircled/jput/model/PerfTestExecution;", "deleteExecutionsOlderThan", "", "days", "", "doCleanup", "", "doFlush", "data", "getSample", "execution", "matches", "Lorg/elasticsearch/index/query/MatchQueryBuilder;", "name", "value", "jput-core"})
public final class ElasticsearchResultRecorder
extends ThreadsafeResultRecorder {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Logger log;
    private final Lazy indexName$delegate;
    private final ElasticsearchClient client;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ElasticsearchResultRecorder.class), "indexName", "getIndexName()Ljava/lang/String;"))};
    }

    private final String getIndexName() {
        Lazy lazy = this.indexName$delegate;
        ElasticsearchResultRecorder elasticsearchResultRecorder = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public List<Long> getSample(@NotNull PerfTestExecution execution2) {
        Object object;
        Object it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        SearchResponse searchResponse;
        Intrinsics.checkParameterIsNotNull((Object)execution2, (String)"execution");
        TrendTestConfiguration trendTestConfiguration = execution2.getConf().getTrendConfiguration();
        if (trendTestConfiguration == null) {
            Intrinsics.throwNpe();
        }
        TrendTestConfiguration conf = trendTestConfiguration;
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().filter((QueryBuilder)this.matches("testId", execution2.getConf().getTestId()));
        Iterable $this$forEach$iv = PropertySourceKt.getCollectionProperty$default("jput.storage.elastic.env.identifiers", null, 2, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it2 = (String)element$iv;
            boolean bl = false;
            String string = this.getUserDefinedEnvParams().get(it2);
            if (string == null) {
                string = "";
            }
            String envParam = string;
            queryBuilder.filter((QueryBuilder)this.matches(it2, envParam));
        }
        queryBuilder.filter((QueryBuilder)this.matches("errorMessage", ""));
        SearchRequest request = new SearchRequest(new String[]{this.getIndexName()}).source(new SearchSourceBuilder().query((QueryBuilder)queryBuilder));
        try {
            SearchRequest searchRequest = request;
            Intrinsics.checkExpressionValueIsNotNull((Object)searchRequest, (String)"request");
            RequestOptions requestOptions = RequestOptions.DEFAULT;
            Intrinsics.checkExpressionValueIsNotNull((Object)requestOptions, (String)"RequestOptions.DEFAULT");
            searchResponse = this.client.search(searchRequest, requestOptions);
        }
        catch (ElasticsearchStatusException e) {
            if (e.status() == RestStatus.NOT_FOUND) {
                return CollectionsKt.emptyList();
            }
            throw (Throwable)e;
        }
        SearchResponse searchResponse2 = searchResponse;
        SearchHits searchHits = searchResponse2.getHits();
        Intrinsics.checkExpressionValueIsNotNull((Object)searchHits, (String)"searchResponse.hits");
        Object[] objectArray = searchHits.getHits();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"searchResponse.hits.hits");
        List sample = this.subList(ArraysKt.toList((Object[])objectArray), conf.getSampleSize(), conf.getSampleSelectionStrategy());
        Iterable $this$map$iv = sample;
        boolean $i$f$map = false;
        Iterable bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            SearchHit searchHit = (SearchHit)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            void v6 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"it");
            object = v6.getSourceAsMap().get("elapsed");
            collection.add(object);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            long l;
            Object item$iv$iv;
            it = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl3 = false;
            if (it instanceof Integer) {
                l = ((Number)it).intValue();
            } else {
                Object t = it;
                if (t == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Long");
                }
                l = (Long)t;
            }
            object = l;
            collection.add(object);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doFlush(@NotNull List<PerfTestExecution> data) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        this.log.info("Flush to Elasticsearch: " + data.size() + " test results");
        BulkRequest bulk = Requests.bulkRequest();
        Map<String, String> userDefined = this.getUserDefinedEnvParams();
        Iterable iterable = data;
        ElasticsearchResultRecorder elasticsearchResultRecorder = this;
        boolean $i$f$flatMap = false;
        void var7_9 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PerfTestExecution p1 = (PerfTestExecution)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = elasticsearchResultRecorder.convertToECSDocument(p1);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map it = (Map)element$iv;
            boolean bl = false;
            it.putAll(userDefined);
            bulk.add(Requests.indexRequest((String)this.getIndexName()).type("jput").source(it));
        }
        BulkRequest bulkRequest = bulk;
        Intrinsics.checkExpressionValueIsNotNull((Object)bulkRequest, (String)"bulk");
        RequestOptions requestOptions = RequestOptions.DEFAULT;
        Intrinsics.checkExpressionValueIsNotNull((Object)requestOptions, (String)"RequestOptions.DEFAULT");
        this.client.bulk(bulkRequest, requestOptions);
        this.log.info("Successfully flushed to Elasticsearch");
    }

    /*
     * WARNING - void declaration
     */
    public final void doCleanup() {
        Integer n;
        void $this$mapNotNullTo$iv$iv$iv;
        String key$iv = "jput.storage.elastic.cleanup.remove.after.days";
        boolean $i$f$getOptionalProperty = false;
        Iterable $this$mapNotNull$iv$iv = JPutContextKt.getContext().getPropertySources();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv$iv = $this$mapNotNullTo$iv$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv$iv;
            Object element$iv$iv$iv = element$iv$iv$iv$iv = iterator.next();
            boolean bl = false;
            PropertySource it$iv = (PropertySource)element$iv$iv$iv;
            boolean bl2 = false;
            if (it$iv.getProperty(key$iv) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv$iv.add(it$iv$iv$iv);
        }
        String value$iv = (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv$iv));
        CharSequence charSequence = value$iv;
        boolean bl = false;
        boolean bl6 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            n = null;
        } else {
            charSequence = Reflection.getOrCreateKotlinClass(Integer.class);
            if (Intrinsics.areEqual((Object)charSequence, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                String string = value$iv;
                bl6 = false;
                n = (Integer)((Object)Boolean.valueOf(Boolean.parseBoolean(string)));
            } else if (Intrinsics.areEqual((Object)charSequence, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                String string = value$iv;
                bl6 = false;
                n = Integer.parseInt(string);
            } else if (Intrinsics.areEqual((Object)charSequence, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                String string = value$iv;
                bl6 = false;
                n = (Integer)Long.parseLong(string);
            } else {
                String string = value$iv;
                if (string == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                n = (Integer)((Object)string);
            }
        }
        Integer days = n;
        if (days != null) {
            this.log.info("Removing execution older than " + days + " days from Elasticsearch...");
            try {
                long deleted = this.deleteExecutionsOlderThan(days);
                this.log.info("Successfully removed " + deleted + " old entries from Elasticsearch!");
            }
            catch (Exception e) {
                this.log.info("Error during Elasticsearch cleanup", (Throwable)e);
            }
        }
    }

    private final MatchQueryBuilder matches(String name, String value) {
        return QueryBuilders.matchQuery((String)name, (Object)value).operator(Operator.AND);
    }

    private final long deleteExecutionsOlderThan(int days) {
        DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{this.getIndexName()});
        RangeQueryBuilder rangeQueryBuilder = new RangeQueryBuilder("executionId");
        Date date = LocalDate.now().minusDays(days).toDate();
        Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"LocalDate.now().minusDays(days).toDate()");
        request.setQuery((QueryBuilder)rangeQueryBuilder.lt((Object)date.getTime()));
        RequestOptions requestOptions = RequestOptions.DEFAULT;
        Intrinsics.checkExpressionValueIsNotNull((Object)requestOptions, (String)"RequestOptions.DEFAULT");
        return this.client.deleteByQuery(request, requestOptions).getDeleted();
    }

    /*
     * WARNING - void declaration
     */
    private final List<Map<String, Object>> convertToECSDocument(PerfTestExecution it) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = it.getExecutionResult().values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void repeat;
            ExecutionRun executionRun = (ExecutionRun)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Map map2 = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"executionId", (Object)JPutContextKt.getContext().getExecutionId()), TuplesKt.to((Object)"testId", (Object)it.getConf().getTestId()), TuplesKt.to((Object)"start", (Object)new DateTime(repeat.getRelativeStartTime() / 1000000L, DateTimeZone.UTC).toDate()), TuplesKt.to((Object)"elapsed", (Object)repeat.getElapsedTime()), TuplesKt.to((Object)"resultCode", (Object)repeat.getResultDetails().getResultCode()), TuplesKt.to((Object)"errorMessage", (Object)JPutUtils.INSTANCE.buildErrorMessage$jput_core((ExecutionRun)repeat))});
            collection.add(map2);
        }
        return (List)destination$iv$iv;
    }

    public ElasticsearchResultRecorder(@NotNull ElasticsearchClient client) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        this.client = client;
        this.log = LoggerFactory.getLogger(ElasticsearchResultRecorder.class);
        this.indexName$delegate = LazyKt.lazy((Function0)indexName.2.INSTANCE);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public final void run() {
                client.close();
            }
        }));
    }
}

