/*
 * Decompiled with CFR 0.152.
 */
package cz.encircled.jput.analyzer;

import cz.encircled.jput.analyzer.UnitPerformanceAnalyzer;
import cz.encircled.jput.model.PerfConstraintViolation;
import cz.encircled.jput.model.PerfTestExecution;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcz/encircled/jput/analyzer/UnitPerformanceAnalyzerImpl;", "Lcz/encircled/jput/analyzer/UnitPerformanceAnalyzer;", "()V", "analyzeUnitTrend", "", "Lcz/encircled/jput/model/PerfConstraintViolation;", "execution", "Lcz/encircled/jput/model/PerfTestExecution;", "jput-core"})
public final class UnitPerformanceAnalyzerImpl
implements UnitPerformanceAnalyzer {
    @Override
    @NotNull
    public List<PerfConstraintViolation> analyzeUnitTrend(@NotNull PerfTestExecution execution2) {
        Intrinsics.checkParameterIsNotNull((Object)execution2, (String)"execution");
        boolean bl = false;
        List result = new ArrayList();
        if (execution2.getConf().getAvgTimeLimit() > 0L && execution2.getExecutionAvg() > execution2.getConf().getAvgTimeLimit()) {
            result.add(PerfConstraintViolation.UNIT_AVG);
        }
        if (execution2.getConf().getMaxTimeLimit() > 0L && execution2.getExecutionMax() > execution2.getConf().getMaxTimeLimit()) {
            result.add(PerfConstraintViolation.UNIT_MAX);
        }
        Map<Double, Long> map2 = execution2.getConf().getPercentiles();
        boolean bl2 = false;
        for (Map.Entry<Double, Long> p : map2.entrySet()) {
            long actual = execution2.executionPercentile(((Number)p.getKey()).doubleValue());
            if (actual <= ((Number)p.getValue()).longValue()) continue;
            result.add(PerfConstraintViolation.UNIT_PERCENTILE);
            execution2.getExecutionParams().put("percentileLimit", p.getValue());
            execution2.getExecutionParams().put("percentileRank", ((Number)p.getKey()).doubleValue() * (double)100);
            execution2.getExecutionParams().put("percentileActual", actual);
            break;
        }
        return result;
    }
}

