/*
 * Decompiled with CFR 0.152.
 */
package cz.encircled.macl;

import cz.encircled.macl.ChangelogConfiguration;
import cz.encircled.macl.VCSLogParser;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NavigableSet;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.maven.plugin.logging.Log;

public class ChangelogExecutor {
    private final ChangelogConfiguration conf;
    private final VCSLogParser vcsLogParser;

    public ChangelogExecutor(ChangelogConfiguration conf, VCSLogParser vcsLogParser) {
        this.conf = conf;
        this.vcsLogParser = vcsLogParser;
    }

    public void run(Log log) {
        try {
            log.debug((CharSequence)("Changelog file: " + this.conf.pathToChangelog));
            log.info((CharSequence)("New messages pattern: " + this.conf.applicableCommitPattern.pattern()));
            List<String> allLines = Files.lines(this.conf.pathToChangelog).map(String::trim).collect(Collectors.toList());
            String lastTag = this.getLastTag(allLines);
            log.info((CharSequence)("Last tag: " + lastTag));
            NavigableSet<String> newMessages = this.vcsLogParser.getNewMessages(log, lastTag);
            if (newMessages.isEmpty()) {
                log.info((CharSequence)"No new messages");
                return;
            }
            int unreleasedIndex = this.getIndexOfUnreleasedLine(allLines);
            log.info((CharSequence)("Count of new messages: " + newMessages.size()));
            log.debug((CharSequence)("Index of 'Unreleased' line: " + unreleasedIndex));
            List<String> resultLines = this.insertNewMessages(allLines, newMessages, unreleasedIndex);
            Files.write(this.conf.pathToChangelog, resultLines, new OpenOption[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public List<String> insertNewMessages(List<String> allLines, Collection<String> newMessages, int unreleasedIndex) {
        ArrayList<String> resultLines = new ArrayList<String>(allLines.size() + newMessages.size());
        resultLines.addAll(allLines.subList(0, unreleasedIndex + 1));
        resultLines.addAll(newMessages);
        resultLines.addAll(allLines.subList(unreleasedIndex + 2, allLines.size()));
        return resultLines;
    }

    public String getLastTag(List<String> allLines) {
        for (String line : allLines) {
            Matcher matcher = this.conf.lastTagPattern.matcher(line);
            if (!matcher.matches()) continue;
            return String.format(this.conf.lastTagFormat, matcher.group(1));
        }
        throw new IllegalStateException("Last tag not found for pattern " + this.conf.lastTagPattern.pattern());
    }

    public int getIndexOfUnreleasedLine(List<String> allLines) {
        for (int i = 0; i < allLines.size(); ++i) {
            if (!this.conf.unreleasedRowPattern.matcher(allLines.get(i)).matches()) continue;
            return i;
        }
        throw new IllegalStateException("Row with unreleased changes was not found for pattern " + this.conf.unreleasedRowPattern.pattern());
    }
}

