/*
 * Decompiled with CFR 0.152.
 */
package cz.encircled.macl;

import cz.encircled.macl.ChangelogConfiguration;
import cz.encircled.macl.VCSLogParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.maven.plugin.logging.Log;

public class GitLogParser
implements VCSLogParser {
    private final ChangelogConfiguration conf;
    private static final String command = "git log %s..HEAD";

    public GitLogParser(ChangelogConfiguration conf) {
        this.conf = conf;
    }

    @Override
    public NavigableSet<String> getNewMessages(Log log, String tagFrom) throws Exception {
        String command = String.format(command, tagFrom);
        Process p = Runtime.getRuntime().exec(command);
        BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
        TreeSet result = input.lines().map(String::trim).filter(l -> {
            boolean matches = this.conf.applicableCommitPattern.matcher((CharSequence)l).matches();
            if (!matches) {
                log.info((CharSequence)("Message [" + l + "] skipped"));
            }
            return matches;
        }).map(s -> String.format(this.conf.commitFormat, s)).collect(Collectors.toCollection(TreeSet::new));
        if (!result.isEmpty()) {
            ArrayList<String> temp = new ArrayList<String>(result);
            temp.set(0, "\r\n" + (String)temp.get(0));
            result = new TreeSet(temp);
        }
        log.info((CharSequence)String.format("Executed command [%s] returned [%d] rows", command, result.size()));
        return result;
    }
}

