/*
 * Decompiled with CFR 0.152.
 */
package cz.encircled.macl;

import cz.encircled.macl.ChangelogConfiguration;
import cz.encircled.macl.parser.VCSLogParser;
import cz.encircled.macl.transform.MessageProcessor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NavigableSet;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.maven.plugin.logging.Log;

public class ChangelogExecutor {
    private final ChangelogConfiguration conf;
    private final VCSLogParser vcsLogParser;
    private final MessageProcessor messageProcessor;

    public ChangelogExecutor(ChangelogConfiguration conf, VCSLogParser vcsLogParser, MessageProcessor messageProcessor) {
        this.conf = conf;
        this.vcsLogParser = vcsLogParser;
        this.messageProcessor = messageProcessor;
    }

    public void run(Log log) {
        try {
            log.debug((CharSequence)("Changelog file: " + this.conf.pathToChangelog));
            log.info((CharSequence)("New messages pattern: " + this.conf.applicableCommitPattern.pattern()));
            List<String> allLines = Files.lines(this.conf.pathToChangelog).map(String::trim).collect(Collectors.toList());
            String lastTag = this.getLastTag(allLines);
            log.info((CharSequence)("Last tag: " + lastTag));
            NavigableSet<String> newMessages = this.messageProcessor.getNewMessages(this.vcsLogParser.getNewMessages(log, lastTag));
            if (newMessages.isEmpty()) {
                log.info((CharSequence)"No new messages");
                return;
            }
            int unreleasedIndex = this.getIndexOfUnreleasedLine(allLines);
            log.info((CharSequence)("Count of new messages: " + newMessages.size()));
            log.debug((CharSequence)("Index of 'Unreleased' line: " + unreleasedIndex));
            List<String> resultLines = this.insertNewMessages(allLines, newMessages, unreleasedIndex);
            Files.write(this.conf.pathToChangelog, resultLines, new OpenOption[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public List<String> insertNewMessages(List<String> allLines, Collection<String> newMessages, int unreleasedIndex) {
        ArrayList<String> resultLines = new ArrayList<String>(allLines.size() + newMessages.size());
        int afterUnreleased = unreleasedIndex + 1;
        resultLines.addAll(allLines.subList(0, afterUnreleased));
        resultLines.addAll(newMessages);
        int fromIndex = allLines.get(afterUnreleased).isEmpty() ? unreleasedIndex + 2 : afterUnreleased;
        resultLines.addAll(allLines.subList(fromIndex, allLines.size()));
        return resultLines;
    }

    public String getLastTag(List<String> allLines) {
        if (this.conf.lastTag != null) {
            return this.conf.lastTag;
        }
        for (String line : allLines) {
            Matcher matcher = this.conf.lastTagPattern.matcher(line);
            if (!matcher.matches()) continue;
            return String.format(this.conf.lastTagFormat, matcher.group(1));
        }
        throw new IllegalStateException("Last tag not found for pattern " + this.conf.lastTagPattern.pattern());
    }

    public int getIndexOfUnreleasedLine(List<String> allLines) {
        for (int i = 0; i < allLines.size(); ++i) {
            if (!this.conf.unreleasedRowPattern.matcher(allLines.get(i)).matches()) continue;
            return i;
        }
        throw new IllegalStateException("Row with unreleased changes was not found for pattern " + this.conf.unreleasedRowPattern.pattern());
    }
}

