/*
 * Decompiled with CFR 0.152.
 */
package cz.encircled.macl.parser;

import cz.encircled.macl.parser.VCSLogParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.logging.Log;

public class GitLogParser
implements VCSLogParser {
    private static final String command = "git log %s..HEAD";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<String> getNewMessages(Log log, String tagFrom) {
        Process p;
        String command = String.format(command, tagFrom);
        try {
            p = Runtime.getRuntime().exec(command);
            log.info((CharSequence)String.format("GitParser executed command [%s]", command));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try (BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));){
            Set set = input.lines().collect(Collectors.toCollection(LinkedHashSet::new));
            return set;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

