/*
 * Decompiled with CFR 0.152.
 */
package cz.encircled.macl;

import cz.encircled.macl.ChangelogConfiguration;
import cz.encircled.macl.parser.VCSLogParser;
import cz.encircled.macl.transform.MessageProcessor;
import java.io.BufferedWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.plugin.logging.Log;

public class ChangelogExecutor {
    private final ChangelogConfiguration conf;
    private final VCSLogParser vcsLogParser;
    private final MessageProcessor messageProcessor;

    public ChangelogExecutor(ChangelogConfiguration conf, VCSLogParser vcsLogParser, MessageProcessor messageProcessor) {
        this.conf = conf;
        this.vcsLogParser = vcsLogParser;
        this.messageProcessor = messageProcessor;
    }

    public void run(Log log) {
        try {
            log.debug((CharSequence)("Changelog file: " + this.conf.pathToChangelog));
            log.info((CharSequence)("New messages pattern: " + this.conf.applicableCommitPattern.pattern()));
            List<String> allLines = Files.lines(this.conf.pathToChangelog).map(String::trim).collect(Collectors.toList());
            Pair<String, Integer> lastTag = this.getLastTag(allLines);
            log.info((CharSequence)("Last tag: " + lastTag));
            Set<String> newMessages = this.messageProcessor.getNewMessages(this.vcsLogParser.getNewMessages(log, (String)lastTag.getLeft()));
            if (newMessages.isEmpty()) {
                log.info((CharSequence)"No new messages");
                return;
            }
            int unreleasedIndex = this.getIndexOfUnreleasedLine(allLines);
            log.info((CharSequence)("Count of new messages: " + newMessages.size()));
            log.debug((CharSequence)("Index of 'Unreleased' line: " + unreleasedIndex));
            List<String> resultLines = this.insertNewMessages(allLines, newMessages, unreleasedIndex, (Integer)lastTag.getRight());
            try (BufferedWriter writer = Files.newBufferedWriter(this.conf.pathToChangelog, StandardCharsets.UTF_8, StandardOpenOption.APPEND);){
                for (String line : resultLines) {
                    writer.write(line);
                    writer.write(10);
                }
                writer.flush();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public List<String> insertNewMessages(List<String> allLines, Collection<String> newMessages, int unreleasedIndex, Integer lastTagIndex) {
        int afterUnreleased = unreleasedIndex + 1;
        ArrayList<String> linesToInsert = new ArrayList<String>();
        ArrayList<String> present = new ArrayList<String>(allLines.subList(afterUnreleased, lastTagIndex));
        newMessages.stream().filter(m -> !present.contains(m)).forEach(linesToInsert::add);
        if (((String)present.get(0)).isEmpty()) {
            linesToInsert.add(0, "");
            present.remove(0);
        }
        linesToInsert.addAll(present);
        ArrayList<String> result = new ArrayList<String>(allLines.subList(0, afterUnreleased));
        result.addAll(linesToInsert);
        result.addAll(allLines.subList(lastTagIndex, allLines.size()));
        return result;
    }

    public Pair<String, Integer> getLastTag(List<String> allLines) {
        if (this.conf.lastTag != null) {
            return Pair.of((Object)this.conf.lastTag, null);
        }
        for (int i = 0; i < allLines.size(); ++i) {
            Matcher matcher = this.conf.lastTagPattern.matcher(allLines.get(i));
            if (!matcher.matches()) continue;
            return Pair.of((Object)String.format(this.conf.lastTagFormat, matcher.group(1)), (Object)i);
        }
        throw new IllegalStateException("Last tag not found for pattern " + this.conf.lastTagPattern.pattern());
    }

    public int getIndexOfUnreleasedLine(List<String> allLines) {
        for (int i = 0; i < allLines.size(); ++i) {
            if (!this.conf.unreleasedRowPattern.matcher(allLines.get(i)).matches()) continue;
            return i;
        }
        throw new IllegalStateException("Row with unreleased changes was not found for pattern " + this.conf.unreleasedRowPattern.pattern());
    }
}

