/*
 * Decompiled with CFR 0.152.
 */
package cz.encircled.macl.parser;

import cz.encircled.macl.CommandExecutor;
import cz.encircled.macl.parser.VCSLogParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.logging.Log;

public class GitLogParser
implements VCSLogParser {
    private final CommandExecutor commandExecutor;
    private static final String command = "git log %s..HEAD";

    public GitLogParser(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<String> getNewMessages(Log log, String tagFrom) {
        String command = String.format(command, tagFrom);
        log.info((CharSequence)String.format("GitParser executing command [%s]", command));
        try (BufferedReader input = new BufferedReader(new InputStreamReader(this.commandExecutor.exec(command)));){
            Set set = input.lines().collect(Collectors.toCollection(LinkedHashSet::new));
            return set;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read changelog file", e);
        }
    }
}

