/*
 * Decompiled with CFR 0.152.
 */
package cz.encircled.macl.transform;

import cz.encircled.macl.ChangelogConfiguration;
import cz.encircled.macl.parser.ParsingState;
import cz.encircled.macl.transform.MessageFilter;
import cz.encircled.macl.transform.MessageModifier;
import cz.encircled.macl.transform.MessageProcessor;
import cz.encircled.macl.transform.MessageTransformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;

public class DefaultMessageProcessor
implements MessageProcessor {
    private final ChangelogConfiguration conf;
    private final Log log;
    private final Collection<MessageFilter> filters;
    private final Collection<MessageTransformer> transformers;
    private final List<MessageModifier> modifiers;

    public DefaultMessageProcessor(Log log, ChangelogConfiguration conf, List<MessageFilter> filters, List<MessageTransformer> transformers, List<MessageModifier> modifiers) {
        this.conf = conf;
        this.log = log;
        this.filters = Collections.unmodifiableList(filters);
        this.transformers = Collections.unmodifiableList(transformers);
        this.modifiers = Collections.unmodifiableList(modifiers);
    }

    @Override
    public Set<String> getNewMessages(Collection<String> messages) {
        ArrayList result = new ArrayList();
        ParsingState state = new ParsingState(this.conf);
        messages.forEach(m -> {
            for (MessageFilter filter : this.filters) {
                boolean accept = filter.accept((String)m, state);
                if (!accept) continue;
                state.isAccepted = true;
                break;
            }
            for (MessageTransformer transformer : this.transformers) {
                m = transformer.transform((String)m, state);
            }
            for (MessageModifier modifier : this.modifiers) {
                if (state.previousMatched == null || !modifier.accept((String)m, state)) continue;
                result.remove(result.size() - 1);
                result.add(modifier.modify((String)m, state));
            }
            if (state.isAccepted.booleanValue()) {
                result.add(m);
                state.previousMatched = m;
            } else {
                this.log.info((CharSequence)("Message [" + m + "] excluded"));
            }
            state.isAccepted = false;
        });
        this.log.info((CharSequence)String.format("Count of new matched messages is %d", result.size()));
        return new LinkedHashSet<String>(result);
    }
}

