/*
 * Decompiled with CFR 0.152.
 */
package cz.encircled.macl;

import cz.encircled.macl.ChangelogConfiguration;
import cz.encircled.macl.ChangelogExecutor;
import cz.encircled.macl.DefaultCommandExecutor;
import cz.encircled.macl.parser.GitLogParser;
import cz.encircled.macl.transform.DefaultMessageProcessor;
import cz.encircled.macl.transform.GitLabMergeRequestModifier;
import cz.encircled.macl.transform.MessageFilter;
import cz.encircled.macl.transform.MessageTransformer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate-changelog", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, aggregator=true)
public class ChangelogMojo
extends AbstractMojo {
    private static final String NEW_LINE = System.getProperty("line.separator");
    @Parameter(defaultValue="CHANGELOG.md")
    protected String pathToChangelog;
    @Parameter
    protected String lastTag;
    @Parameter
    protected String lastTagPattern;
    @Parameter(defaultValue="%s")
    protected String lastTagFormat;
    @Parameter(required=true)
    protected String applicableCommitPattern;
    @Parameter(defaultValue="%s")
    protected String commitFormat;
    @Parameter(required=true)
    protected String unreleasedRowPattern;
    @Parameter
    protected String mergeRequestReplacePattern;
    @Parameter(defaultValue=" MR#$1")
    protected String mergeRequestReplacement;
    @Parameter(defaultValue="false")
    protected String incrementVersionAfterRun;
    public static final List<MessageFilter> filters = Collections.singletonList((needle, state) -> state.conf.applicableCommitPattern.matcher(needle).matches());
    public static final List<MessageTransformer> transformers = Arrays.asList((needle, state) -> state.previousMatched == null ? NEW_LINE + needle : needle, (needle, state) -> needle.trim(), (needle, state) -> String.format(state.conf.commitFormat, needle));

    public void execute() throws MojoExecutionException, MojoFailureException {
        ChangelogConfiguration conf = this.getChangelogConfiguration();
        DefaultMessageProcessor messageProcessor = new DefaultMessageProcessor(this.getLog(), conf, filters, transformers, Collections.singletonList(new GitLabMergeRequestModifier(conf)));
        new ChangelogExecutor(conf, new GitLogParser(new DefaultCommandExecutor()), messageProcessor).run(this.getLog());
    }

    public ChangelogConfiguration getChangelogConfiguration() {
        return new ChangelogConfiguration().setApplicableCommitPattern(this.applicableCommitPattern).setLastTagPattern(this.lastTagPattern).setPathToChangelog(this.pathToChangelog).setUnreleasedRowPattern(this.unreleasedRowPattern).setLastTagFormat(this.lastTagFormat).setLastTag(this.lastTag).setCommitFormat(this.commitFormat).setMergeRequestReplacePattern(this.mergeRequestReplacePattern).setMergeRequestReplacement(this.mergeRequestReplacement).setIncrementVersionAfterRun(this.incrementVersionAfterRun).valid();
    }
}

