/*
 * Decompiled with CFR 0.152.
 */
package cz.encircled.macl;

import cz.encircled.macl.ChangelogConfiguration;
import cz.encircled.macl.parser.VCSLogParser;
import cz.encircled.macl.transform.MessageProcessor;
import java.io.BufferedWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.plugin.logging.Log;

public class ChangelogExecutor {
    private final ChangelogConfiguration conf;
    private final VCSLogParser vcsLogParser;
    private final MessageProcessor messageProcessor;

    public ChangelogExecutor(ChangelogConfiguration conf, VCSLogParser vcsLogParser, MessageProcessor messageProcessor) {
        this.conf = conf;
        this.vcsLogParser = vcsLogParser;
        this.messageProcessor = messageProcessor;
    }

    public void run(Log log) {
        try {
            log.debug((CharSequence)("Changelog file: " + this.conf.pathToChangelog));
            log.info((CharSequence)("New messages pattern: " + this.conf.applicableCommitPattern.pattern()));
            List<String> allLines = Files.lines(this.conf.pathToChangelog).map(String::trim).collect(Collectors.toList());
            Pair<String, Integer> lastTag = this.getLastTag(allLines);
            log.info((CharSequence)("Last tag: " + lastTag));
            Set<String> newMessages = this.messageProcessor.getNewMessages(this.vcsLogParser.getNewMessages(log, (String)lastTag.getLeft()));
            if (newMessages.isEmpty()) {
                log.info((CharSequence)"No new messages");
                return;
            }
            int unreleasedIndex = this.getIndexOfUnreleasedLine(allLines);
            log.info((CharSequence)("Count of new messages: " + newMessages.size()));
            log.debug((CharSequence)("Index of 'Unreleased' line: " + unreleasedIndex));
            List<String> resultLines = this.insertNewMessages(allLines, newMessages, unreleasedIndex, lastTag);
            try (BufferedWriter writer = Files.newBufferedWriter(this.conf.pathToChangelog, StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING);){
                for (String line : resultLines) {
                    writer.write(line);
                    writer.write(10);
                }
                writer.flush();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public List<String> insertNewMessages(List<String> allLines, Collection<String> newMessages, int unreleasedIndex, Pair<String, Integer> lastTag) {
        int afterUnreleased = unreleasedIndex + 1;
        ArrayList<String> linesToInsert = new ArrayList<String>();
        if (this.conf.incrementVersionAfterRun == Boolean.TRUE) {
            linesToInsert.add("");
            String incremented = this.incrementLastTag((String)lastTag.getLeft());
            String s = allLines.get((Integer)lastTag.getRight()).replaceFirst((String)lastTag.getLeft(), incremented);
            linesToInsert.add(s);
            linesToInsert.add("");
        }
        ArrayList<String> present = new ArrayList<String>(allLines.subList(afterUnreleased, (Integer)lastTag.getRight()));
        newMessages.stream().filter(m -> !present.contains(m)).forEach(linesToInsert::add);
        if (((String)present.get(0)).isEmpty()) {
            linesToInsert.add(0, "");
            present.remove(0);
        }
        linesToInsert.addAll(present);
        ArrayList<String> result = new ArrayList<String>(allLines.subList(0, afterUnreleased));
        result.addAll(linesToInsert);
        result.addAll(allLines.subList((Integer)lastTag.getRight(), allLines.size()));
        return result;
    }

    public String incrementLastTag(String lastTag) {
        StringBuilder result = new StringBuilder(lastTag);
        Integer start = null;
        Integer end = null;
        for (int i = result.length() - 1; i >= 0 && start == null; --i) {
            if (end == null && Character.isDigit(result.charAt(i))) {
                end = i + 1;
            }
            if (end == null || Character.isDigit(result.charAt(i))) continue;
            start = i + 1;
        }
        if (start == null) {
            start = 0;
        }
        if (end == null) {
            throw new IllegalStateException("Can't find version number in the last tag");
        }
        int version = Integer.parseInt(result.substring(start, end));
        result.replace(start, end, Integer.toString(++version));
        return result.toString();
    }

    public Pair<String, Integer> getLastTag(List<String> allLines) {
        if (this.conf.lastTag != null) {
            return Pair.of((Object)this.conf.lastTag, null);
        }
        for (int i = 0; i < allLines.size(); ++i) {
            Matcher matcher = this.conf.lastTagPattern.matcher(allLines.get(i));
            if (!matcher.matches()) continue;
            return Pair.of((Object)String.format(this.conf.lastTagFormat, matcher.group(1)), (Object)i);
        }
        throw new IllegalStateException("Last tag not found for pattern " + this.conf.lastTagPattern.pattern());
    }

    public int getIndexOfUnreleasedLine(List<String> allLines) {
        for (int i = 0; i < allLines.size(); ++i) {
            if (!this.conf.unreleasedRowPattern.matcher(allLines.get(i)).matches()) continue;
            return i;
        }
        throw new IllegalStateException("Row with unreleased changes was not found for pattern " + this.conf.unreleasedRowPattern.pattern());
    }
}

