/*
 * Decompiled with CFR 0.152.
 */
package cz.encircled.macl;

import cz.encircled.macl.ChangelogConfiguration;
import cz.encircled.macl.VCSLogParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class GitLogParser
implements VCSLogParser {
    private final ChangelogConfiguration conf;
    private static final String command = "git log %s..HEAD";

    public GitLogParser(ChangelogConfiguration conf) {
        this.conf = conf;
    }

    @Override
    public List<String> getNewMessages(String tagFrom) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        Process p = Runtime.getRuntime().exec(String.format(command, tagFrom));
        new Thread(() -> {
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            result.addAll(input.lines().filter(l -> this.conf.applicableCommitPattern.matcher((CharSequence)l).matches()).map(s -> String.format(this.conf.commitFormat, s.trim())).collect(Collectors.toList()));
        }).start();
        p.waitFor();
        return result;
    }
}

