/*
 * Decompiled with CFR 0.152.
 */
package cz.encircled.jira.reactive;

import cz.encircled.jira.reactive.ReactiveJiraClient;
import cz.encircled.jira.reactive.model.Issue;
import cz.encircled.jira.reactive.model.JiraFilter;
import cz.encircled.jira.reactive.model.RapidBoardsSprints;
import cz.encircled.jira.reactive.model.SearchResult;
import cz.encircled.jira.reactive.model.SprintReport;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.springframework.util.Base64Utils;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\rJ$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000f2\u0006\u0010\u0014\u001a\u00020\u00032\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\rJ\u0006\u0010\u0019\u001a\u00020\u001aJ.\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000f2\u0006\u0010\u001d\u001a\u00020\u00032\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u00162\b\b\u0002\u0010\u001e\u001a\u00020\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcz/encircled/jira/reactive/ReactiveJiraClient;", "", "baseUrl", "", "username", "password", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "client", "Lorg/springframework/web/reactive/function/client/WebClient;", "getActiveSprints", "Lreactor/core/publisher/Flux;", "Lcz/encircled/jira/reactive/model/SprintReport;", "rapidBoardId", "", "getFilter", "Lreactor/core/publisher/Mono;", "Lcz/encircled/jira/reactive/model/JiraFilter;", "id", "getIssue", "Lcz/encircled/jira/reactive/model/Issue;", "key", "includedFields", "", "getSprintReport", "sprintId", "registerCustomFieldAlias", "", "searchIssues", "Lcz/encircled/jira/reactive/model/SearchResult;", "jql", "maxResults", "reactive-jira-client"})
public final class ReactiveJiraClient {
    private final WebClient client;

    public final void registerCustomFieldAlias() {
        throw (Throwable)new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Mono<Issue> getIssue(@NotNull String key, @NotNull List<String> includedFields) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(includedFields, (String)"includedFields");
        String fields = CollectionsKt.joinToString$default((Iterable)includedFields, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        Mono mono = this.client.get().uri("/api/latest/issue/" + key + "?fields=" + fields, new Object[0]).retrieve().bodyToMono(Issue.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)mono, (String)"client.get()\n           \u2026ToMono(Issue::class.java)");
        return mono;
    }

    @NotNull
    public static /* synthetic */ Mono getIssue$default(ReactiveJiraClient reactiveJiraClient, String string, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return reactiveJiraClient.getIssue(string, list);
    }

    @NotNull
    public final Mono<JiraFilter> getFilter(int id) {
        Mono mono = this.client.get().uri("/api/latest/filter/" + id, new Object[0]).retrieve().bodyToMono(JiraFilter.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)mono, (String)"client.get()\n           \u2026o(JiraFilter::class.java)");
        return mono;
    }

    @NotNull
    public final Mono<SearchResult> searchIssues(@NotNull String jql, @NotNull List<String> includedFields, int maxResults) {
        Intrinsics.checkParameterIsNotNull((Object)jql, (String)"jql");
        Intrinsics.checkParameterIsNotNull(includedFields, (String)"includedFields");
        Mono mono = this.client.get().uri((Function)new Function<UriBuilder, URI>(jql, maxResults, includedFields){
            final /* synthetic */ String $jql;
            final /* synthetic */ int $maxResults;
            final /* synthetic */ List $includedFields;

            public final URI apply(UriBuilder it) {
                return it.path("/api/latest/search").queryParam("jql", new Object[]{this.$jql}).queryParam("maxResults", new Object[]{this.$maxResults}).queryParam("fields", new Object[]{CollectionsKt.joinToString$default((Iterable)this.$includedFields, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)}).build(new Object[0]);
            }
            {
                this.$jql = string;
                this.$maxResults = n;
                this.$includedFields = list;
            }
        }).retrieve().bodyToMono(SearchResult.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)mono, (String)"client.get()\n           \u2026SearchResult::class.java)");
        return mono;
    }

    @NotNull
    public static /* synthetic */ Mono searchIssues$default(ReactiveJiraClient reactiveJiraClient, String string, List list, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 4) != 0) {
            n = 50;
        }
        return reactiveJiraClient.searchIssues(string, list, n);
    }

    @NotNull
    public final Flux<SprintReport> getActiveSprints(int rapidBoardId) {
        Flux flux = this.client.get().uri("/greenhopper/1.0/sprintquery/" + rapidBoardId, new Object[0]).retrieve().bodyToMono(RapidBoardsSprints.class).map((Function)getActiveSprints.1.INSTANCE).flatMapMany((Function)getActiveSprints.2.INSTANCE).flatMap(new Function<T, Publisher<? extends R>>(this, rapidBoardId){
            final /* synthetic */ ReactiveJiraClient this$0;
            final /* synthetic */ int $rapidBoardId;

            @NotNull
            public final Mono<SprintReport> apply(Integer it) {
                Integer n = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"it");
                return this.this$0.getSprintReport(this.$rapidBoardId, n);
            }
            {
                this.this$0 = reactiveJiraClient;
                this.$rapidBoardId = n;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)flux, (String)"client.get()\n           \u2026eport(rapidBoardId, it) }");
        return flux;
    }

    @NotNull
    public final Mono<SprintReport> getSprintReport(int rapidBoardId, int sprintId) {
        Mono mono = this.client.get().uri("/greenhopper/1.0/rapid/charts/sprintreport?rapidViewId=" + rapidBoardId + "&sprintId=" + sprintId, new Object[0]).retrieve().bodyToMono(SprintReport.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)mono, (String)"client.get()\n           \u2026SprintReport::class.java)");
        return mono;
    }

    public ReactiveJiraClient(@NotNull String baseUrl, @NotNull String username, @NotNull String password) {
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        WebClient.Builder builder = WebClient.builder().baseUrl(baseUrl + "/rest");
        CharSequence charSequence = username;
        if (charSequence.length() > 0 && (charSequence = (CharSequence)password).length() > 0) {
            String[] stringArray;
            charSequence = username + ':' + password;
            Charset charset = Charsets.UTF_8;
            StringBuilder stringBuilder = new StringBuilder().append("Basic ");
            int n = 0;
            String[] stringArray2 = stringArray = new String[1];
            String string = "Authorization";
            WebClient.Builder builder2 = builder;
            CharSequence charSequence2 = charSequence;
            if (charSequence2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = ((String)charSequence2).getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            stringArray[n] = stringBuilder.append(Base64Utils.encodeToString((byte[])byArray2)).toString();
            builder2.defaultHeader(string, stringArray2);
        }
        WebClient webClient = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)webClient, (String)"builder.build()");
        this.client = webClient;
    }

    public /* synthetic */ ReactiveJiraClient(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            string3 = "";
        }
        this(string, string2, string3);
    }
}

