/*
 * Decompiled with CFR 0.152.
 */
package cz.etnetera.reesmo.writer.model.result;

import cz.etnetera.reesmo.writer.model.AuditedModel;
import cz.etnetera.reesmo.writer.model.result.ResultAttachment;
import cz.etnetera.reesmo.writer.model.result.ResultLink;
import cz.etnetera.reesmo.writer.model.result.TestCategory;
import cz.etnetera.reesmo.writer.model.result.TestSeverity;
import cz.etnetera.reesmo.writer.model.result.TestStatus;
import cz.etnetera.reesmo.writer.model.result.TestType;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class Result
extends AuditedModel {
    private String id;
    private String projectId;
    private String suite;
    private String suiteId;
    private String job;
    private String jobId;
    private String milestone;
    private String name;
    private String description;
    private String environment;
    private String author;
    private Date startedAt;
    private Date endedAt;
    private Long length;
    private TestStatus status;
    private TestSeverity severity;
    private boolean automated;
    private List<String> labels = new ArrayList<String>();
    private List<String> notes = new ArrayList<String>();
    private List<String> errors = new ArrayList<String>();
    private List<TestCategory> categories = new ArrayList<TestCategory>();
    private List<TestType> types = new ArrayList<TestType>();
    private List<ResultAttachment> attachments = new ArrayList<ResultAttachment>();
    private List<ResultLink> links = new ArrayList<ResultLink>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getSuite() {
        return this.suite;
    }

    public void setSuite(String suite) {
        this.suite = suite;
    }

    public String getSuiteId() {
        return this.suiteId;
    }

    public void setSuiteId(String suiteId) {
        this.suiteId = suiteId;
    }

    public String getJob() {
        return this.job;
    }

    public void setJob(String job) {
        this.job = job;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getMilestone() {
        return this.milestone;
    }

    public void setMilestone(String milestone) {
        this.milestone = milestone;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public Date getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(Date startedAt) {
        this.startedAt = startedAt;
    }

    public Date getEndedAt() {
        return this.endedAt;
    }

    public void setEndedAt(Date endedAt) {
        this.endedAt = endedAt;
    }

    public Long getLength() {
        return this.length;
    }

    public void setLength(Long length) {
        this.length = length;
    }

    public TestStatus getStatus() {
        return this.status;
    }

    public void setStatus(TestStatus status) {
        this.status = status;
    }

    public TestSeverity getSeverity() {
        return this.severity;
    }

    public void setSeverity(TestSeverity severity) {
        this.severity = severity;
    }

    public boolean isAutomated() {
        return this.automated;
    }

    public void setAutomated(boolean automated) {
        this.automated = automated;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    public List<TestCategory> getCategories() {
        return this.categories;
    }

    public void setCategories(List<TestCategory> categories) {
        this.categories = categories;
    }

    public List<TestType> getTypes() {
        return this.types;
    }

    public void setTypes(List<TestType> types) {
        this.types = types;
    }

    public List<ResultAttachment> getAttachments() {
        return this.attachments;
    }

    public List<ResultLink> getLinks() {
        return this.links;
    }

    public void setLinks(List<ResultLink> links) {
        this.links = links;
    }

    public Result addLabel(String label) {
        this.labels.add(label);
        return this;
    }

    public Result addNote(String note) {
        this.notes.add(note);
        return this;
    }

    public Result addError(String error) {
        this.errors.add(error);
        return this;
    }

    public Result addError(Throwable error) {
        this.errors.add(this.createErrorFromThrowable(error));
        return this;
    }

    public void setThrowables(List<Throwable> errors) {
        this.errors = errors.stream().map(e -> this.createErrorFromThrowable((Throwable)e)).collect(Collectors.toList());
    }

    public Result addCategory(TestCategory category) {
        this.categories.add(category);
        return this;
    }

    public Result addType(TestType type) {
        this.types.add(type);
        return this;
    }

    public Result addLink(ResultLink link) {
        this.links.add(link);
        return this;
    }

    private String createErrorFromThrowable(Throwable error) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s: %s", error.getClass().getSimpleName(), error.getMessage()));
        sb.append("\n");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        error.printStackTrace(pw);
        sb.append(sw.getBuffer());
        return sb.toString();
    }
}

