/*
 * Decompiled with CFR 0.152.
 */
package cz.etnetera.reesmo.writer.storage;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.body.MultipartBody;
import cz.etnetera.reesmo.writer.model.result.Result;
import cz.etnetera.reesmo.writer.model.result.ResultAttachment;
import cz.etnetera.reesmo.writer.storage.FileWithPath;
import cz.etnetera.reesmo.writer.storage.Storage;
import cz.etnetera.reesmo.writer.storage.StorageException;
import java.io.File;
import java.io.IOException;
import java.net.URLConnection;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RestApiStorage
extends Storage {
    public static final String PROPERTY_NAME = "restapi";
    protected static final String METHOD_RESULT_CREATE = "/api/results/create";
    protected static final String METHOD_RESULT_CREATE_PROJECT_KEY = "/api/results/create/{projectKey}";
    protected static final String METHOD_RESULT_DELETE = "/api/results/delete/{resultId}";
    protected static final String METHOD_RESULT_ATTACHMENT_CREATE = "/api/results/attachment/create/{resultId}";
    protected static final String VIEW_RESULT_DETAIL = "/result/detail/{resultId}";
    protected static final Map<String, String> FIXED_CONTENT_TYPES = new HashMap<String, String>();
    protected String endpoint;
    protected String username;
    protected String password;

    public RestApiStorage(String endpoint, String username, String password) throws StorageException {
        if (endpoint == null || endpoint.isEmpty()) {
            throw new StorageException("Endpoint is null or empty");
        }
        if (username == null || username.isEmpty()) {
            throw new StorageException("Username is null or empty");
        }
        if (password == null || password.isEmpty()) {
            throw new StorageException("Password is null or empty");
        }
        this.endpoint = endpoint.replaceAll("/+$", "");
        this.username = username;
        this.password = password;
    }

    @Override
    protected Result createResult(String projectKey, Result result, List<Object> attachments) throws StorageException {
        String url = projectKey == null ? this.getUrl(METHOD_RESULT_CREATE) : this.getUrl(METHOD_RESULT_CREATE_PROJECT_KEY).replace("{projectKey}", projectKey);
        result = this.requestEntity(result, url);
        this.getLogger().info("Result created " + result.getId() + " " + this.getUrl(VIEW_RESULT_DETAIL).replace("{resultId}", result.getId()));
        if (attachments != null) {
            for (Object attachment : attachments) {
                try {
                    this.addResultAttachment(result, attachment);
                }
                catch (StorageException e) {
                    throw new StorageException("Unable to store result attachment", e);
                }
            }
        }
        return result;
    }

    @Override
    protected void deleteResult(Result result) throws StorageException {
        this.request(this.getUrl(METHOD_RESULT_DELETE).replace("{resultId}", result.getId()));
    }

    protected void addResultAttachment(final Result result, Object attachment) throws StorageException {
        HttpResponse response;
        File file = null;
        String path = null;
        if (attachment instanceof File) {
            file = (File)attachment;
        } else if (attachment instanceof FileWithPath) {
            FileWithPath fileWithPath = (FileWithPath)attachment;
            file = fileWithPath.getFile();
            path = fileWithPath.getPath();
        } else {
            throw new StorageException("Unsupported attachment type " + attachment.getClass());
        }
        if (path != null) {
            path = path.replaceAll("^/+", "").replaceAll("/+$", "");
        }
        if (file.isDirectory()) {
            final Path root = file.toPath();
            final String rootPath = path == null ? file.getName() : path;
            try {
                Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        FileVisitResult res = super.visitFile(file, attrs);
                        String relativePath = rootPath + "/" + root.relativize(file).normalize().toString();
                        try {
                            RestApiStorage.this.addResultAttachment(result, new FileWithPath(file.toFile(), relativePath));
                        }
                        catch (StorageException e) {
                            throw new IOException(e);
                        }
                        return res;
                    }
                });
            }
            catch (IOException e) {
                throw new StorageException(e);
            }
            return;
        }
        MultipartBody body = Unirest.post((String)this.getUrl(METHOD_RESULT_ATTACHMENT_CREATE).replace("{resultId}", result.getId())).basicAuth(this.username, this.password).header("Accept", "application/json").field("file", file, this.getContentType(file));
        if (path != null) {
            body.field("path", path);
        }
        try {
            response = body.asString();
        }
        catch (UnirestException e) {
            throw new StorageException("Unable to store result attachment", e);
        }
        if (response.getStatus() != 200) {
            throw new StorageException("Wrong status code when storing result attachment " + response.getStatus());
        }
        ResultAttachment resultAttachment = null;
        try {
            resultAttachment = (ResultAttachment)new ObjectMapper().readValue((String)response.getBody(), ResultAttachment.class);
        }
        catch (IOException | UnsupportedOperationException e) {
            throw new StorageException("Unable to parse result attachment from response", e);
        }
        this.getLogger().info("Result attachment stored " + resultAttachment.getId());
    }

    protected String getUrl(String uri) {
        return this.endpoint + uri;
    }

    protected <T> T requestEntity(T entity, String url) throws StorageException {
        HttpResponse response;
        try {
            response = Unirest.post((String)url).basicAuth(this.username, this.password).header("Accept", "application/json").header("Content-Type", "application/json; charset=UTF-8").body(new ObjectMapper().writeValueAsString(entity)).asString();
        }
        catch (JsonProcessingException | UnirestException e) {
            throw new StorageException("Unable to execute entity request on url " + url, e);
        }
        if (response.getStatus() != 200) {
            throw new StorageException("Wrong status code " + response.getStatus() + " when requesting entity url " + url);
        }
        try {
            entity = new ObjectMapper().readValue((String)response.getBody(), entity.getClass());
        }
        catch (IOException | UnsupportedOperationException e) {
            throw new StorageException("Unable to parse result from response while requesting url " + url, e);
        }
        return entity;
    }

    protected void request(String url) throws StorageException {
        HttpResponse response;
        try {
            response = Unirest.get((String)url).basicAuth(this.username, this.password).asString();
        }
        catch (UnirestException e) {
            throw new StorageException("Unable to execute request on url " + url, e);
        }
        if (response.getStatus() != 200) {
            throw new StorageException("Wrong status code " + response.getStatus() + " when requesting url " + url);
        }
    }

    protected String getContentType(File file) {
        String extension;
        String contentType = null;
        String filename = file.getName();
        int extensionSepIndex = filename.lastIndexOf(".");
        if (extensionSepIndex > -1 && (contentType = FIXED_CONTENT_TYPES.get((extension = filename.substring(extensionSepIndex + 1)).toLowerCase())) == null) {
            contentType = URLConnection.guessContentTypeFromName(file.getName());
        }
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        return contentType;
    }

    static {
        FIXED_CONTENT_TYPES.put("log", "text/plain");
    }
}

