/*
 * Decompiled with CFR 0.152.
 */
package cz.etnetera.reesmo.writer;

import cz.etnetera.reesmo.writer.Bool;
import cz.etnetera.reesmo.writer.ReesmoConfiguration;
import cz.etnetera.reesmo.writer.model.result.ResultLink;
import cz.etnetera.reesmo.writer.model.result.TestSeverity;
import cz.etnetera.reesmo.writer.storage.DummyStorage;
import cz.etnetera.reesmo.writer.storage.FileSystemStorage;
import cz.etnetera.reesmo.writer.storage.RestApiStorage;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum Property {
    ENABLED("enabled", (Object)((Object)Bool.FALSE)),
    STORAGE("storage", FileSystemStorage.class),
    BASE_DIR("basedir", new File("reesmo-output")),
    PROJECT_ID("projectid", null),
    PROJECT_KEY("projectkey", null),
    SUITE("suite", null),
    SUITE_ID("suiteid", null),
    JOB("job", null),
    JOB_ID("jobid", null),
    ENDPOINT("endpoint", null),
    USERNAME("username", null),
    PASSWORD("password", null),
    MILESTONE("milestone", null),
    NAME("name", null),
    DESCRIPTION("description", null),
    ENVIRONMENT("environment", null),
    AUTHOR("author", null),
    SEVERITY("severity", null),
    LABELS("labels", new ArrayList<E>()),
    NOTES("notes", new ArrayList<E>()),
    LINKS("links", new ArrayList<E>());

    private String key;
    private Object def;

    private Property(String key, Object def) {
        this.key = "reesmo." + key;
        this.def = def;
    }

    public Object get() {
        String value = System.getProperty(this.key);
        if (value != null) {
            switch (this) {
                case ENABLED: {
                    return Bool.valueOfString(value);
                }
                case STORAGE: {
                    if (value.equals(DummyStorage.class.getName()) || value.equals(DummyStorage.class.getSimpleName()) || value.equals("dummy")) {
                        return DummyStorage.class;
                    }
                    if (value.equals(FileSystemStorage.class.getName()) || value.equals(FileSystemStorage.class.getSimpleName()) || value.equals("filesystem")) {
                        return FileSystemStorage.class;
                    }
                    if (!value.equals(RestApiStorage.class.getName()) && !value.equals(RestApiStorage.class.getSimpleName()) && !value.equals("restapi")) break;
                    return RestApiStorage.class;
                }
                case BASE_DIR: {
                    return new File(value);
                }
                case SEVERITY: {
                    return TestSeverity.valueOf(value);
                }
                case LABELS: {
                    return new ArrayList<String>(Arrays.asList(value.split(";")));
                }
                case NOTES: {
                    return new ArrayList<String>(Arrays.asList(value.split(";")));
                }
                case LINKS: {
                    return this.convertStringsToResultLinks(value.split(";"));
                }
                default: {
                    return value;
                }
            }
        }
        return this.def;
    }

    public Object get(List<Object> configurations) {
        return this.get(configurations, null);
    }

    public Object get(List<Object> configurations, Object defaultValue) {
        if (configurations == null) {
            return this.get();
        }
        Object value = null;
        Object newValue = null;
        for (Object source : configurations) {
            newValue = this.get(source, false);
            if (value instanceof List && newValue instanceof List) {
                ((List)value).addAll((List)newValue);
                continue;
            }
            if (newValue == null) continue;
            value = newValue;
        }
        if (value == null) {
            value = this.get();
        }
        return value == null ? defaultValue : value;
    }

    public Object get(Object configuration) {
        return this.get(configuration, null);
    }

    public Object get(Object configuration, Object defaultValue) {
        if (configuration instanceof List) {
            return this.get((List)configuration, defaultValue);
        }
        Object value = this.get(configuration, true);
        return value == null ? defaultValue : value;
    }

    public Object get(Object configuration, boolean useSystemProperty) {
        if (configuration == null) {
            return useSystemProperty ? this.get() : null;
        }
        List<ResultLink> value = null;
        ReesmoConfiguration conf = null;
        conf = configuration instanceof ReesmoConfiguration ? (ReesmoConfiguration)configuration : (configuration instanceof Method ? ((Method)configuration).getAnnotation(ReesmoConfiguration.class) : (configuration instanceof Class ? ((Class)configuration).getAnnotation(ReesmoConfiguration.class) : configuration.getClass().getAnnotation(ReesmoConfiguration.class)));
        if (conf != null) {
            switch (this) {
                case ENABLED: {
                    value = this.getFirstValue((Object[])conf.enabled());
                    break;
                }
                case STORAGE: {
                    value = this.getFirstValue(conf.storage());
                    break;
                }
                case BASE_DIR: {
                    value = this.getFirstValue(conf.baseDir());
                    break;
                }
                case PROJECT_ID: {
                    value = this.getFirstValue(conf.projectId());
                    break;
                }
                case PROJECT_KEY: {
                    value = this.getFirstValue(conf.projectKey());
                    break;
                }
                case SUITE: {
                    value = this.getFirstValue(conf.suite());
                    break;
                }
                case SUITE_ID: {
                    value = this.getFirstValue(conf.suiteId());
                    break;
                }
                case JOB: {
                    value = this.getFirstValue(conf.job());
                    break;
                }
                case JOB_ID: {
                    value = this.getFirstValue(conf.jobId());
                    break;
                }
                case ENDPOINT: {
                    value = this.getFirstValue(conf.endpoint());
                    break;
                }
                case USERNAME: {
                    value = this.getFirstValue(conf.username());
                    break;
                }
                case PASSWORD: {
                    value = this.getFirstValue(conf.password());
                    break;
                }
                case MILESTONE: {
                    value = this.getFirstValue(conf.milestone());
                    break;
                }
                case NAME: {
                    value = this.getFirstValue(conf.name());
                    break;
                }
                case DESCRIPTION: {
                    value = this.getFirstValue(conf.description());
                    break;
                }
                case ENVIRONMENT: {
                    value = this.getFirstValue(conf.environment());
                    break;
                }
                case AUTHOR: {
                    value = this.getFirstValue(conf.author());
                    break;
                }
                case SEVERITY: {
                    value = this.getFirstValue((Object[])conf.severity());
                    break;
                }
                case LABELS: {
                    value = new ArrayList<String>(Arrays.asList(conf.labels()));
                    break;
                }
                case NOTES: {
                    value = new ArrayList<String>(Arrays.asList(conf.notes()));
                    break;
                }
                case LINKS: {
                    value = this.convertStringsToResultLinks(conf.links());
                    break;
                }
            }
        }
        if (useSystemProperty) {
            return value == null ? this.get() : value;
        }
        return value;
    }

    private Object getFirstValue(Object[] values) {
        if (values == null || values.length < 1) {
            return null;
        }
        return values[0];
    }

    private List<ResultLink> convertStringsToResultLinks(String[] arr) {
        return Arrays.asList(arr).stream().filter(s -> s != null).map(s -> this.convertStringToResultLink((String)s)).collect(Collectors.toList());
    }

    private ResultLink convertStringToResultLink(String s) {
        ResultLink link = new ResultLink();
        String[] parts = s.split("|");
        if (parts.length > 1) {
            link.setName(parts[0]);
            link.setUrl(parts[1]);
        } else {
            link.setUrl(parts[0]);
        }
        return link;
    }
}

