/*
 * Decompiled with CFR 0.152.
 */
package cz.etnetera.reesmo.writer.storage;

import com.fasterxml.jackson.databind.ObjectMapper;
import cz.etnetera.reesmo.writer.model.Model;
import cz.etnetera.reesmo.writer.model.result.Result;
import cz.etnetera.reesmo.writer.storage.ExtendedFile;
import cz.etnetera.reesmo.writer.storage.Storage;
import cz.etnetera.reesmo.writer.storage.StorageException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.Date;
import java.util.List;

public class FileSystemStorage
extends Storage {
    public static final String PROPERTY_NAME = "filesystem";
    private File baseDir;

    public FileSystemStorage(File baseDir) throws StorageException {
        if (baseDir == null) {
            throw new StorageException("Base directory is null");
        }
        if (!baseDir.exists()) {
            if (baseDir.mkdirs()) {
                this.getLogger().info("Base directory was created: " + baseDir);
            } else {
                throw new StorageException("Base directory does not exists and can not be created: " + baseDir);
            }
        }
        if (!baseDir.canWrite()) {
            throw new StorageException("Base directory is not writeable: " + baseDir);
        }
        this.baseDir = baseDir;
    }

    @Override
    protected Result createResult(String projectKey, Result result, List<Object> attachments) throws StorageException {
        File baseDir = this.baseDir;
        File resultDir = this.createModelDir(baseDir, result);
        this.createModelFile(resultDir, result);
        if (projectKey != null) {
            this.createModelProjectKeyFile(resultDir, result, projectKey);
        }
        if (attachments != null && !attachments.isEmpty()) {
            File resultAttachmentDir = this.createResultAttachmentDir(resultDir);
            for (Object attachment : attachments) {
                if (attachment instanceof File) {
                    try {
                        Files.copy(((File)attachment).toPath(), resultAttachmentDir.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        continue;
                    }
                    catch (IOException e) {
                        throw new StorageException("Unable to copy result attachment file: " + attachment, e);
                    }
                }
                if (attachment instanceof ExtendedFile) {
                    ExtendedFile file = (ExtendedFile)attachment;
                    File targetFile = new File(resultAttachmentDir, file.getPath());
                    targetFile.mkdirs();
                    try {
                        Files.copy(file.getFile().toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        continue;
                    }
                    catch (IOException e) {
                        throw new StorageException("Unable to copy result attachment file: " + attachment, e);
                    }
                }
                throw new StorageException("Unsupported attachment type: " + attachment.getClass());
            }
        }
        this.createModelReadyFile(resultDir, result);
        result.setId(this.createModelId(resultDir));
        return result;
    }

    @Override
    protected void deleteResult(Result result) throws StorageException {
        File resultDir;
        try {
            resultDir = this.convertModelIdToDir(result.getId());
        }
        catch (StorageException e) {
            throw new StorageException("Result not found, it must be added before deleting");
        }
        this.deleteModelDir(resultDir, result);
    }

    protected File createResultAttachmentDir(File resultDir) {
        File attachmentDir = new File(resultDir, "attachments");
        attachmentDir.mkdir();
        this.getLogger().info("Result attachment directory created: " + attachmentDir);
        return attachmentDir;
    }

    protected File createModelDir(File baseDir, Model model) {
        String dirName = String.valueOf(new Date().getTime());
        int increment = 0;
        File dir = null;
        do {
            dir = increment == 0 ? new File(baseDir, dirName) : new File(baseDir, dirName + "-" + increment);
            ++increment;
        } while (dir.exists());
        dir.mkdir();
        this.getLogger().info(this.getModelName(model) + " directory created: " + dir);
        return dir;
    }

    protected File createModelFile(File modelDir, Model model) throws StorageException {
        try {
            File jsonFile = this.getModelJsonFile(modelDir, model);
            new ObjectMapper().writeValue(jsonFile, (Object)model);
            this.getLogger().info(this.getModelName(model) + " json file created: " + jsonFile);
            return jsonFile;
        }
        catch (IOException e) {
            throw new StorageException("Unable to create " + this.getModelName(model) + " json file", e);
        }
    }

    protected File createModelReadyFile(File modelDir, Model model) throws StorageException {
        try {
            File readyFile = this.getModelReadyFile(modelDir);
            readyFile.createNewFile();
            this.getLogger().info(this.getModelName(model) + " ready file created: " + readyFile);
            return readyFile;
        }
        catch (IOException e) {
            throw new StorageException("Unable to create " + this.getModelName(model) + " ready file", e);
        }
    }

    protected File createModelProjectKeyFile(File modelDir, Model model, String projectKey) throws StorageException {
        try {
            File projectFile = this.getModelProjectKeyFile(modelDir);
            Files.write(projectFile.toPath(), projectKey.getBytes(), new OpenOption[0]);
            this.getLogger().info(this.getModelName(model) + " project key file created: " + projectFile);
            return projectFile;
        }
        catch (IOException e) {
            throw new StorageException("Unable to create " + this.getModelName(model) + " project key file", e);
        }
    }

    protected File getModelJsonFile(File modelDir, Model model) {
        return new File(modelDir, this.getModelName(model) + ".json");
    }

    protected File getModelReadyFile(File modelDir) {
        return new File(modelDir, "ready");
    }

    protected File getModelProjectKeyFile(File modelDir) {
        return new File(modelDir, "projectkey");
    }

    protected boolean deleteModelDir(File modelDir, Model model) {
        this.getLogger().info("Deleting " + this.getModelName(model) + " directory: " + modelDir.getName());
        return this.deleteDir(modelDir);
    }

    protected boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            File[] children = dir.listFiles();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.deleteDir(children[i]);
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    protected File convertModelIdToDir(String modelId) throws StorageException {
        if (modelId == null) {
            throw new StorageException("Model directory is uknown because of empty model id");
        }
        File file = this.getModelIdDir(modelId);
        if (!file.exists()) {
            throw new StorageException("Model directory does not exists: " + file);
        }
        if (!file.isDirectory()) {
            throw new StorageException("Model directory is not directory: " + file);
        }
        if (!file.canWrite()) {
            throw new StorageException("Model directory is not writable: " + file);
        }
        return file;
    }

    protected File getModelIdDir(String modelId) {
        return new File(this.baseDir, modelId);
    }

    protected String createModelId(File modelDir) {
        return this.baseDir.toPath().relativize(modelDir.toPath()).normalize().toString().replaceAll(File.separator, "/");
    }

    protected String getModelName(Model model) {
        return model.getClass().getSimpleName();
    }
}

