/*
 * Decompiled with CFR 0.152.
 */
package cz.etnetera.reesmo.writer.storage;

import cz.etnetera.reesmo.writer.Bool;
import cz.etnetera.reesmo.writer.Property;
import cz.etnetera.reesmo.writer.model.result.Result;
import cz.etnetera.reesmo.writer.model.result.ResultLink;
import cz.etnetera.reesmo.writer.model.result.TestSeverity;
import cz.etnetera.reesmo.writer.model.result.TestStatus;
import cz.etnetera.reesmo.writer.storage.DummyStorage;
import cz.etnetera.reesmo.writer.storage.FileSystemStorage;
import cz.etnetera.reesmo.writer.storage.RestApiStorage;
import cz.etnetera.reesmo.writer.storage.StorageException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Storage {
    public static Storage newInstance(Object configuration) throws StorageException {
        try {
            Class clazz = null;
            clazz = Bool.FALSE.equals(Property.ENABLED.get(configuration)) ? DummyStorage.class : (Class)Property.STORAGE.get(configuration);
            if (clazz.isAssignableFrom(DummyStorage.class)) {
                return new DummyStorage();
            }
            if (clazz.isAssignableFrom(FileSystemStorage.class)) {
                return new FileSystemStorage((File)Property.BASE_DIR.get(configuration));
            }
            if (clazz.isAssignableFrom(RestApiStorage.class)) {
                return new RestApiStorage((String)Property.ENDPOINT.get(configuration), (String)Property.USERNAME.get(configuration), (String)Property.PASSWORD.get(configuration));
            }
            throw new StorageException("Unsupported storage type: " + clazz);
        }
        catch (Exception e) {
            throw new StorageException("Failed to create storage instance", e);
        }
    }

    public Result addResult(Result result) throws StorageException {
        return this.addResult((String)null, result, null);
    }

    public Result addResult(Result result, List<Object> attachments) throws StorageException {
        return this.addResult((String)null, result, attachments);
    }

    public Result addResult(String projectKey, Result result) throws StorageException {
        return this.addResult(projectKey, result, null);
    }

    public Result addResult(Object configuration, Result result) throws StorageException {
        return this.addResult((String)Property.PROJECT_KEY.get(configuration), this.updateResultFromConfigurations(Arrays.asList(configuration), result), null);
    }

    public Result addResult(Object configuration, Result result, List<Object> attachments) throws StorageException {
        return this.addResult((String)Property.PROJECT_KEY.get(configuration), this.updateResultFromConfigurations(Arrays.asList(configuration), result), attachments);
    }

    public Result addResult(List<Object> configurations, Result result) throws StorageException {
        return this.addResult((String)Property.PROJECT_KEY.get(configurations), this.updateResultFromConfigurations(configurations, result), null);
    }

    public Result addResult(List<Object> configurations, Result result, List<Object> attachments) throws StorageException {
        return this.addResult((String)Property.PROJECT_KEY.get(configurations), this.updateResultFromConfigurations(configurations, result), attachments);
    }

    public Result addResult(String projectKey, Result result, List<Object> attachments) throws StorageException {
        try {
            this.prepareResultBeforeCreate(result);
            this.validateResult(result);
            if (result.getProjectId() == null || result.getProjectId().trim().isEmpty()) {
                if (projectKey == null) {
                    projectKey = (String)Property.PROJECT_KEY.get();
                }
                if (projectKey == null || projectKey.trim().isEmpty()) {
                    throw new StorageException("Both result project key and id are empty");
                }
            }
            result = this.createResult(projectKey, result, attachments);
            this.getLogger().info("Result added " + result.getName() + " " + result.getId());
        }
        catch (Exception e) {
            try {
                if (result != null && result.getId() != null) {
                    this.getLogger().info("Deleting result " + result.getId());
                    this.deleteResult(result);
                    this.getLogger().info("Result deleted " + result.getId());
                }
            }
            catch (Exception e2) {
                this.getLogger().error("Failed to delete result after failing to add result", (Throwable)e2);
            }
            throw new StorageException("Failed to add result", e);
        }
        return result;
    }

    protected abstract Result createResult(String var1, Result var2, List<Object> var3) throws StorageException;

    protected abstract void deleteResult(Result var1) throws StorageException;

    protected void prepareResultBeforeCreate(Result result) {
        if (result == null) {
            return;
        }
        if (result.getProjectId() == null) {
            result.setProjectId((String)Property.PROJECT_ID.get());
        }
        if (result.getEndedAt() == null) {
            result.setEndedAt(new Date());
        }
        if (result.getStatus() == null) {
            result.setStatus(TestStatus.PASSED);
        }
        if (result.getSeverity() == null) {
            result.setSeverity(TestSeverity.NORMAL);
        }
    }

    protected void validateResult(Result result) throws StorageException {
        if (result == null) {
            throw new StorageException("Result is required");
        }
        if (result.getId() != null) {
            throw new StorageException("Result id is already defined [" + result.getId() + "]");
        }
        if (result.getName() == null) {
            throw new StorageException("Result name is required");
        }
        if (result.getSuite() != null && result.getSuiteId() == null) {
            throw new StorageException("Both suite and suite id are required not only suite [" + result.getSuite() + "]");
        }
        if (result.getSuiteId() != null && result.getSuite() == null) {
            throw new StorageException("Both suite and suite id are required not only suite id [" + result.getSuiteId() + "]");
        }
        if (result.getJob() != null && result.getJobId() == null) {
            throw new StorageException("Both job and job id are required not only job [" + result.getJob() + "]");
        }
        if (result.getJobId() != null && result.getJob() == null) {
            throw new StorageException("Both job and job id are required not only job id [" + result.getJobId() + "]");
        }
        if (result.getStartedAt() == null) {
            throw new StorageException("Result started at is required");
        }
        if (result.getEndedAt() == null) {
            throw new StorageException("Result ended at is required");
        }
        if (result.getStatus() == null) {
            throw new StorageException("Result status is required");
        }
        if (result.getSeverity() == null) {
            throw new StorageException("Result severity is required");
        }
        if (result.getStartedAt().after(result.getEndedAt())) {
            throw new StorageException("Result ended before it started [" + result.getStartedAt() + ", " + result.getEndedAt() + "]");
        }
        if (result.getLinks() != null) {
            for (int i = 0; i < result.getLinks().size(); ++i) {
                ResultLink link = result.getLinks().get(i);
                if (link == null) {
                    throw new StorageException("Result link " + i + " is null");
                }
                if (link.getUrl() == null || "".equals(link.getUrl())) {
                    throw new StorageException("Result link " + i + " url is required");
                }
                try {
                    new URL(link.getUrl());
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new StorageException("Result link " + i + " url is invalid [" + link.getUrl() + "]");
                }
            }
        }
    }

    protected Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    protected Result updateResultFromConfigurations(List<Object> configurations, Result result) {
        result.setSuite((String)Property.SUITE.get(configurations, (Object)result.getSuite()));
        result.setSuiteId((String)Property.SUITE_ID.get(configurations, (Object)result.getSuiteId()));
        result.setJob((String)Property.JOB.get(configurations, (Object)result.getJob()));
        result.setJobId((String)Property.JOB_ID.get(configurations, (Object)result.getJobId()));
        result.setMilestone((String)Property.MILESTONE.get(configurations, (Object)result.getMilestone()));
        result.setName((String)Property.NAME.get(configurations, (Object)result.getName()));
        result.setDescription((String)Property.DESCRIPTION.get(configurations, (Object)result.getDescription()));
        result.setEnvironment((String)Property.ENVIRONMENT.get(configurations, (Object)result.getEnvironment()));
        result.setAuthor((String)Property.AUTHOR.get(configurations, (Object)result.getAuthor()));
        result.setSeverity((TestSeverity)((Object)Property.SEVERITY.get(configurations, (Object)result.getSeverity())));
        List labels = (List)Property.LABELS.get(configurations);
        if (result.getLabels() != null) {
            labels.addAll(result.getLabels());
        }
        result.setLabels(labels);
        List notes = (List)Property.NOTES.get(configurations);
        if (result.getNotes() != null) {
            notes.addAll(result.getNotes());
        }
        result.setNotes(notes);
        List links = (List)Property.LINKS.get(configurations);
        if (result.getLinks() != null) {
            links.addAll(result.getLinks());
        }
        result.setLinks(links);
        return result;
    }
}

