/*
 * Decompiled with CFR 0.152.
 */
package cz.etnetera.seleniumbrowser.browser;

import cz.etnetera.seleniumbrowser.browser.Browser;
import cz.etnetera.seleniumbrowser.browser.BrowserContextWait;
import cz.etnetera.seleniumbrowser.browser.BrowserUtils;
import cz.etnetera.seleniumbrowser.configuration.BrowserConfiguration;
import cz.etnetera.seleniumbrowser.element.BrowserElement;
import cz.etnetera.seleniumbrowser.event.BrowserEvent;
import cz.etnetera.seleniumbrowser.logic.Logic;
import cz.etnetera.seleniumbrowser.page.Page;
import cz.etnetera.seleniumbrowser.source.DataSource;
import cz.etnetera.seleniumbrowser.source.PropertySource;
import java.io.File;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.WrapsDriver;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.ui.Clock;
import org.openqa.selenium.support.ui.Sleeper;

public interface BrowserContext
extends SearchContext,
PropertySource,
DataSource,
WrapsDriver {
    public BrowserContext getContext();

    default public <T> T getContext(Class<T> context) {
        return (T)this.getContext();
    }

    public Browser getBrowser();

    default public <T> T getBrowser(Class<T> browser) {
        return (T)this.getBrowser();
    }

    default public BrowserConfiguration getConfiguration() {
        return this.getBrowser().getConfiguration();
    }

    default public <T> T getConfiguration(Class<T> configuration) {
        return this.getBrowser().getConfiguration(configuration);
    }

    default public WebDriver getDriver() {
        return this.getBrowser().getDriver();
    }

    default public <T> T getDriver(Class<T> driver) {
        return this.getBrowser().getDriver(driver);
    }

    default public Page getPage() {
        return this.getBrowser().getPage();
    }

    default public <T> T getPage(Class<T> page) {
        return this.getBrowser().getPage(page);
    }

    default public void setPage(Page page) {
        this.getBrowser().setPage(page);
    }

    default public void goToUrl(String url) {
        this.getBrowser().goToUrl(url);
    }

    default public double getWaitTimeout() {
        return this.getBrowser().getWaitTimeout();
    }

    default public double getWaitRetryInterval() {
        return this.getBrowser().getWaitRetryInterval();
    }

    default public BrowserContextWait waiting(Clock clock, Sleeper sleeper, double timeout, double retryInterval) {
        return new BrowserContextWait(this, clock, sleeper, timeout, retryInterval);
    }

    default public BrowserContextWait waiting(double timeout, double retryInterval) {
        return new BrowserContextWait(this, timeout, retryInterval);
    }

    default public BrowserContextWait waiting(double timeout) {
        return new BrowserContextWait(this, timeout);
    }

    default public BrowserContextWait waiting() {
        return new BrowserContextWait(this);
    }

    default public boolean isAt(Class<?> page) {
        return this.getBrowser().isAt(page);
    }

    default public void assertAt(Class<?> page) {
        this.getBrowser().assertAt(page);
    }

    default public <T extends Page> T goToSafely(Class<T> page) {
        return (T)this.getBrowser().goToSafely(page);
    }

    default public <T extends Page> T goToSafely(T page) {
        return this.getBrowser().goToSafely(page);
    }

    default public <T extends Page> T initPageSafely(Class<T> page) {
        return (T)this.getBrowser().initPageSafely(page);
    }

    default public <T extends Page> T initPageSafely(T page) {
        return this.getBrowser().initPageSafely(page);
    }

    default public Page initOnePageSafely(Object ... pages) {
        return this.getBrowser().initOnePageSafely(pages);
    }

    default public <T extends Page> T goTo(Class<T> page) {
        return (T)this.getBrowser().goTo(page);
    }

    default public <T extends Page> T goTo(T page) {
        return this.getBrowser().goTo(page);
    }

    default public <T extends Page> T initPage(Class<T> page) {
        return (T)this.getBrowser().initPage(page);
    }

    default public <T extends Page> T initPage(T page) {
        return this.getBrowser().initPage(page);
    }

    default public Page initOnePage(Object ... pages) {
        return this.getBrowser().initOnePage(pages);
    }

    default public <T extends Page> T constructPage(Class<T> page) {
        return this.getBrowser().constructPage(page);
    }

    default public <T extends BrowserElement> T initBrowserElement(T element) {
        return this.getBrowser().initBrowserElement(element);
    }

    default public <T extends BrowserElement> T initBrowserElement(Class<T> element, WebElement webElement, boolean optional) {
        return this.getBrowser().initBrowserElement(element, this, webElement, optional);
    }

    default public <T extends BrowserElement> T constructBrowserElement(Class<T> element, WebElement webElement, boolean optional) {
        return this.getBrowser().constructBrowserElement(element, this, webElement, optional);
    }

    default public <T extends Logic> T initLogic(T logic) {
        return this.getBrowser().initLogic(logic);
    }

    default public <T extends Logic> T initLogic(Class<T> logic) {
        return this.getBrowser().initLogic(logic, this);
    }

    default public <T extends Logic> T constructLogic(Class<T> logic) {
        return this.getBrowser().constructLogic(logic, this);
    }

    default public void initElements() {
        this.getBrowser().initElements(this);
    }

    default public void checkIfPresent(WebElement element) throws NoSuchElementException {
        this.getBrowser().checkIfPresent(element);
    }

    default public boolean isPresent(WebElement element) {
        return this.getBrowser().isPresent(element);
    }

    default public boolean isNotPresent(WebElement element) {
        return this.getBrowser().isNotPresent(element);
    }

    default public void report(String label) {
        this.getBrowser().report(this, label);
    }

    default public void triggerEvent(BrowserEvent event) {
        this.getBrowser().triggerEvent(event);
    }

    default public <T extends BrowserEvent> T constructEvent(Class<T> eventCls) {
        return this.getBrowser().constructEvent(eventCls, this);
    }

    default public void saveFile(String content, String name, String extension) {
        this.getBrowser().saveFile(content, name, extension);
    }

    default public void saveFile(byte[] bytes, String name, String extension) {
        this.getBrowser().saveFile(bytes, name, extension);
    }

    default public void saveFile(File file, String name, String extension) {
        this.getBrowser().saveFile(file, name, extension);
    }

    default public BrowserUtils getUtils() {
        return this.getBrowser().getUtils();
    }

    default public List<BrowserElement> find(By by) {
        return this.getBrowser().find(this, by, BrowserElement.class);
    }

    default public List<BrowserElement> find(BrowserContext context, By by) {
        return this.getBrowser().find(context, by, BrowserElement.class);
    }

    default public <T extends BrowserElement> List<T> find(By by, Class<T> elementCls) {
        return this.getBrowser().find(this, by, elementCls);
    }

    default public <T extends BrowserElement> List<T> find(BrowserContext context, By by, Class<T> elementCls) {
        return this.getBrowser().find(context, by, elementCls);
    }

    default public BrowserElement findOne(By by) {
        return this.getBrowser().findOne(this, by, BrowserElement.class, false);
    }

    default public BrowserElement findOne(BrowserContext context, By by) {
        return this.getBrowser().findOne(context, by, BrowserElement.class, false);
    }

    default public <T extends BrowserElement> T findOne(By by, Class<T> elementCls) {
        return this.getBrowser().findOne(this, by, elementCls, false);
    }

    default public <T extends BrowserElement> T findOne(BrowserContext context, By by, Class<T> elementCls) {
        return this.getBrowser().findOne(context, by, elementCls, false);
    }

    default public <T extends BrowserElement> T findOne(BrowserContext context, By by, Class<T> elementCls, boolean optional) {
        return this.getBrowser().findOne(context, by, elementCls, optional);
    }

    default public BrowserElement findOneOptional(By by) {
        return this.getBrowser().findOne(this, by, BrowserElement.class, true);
    }

    default public BrowserElement findOneOptional(BrowserContext context, By by) {
        return this.getBrowser().findOne(context, by, BrowserElement.class, true);
    }

    default public <T extends BrowserElement> T findOneOptional(By by, Class<T> elementCls) {
        return this.getBrowser().findOne(this, by, elementCls, true);
    }

    default public <T extends BrowserElement> T findOneOptional(BrowserContext context, By by, Class<T> elementCls) {
        return this.getBrowser().findOne(context, by, elementCls, true);
    }

    default public ElementLocator createElementLocator(Field field) {
        return this.getBrowser().createElementLocator((SearchContext)this, field);
    }

    default public ElementLocator createElementLocator(By by) {
        return this.getBrowser().createElementLocator((SearchContext)this, by);
    }

    default public ElementLocator createElementLocator(By by, boolean lookupCached) {
        return this.getBrowser().createElementLocator(this, by, lookupCached);
    }

    default public WebDriver getWrappedDriver() {
        return this.getDriver();
    }

    @Override
    default public Map<String, Object> getDataHolder() {
        return this.getBrowser().getDataHolder();
    }

    @Override
    default public String getProperty(String key) {
        return this.getBrowser().getProperty(key);
    }
}

