/*
 * Decompiled with CFR 0.152.
 */
package cz.etnetera.seleniumbrowser.browser;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import cz.etnetera.seleniumbrowser.browser.BrowserContext;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.Clock;
import org.openqa.selenium.support.ui.Duration;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.Sleeper;
import org.openqa.selenium.support.ui.SystemClock;

public class BrowserContextWait
extends FluentWait<BrowserContext> {
    protected BrowserContext context;
    protected final Sleeper sleeper;
    protected Duration timeout;

    public BrowserContextWait(BrowserContext context, Clock clock, Sleeper sleeper, double timeout, double retryInterval) {
        super((Object)context, clock, sleeper);
        this.withTimeout((long)(timeout * 1000.0), TimeUnit.MILLISECONDS);
        this.pollingEvery((long)(retryInterval * 1000.0), TimeUnit.MILLISECONDS);
        this.ignoring(NotFoundException.class);
        this.context = context;
        this.sleeper = sleeper;
    }

    public BrowserContextWait(BrowserContext context, double timeout, double retryInterval) {
        this(context, (Clock)new SystemClock(), Sleeper.SYSTEM_SLEEPER, timeout, retryInterval);
    }

    public BrowserContextWait(BrowserContext context, double timeout) {
        this(context, timeout, context.getWaitRetryInterval());
    }

    public BrowserContextWait(BrowserContext context) {
        this(context, context.getWaitTimeout());
    }

    protected RuntimeException timeoutException(String message, Throwable lastException) {
        TimeoutException ex = new TimeoutException(message, lastException);
        ex.addInfo("Driver info", this.context.getDriver().getClass().getName());
        if (this.context.getDriver() instanceof RemoteWebDriver) {
            RemoteWebDriver remote = (RemoteWebDriver)this.context.getDriver();
            if (remote.getSessionId() != null) {
                ex.addInfo("Session ID", remote.getSessionId().toString());
            }
            if (remote.getCapabilities() != null) {
                ex.addInfo("Capabilities", remote.getCapabilities().toString());
            }
        }
        throw ex;
    }

    public void untilTrue(final Predicate<BrowserContext> isTrue) {
        super.until((com.google.common.base.Predicate)new com.google.common.base.Predicate<BrowserContext>(){

            public boolean apply(BrowserContext input) {
                return isTrue.test(input);
            }
        });
    }

    public <V> V untilValid(final java.util.function.Function<BrowserContext, V> isTrue) {
        return (V)super.until(new Function<BrowserContext, V>(){

            public V apply(BrowserContext input) {
                return isTrue.apply(input);
            }
        });
    }

    public BrowserContextWait sleep() {
        try {
            this.sleeper.sleep(this.timeout);
            return this;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new WebDriverException((Throwable)e);
        }
    }

    public BrowserContextWait withTimeout(long duration, TimeUnit unit) {
        super.withTimeout(duration, unit);
        this.timeout = new Duration(duration, unit);
        return this;
    }

    public BrowserContextWait withMessage(String message) {
        return (BrowserContextWait)super.withMessage(message);
    }

    public BrowserContextWait withMessage(Supplier<String> messageSupplier) {
        return (BrowserContextWait)super.withMessage(messageSupplier);
    }

    public BrowserContextWait pollingEvery(long duration, TimeUnit unit) {
        return (BrowserContextWait)super.pollingEvery(duration, unit);
    }

    public <K extends Throwable> BrowserContextWait ignoreAll(Collection<Class<? extends K>> types) {
        return (BrowserContextWait)super.ignoreAll(types);
    }

    public BrowserContextWait ignoring(Class<? extends Throwable> exceptionType) {
        return (BrowserContextWait)super.ignoring(exceptionType);
    }

    public BrowserContextWait ignoring(Class<? extends Throwable> firstType, Class<? extends Throwable> secondType) {
        return (BrowserContextWait)super.ignoring(firstType, secondType);
    }
}

