/*
 * Decompiled with CFR 0.152.
 */
package cz.etnetera.seleniumbrowser.configuration;

import cz.etnetera.seleniumbrowser.configuration.BrowserConfiguration;
import cz.etnetera.seleniumbrowser.listener.BrowserListener;
import cz.etnetera.seleniumbrowser.listener.impl.PageSourceListener;
import cz.etnetera.seleniumbrowser.listener.impl.ScreenshotListener;
import cz.etnetera.seleniumbrowser.source.ChainedPropertiesSource;
import cz.etnetera.seleniumbrowser.source.DataSource;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

public class BasicBrowserConfiguration
implements BrowserConfiguration,
ChainedPropertiesSource,
DataSource {
    public static final String SYSTEM_PROPERTIES_KEY = "system";
    public static final String DEFAULT_PROPERTIES_KEY = "default";
    public static final String DEFAULT_PROPERTIES_RESOURCE_NAME = "seleniumbrowser.properties";
    public static final String PREFIX = "browser.";
    public static final String BASE_URL = "browser.baseUrl";
    public static final String BASE_URL_REGEX = "browser.baseUrlRegex";
    public static final String URL_VERIFICATION = "browser.urlVerification";
    public static final String WAIT_TIMEOUT = "browser.waitTimeout";
    public static final String WAIT_RETRY_INTERVAL = "browser.waitRetryInterval";
    public static final String REPORTED = "browser.reported";
    public static final String REPORT_DIR = "browser.reportDir";
    protected List<ChainedPropertiesSource.PropertiesValue> propertiesHolder = new ArrayList<ChainedPropertiesSource.PropertiesValue>();
    protected Map<String, Object> dataHolder = new HashMap<String, Object>();

    public BasicBrowserConfiguration() {
        this.addSystemProperties().addDefaultProperties();
    }

    protected String getDefaultBaseUrl() {
        return null;
    }

    protected String getDefaultBaseUrlRegex() {
        String baseUrl = this.getBaseUrl();
        return baseUrl == null ? null : Pattern.quote(baseUrl);
    }

    protected boolean isDefaultUrlVerification() {
        return true;
    }

    protected WebDriver getDefaultDriver(DesiredCapabilities caps) {
        return new FirefoxDriver((Capabilities)caps);
    }

    protected DesiredCapabilities getDefaultCapabilities() {
        return null;
    }

    protected double getDefaultWaitTimeout() {
        return 5.0;
    }

    protected double getDefaultWaitRetryInterval() {
        return 0.1;
    }

    protected boolean isDefaultReported() {
        return false;
    }

    protected File getDefaultReportDir() {
        return new File("selenium-browser-report");
    }

    protected List<BrowserListener> getDefaultListeners() {
        return new ArrayList<BrowserListener>(Arrays.asList(new PageSourceListener(), new ScreenshotListener()));
    }

    @Override
    public void init() {
    }

    @Override
    public String getBaseUrl() {
        return this.getProperty(BASE_URL, this.getDefaultBaseUrl());
    }

    @Override
    public String getBaseUrlRegex() {
        return this.getProperty(BASE_URL_REGEX, this.getDefaultBaseUrl());
    }

    @Override
    public boolean isUrlVerification() {
        return this.getProperty(URL_VERIFICATION, Boolean.class, this.isDefaultUrlVerification());
    }

    @Override
    public WebDriver getDriver(DesiredCapabilities caps) {
        return this.getDefaultDriver(caps);
    }

    @Override
    public DesiredCapabilities getCapabilities() {
        return this.getDefaultCapabilities();
    }

    @Override
    public double getWaitTimeout() {
        return this.getProperty(WAIT_TIMEOUT, Double.class, this.getDefaultWaitTimeout());
    }

    @Override
    public double getWaitRetryInterval() {
        return this.getProperty(WAIT_RETRY_INTERVAL, Double.class, this.getDefaultWaitRetryInterval());
    }

    @Override
    public boolean isReported() {
        return this.getProperty(REPORTED, Boolean.class, this.isDefaultReported());
    }

    @Override
    public File getReportDir() {
        String reportDir = this.getProperty(REPORT_DIR);
        return reportDir == null ? this.getDefaultReportDir() : new File(reportDir);
    }

    @Override
    public List<BrowserListener> getListeners() {
        return this.getDefaultListeners();
    }

    @Override
    public List<ChainedPropertiesSource.PropertiesValue> getPropertiesHolder() {
        return this.propertiesHolder;
    }

    @Override
    public Map<String, Object> getDataHolder() {
        return this.dataHolder;
    }

    public BasicBrowserConfiguration addDefaultProperties() {
        return (BasicBrowserConfiguration)this.addResourceProperties(DEFAULT_PROPERTIES_KEY, DEFAULT_PROPERTIES_RESOURCE_NAME);
    }

    public BasicBrowserConfiguration addDefaultPropertiesBefore(String beforeKey) {
        return (BasicBrowserConfiguration)this.addResourcePropertiesBefore(beforeKey, DEFAULT_PROPERTIES_KEY, DEFAULT_PROPERTIES_RESOURCE_NAME);
    }

    public BasicBrowserConfiguration addDefaultPropertiesAfter(String afterKey) {
        return (BasicBrowserConfiguration)this.addResourcePropertiesAfter(afterKey, DEFAULT_PROPERTIES_KEY, DEFAULT_PROPERTIES_RESOURCE_NAME);
    }

    public BasicBrowserConfiguration addSystemProperties() {
        return (BasicBrowserConfiguration)this.addProperties(SYSTEM_PROPERTIES_KEY, System.getProperties());
    }

    public BasicBrowserConfiguration addSystemPropertiesBefore(String beforeKey) {
        return (BasicBrowserConfiguration)this.addPropertiesBefore(beforeKey, SYSTEM_PROPERTIES_KEY, System.getProperties());
    }

    public BasicBrowserConfiguration addSystemPropertiesAfter(String afterKey) {
        return (BasicBrowserConfiguration)this.addPropertiesAfter(afterKey, SYSTEM_PROPERTIES_KEY, System.getProperties());
    }

    public BasicBrowserConfiguration pushDefaultProperties() {
        return (BasicBrowserConfiguration)this.pushResourceProperties(DEFAULT_PROPERTIES_KEY, DEFAULT_PROPERTIES_RESOURCE_NAME);
    }

    public BasicBrowserConfiguration pushSystemProperties() {
        return (BasicBrowserConfiguration)this.pushProperties(SYSTEM_PROPERTIES_KEY, System.getProperties());
    }
}

