/*
 * Decompiled with CFR 0.152.
 */
package cz.etnetera.seleniumbrowser.element;

import cz.etnetera.seleniumbrowser.browser.Browser;
import cz.etnetera.seleniumbrowser.browser.BrowserContext;
import cz.etnetera.seleniumbrowser.browser.BrowserException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.internal.Coordinates;
import org.openqa.selenium.internal.Locatable;
import org.openqa.selenium.internal.WrapsDriver;
import org.openqa.selenium.internal.WrapsElement;

public class BrowserElement
implements BrowserContext,
WebElement,
WrapsElement,
WrapsDriver,
Locatable {
    protected BrowserContext context;
    protected WebElement webElement;
    protected boolean optional;
    protected boolean present;

    public BrowserElement with(BrowserContext context, WebElement webElement, boolean optional) {
        this.context = context;
        this.webElement = webElement;
        this.optional = optional;
        return this;
    }

    public WebElement getWebElement() {
        if (!this.present && this.isPresent(this.webElement)) {
            this.present = true;
            this.initPresent();
        }
        return this.webElement;
    }

    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public BrowserContext getContext() {
        return this.context;
    }

    public final BrowserElement init() {
        block3: {
            try {
                this.checkIfPresent(this.webElement);
                this.present = true;
            }
            catch (NoSuchElementException e) {
                if (this.optional) break block3;
                throw e;
            }
        }
        if (this.present) {
            this.initPresent();
        }
        return this;
    }

    protected void initPresent() {
    }

    public void checkIfPresent() throws NoSuchElementException {
        this.getContext().checkIfPresent(this.getWebElement());
    }

    public boolean isPresent() {
        return this.getContext().isPresent(this.getWebElement());
    }

    public boolean isNotPresent() {
        return this.getContext().isNotPresent(this.getWebElement());
    }

    public List<WebElement> findElements(By by) {
        return this.getWebElement().findElements(by);
    }

    public WebElement findElement(By by) {
        return this.getWebElement().findElement(by);
    }

    public <X> X getScreenshotAs(OutputType<X> target) throws WebDriverException {
        return (X)this.getWebElement().getScreenshotAs(target);
    }

    public void click() {
        this.getWebElement().click();
    }

    public void submit() {
        this.getWebElement().submit();
    }

    public void sendKeys(CharSequence ... keysToSend) {
        this.getWebElement().sendKeys(keysToSend);
    }

    public void clear() {
        this.getWebElement().clear();
    }

    public String getTagName() {
        return this.getWebElement().getTagName();
    }

    public String getAttribute(String name) {
        return this.getWebElement().getAttribute(name);
    }

    public boolean isSelected() {
        return this.getWebElement().isSelected();
    }

    public boolean isEnabled() {
        return this.getWebElement().isEnabled();
    }

    public String getText() {
        return this.getWebElement().getText();
    }

    public boolean isDisplayed() {
        return this.getWebElement().isDisplayed();
    }

    public Point getLocation() {
        return this.getWebElement().getLocation();
    }

    public Dimension getSize() {
        return this.getWebElement().getSize();
    }

    public String getCssValue(String propertyName) {
        return this.getWebElement().getCssValue(propertyName);
    }

    public WebElement getWrappedElement() {
        return this.getWebElement();
    }

    public Coordinates getCoordinates() {
        return ((Locatable)this.getWebElement()).getCoordinates();
    }

    @Override
    public Browser getBrowser() {
        return this.getContext().getBrowser();
    }

    @Override
    public double getWaitTimeout() {
        return this.getContext().getWaitTimeout();
    }

    @Override
    public double getWaitRetryInterval() {
        return this.getContext().getWaitRetryInterval();
    }

    public void blur() {
        if (!(this.getDriver() instanceof JavascriptExecutor)) {
            throw new BrowserException("Triggering blur event is supported with JavascriptExecutor driver only, this is " + this.getDriver().getClass());
        }
        this.getBrowser().getJavascriptLibrary().callEmbeddedSelenium(this.getDriver(), "triggerEvent", (WebElement)this, new Object[]{"blur"});
    }

    public boolean hasClass(String className) {
        return this.getClasses().contains(className);
    }

    public List<String> getClasses() {
        String classAttr = this.getAttribute("class");
        return Stream.of((classAttr == null ? "" : classAttr).trim().split("\\s+")).distinct().sorted().collect(Collectors.toList());
    }
}

