/*
 * Decompiled with CFR 0.152.
 */
package cz.etnetera.seleniumbrowser.element;

import cz.etnetera.seleniumbrowser.browser.BrowserContext;
import cz.etnetera.seleniumbrowser.element.BrowserElement;
import cz.etnetera.seleniumbrowser.element.BrowserElementList;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.Locatable;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.pagefactory.internal.LocatingElementHandler;
import org.openqa.selenium.support.pagefactory.internal.LocatingElementListHandler;

public class BrowserElementLoader {
    public <T extends BrowserElement> T findOne(BrowserContext context, By by, Class<T> elementCls, boolean optional) {
        return this.initBrowserElement(context, this.proxyForLocator(context.getClass().getClassLoader(), context.createElementLocator(by)), elementCls, optional);
    }

    public <T extends BrowserElement> T findOne(BrowserContext context, ClassLoader loader, Field field, Class<T> elementCls, boolean optional) {
        return this.initBrowserElement(context, this.proxyForLocator(loader, context.createElementLocator(field)), elementCls, optional);
    }

    public <T extends BrowserElement> List<T> find(BrowserContext context, By by, Class<T> elementCls) {
        return this.initBrowserElements(context, this.proxyForListLocator(context.getClass().getClassLoader(), context.createElementLocator(by)), elementCls);
    }

    public <T extends BrowserElement> List<T> find(BrowserContext context, ClassLoader loader, Field field, Class<T> elementCls) {
        return this.initBrowserElements(context, this.proxyForListLocator(loader, context.createElementLocator(field)), elementCls);
    }

    public <T extends BrowserElement> T initBrowserElement(BrowserContext context, WebElement webElement, Class<T> elementCls, boolean optional) {
        return context.initBrowserElement(elementCls, webElement, optional);
    }

    public <T extends BrowserElement> List<T> initBrowserElements(BrowserContext context, List<WebElement> webElements, Class<T> elementCls) {
        return new BrowserElementList(context, webElements, elementCls);
    }

    protected WebElement proxyForLocator(ClassLoader loader, ElementLocator locator) {
        LocatingElementHandler handler = new LocatingElementHandler(locator);
        return (WebElement)Proxy.newProxyInstance(loader, new Class[]{WebElement.class, WrapsElement.class, Locatable.class}, (InvocationHandler)handler);
    }

    protected List<WebElement> proxyForListLocator(ClassLoader loader, ElementLocator locator) {
        LocatingElementListHandler handler = new LocatingElementListHandler(locator);
        return (List)Proxy.newProxyInstance(loader, new Class[]{List.class}, (InvocationHandler)handler);
    }
}

