/*
 * Decompiled with CFR 0.152.
 */
package cz.etnetera.seleniumbrowser.element;

import cz.etnetera.seleniumbrowser.browser.BrowserContext;
import cz.etnetera.seleniumbrowser.element.BrowserElement;
import cz.etnetera.seleniumbrowser.element.FindByDefault;
import cz.etnetera.seleniumbrowser.element.OptionalElement;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindAll;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.FindBys;
import org.openqa.selenium.support.pagefactory.FieldDecorator;

public class BrowserFieldDecorator
implements FieldDecorator {
    protected BrowserContext context;

    public BrowserFieldDecorator(BrowserContext context) {
        this.context = context;
    }

    public Object decorate(ClassLoader loader, Field field) {
        if (!this.isSupported(field)) {
            return null;
        }
        Class<Object> elementCls = null;
        boolean isList = false;
        if (WebElement.class.isAssignableFrom(field.getType())) {
            elementCls = field.getType();
        } else if (List.class.isAssignableFrom(field.getType())) {
            Type genericType = field.getGenericType();
            if (!(genericType instanceof ParameterizedType)) {
                return null;
            }
            Type listType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
            if (!WebElement.class.isAssignableFrom(listType.getClass())) {
                return null;
            }
            elementCls = listType.getClass();
            isList = true;
        } else {
            return null;
        }
        if (!BrowserElement.class.isAssignableFrom(elementCls)) {
            elementCls = BrowserElement.class;
        }
        if (!isList) {
            return this.context.getBrowser().getElementLoader().findOne(this.context, loader, field, elementCls, field.isAnnotationPresent(OptionalElement.class));
        }
        return this.context.getBrowser().getElementLoader().find(this.context, loader, field, elementCls);
    }

    protected boolean isSupported(Field field) {
        return field.isAnnotationPresent(FindByDefault.class) || field.isAnnotationPresent(FindBy.class) || field.isAnnotationPresent(FindBys.class) || field.isAnnotationPresent(FindAll.class);
    }
}

