/*
 * Decompiled with CFR 0.152.
 */
package cz.etnetera.seleniumbrowser.event;

import cz.etnetera.seleniumbrowser.browser.Browser;
import cz.etnetera.seleniumbrowser.browser.BrowserContext;
import cz.etnetera.seleniumbrowser.listener.BrowserListener;
import java.io.File;
import java.time.LocalDateTime;
import org.openqa.selenium.WebDriver;

public abstract class BrowserEvent {
    protected BrowserContext context;
    protected LocalDateTime time;
    protected String browserLabel;
    protected String label;
    protected String filePrefix;

    public BrowserEvent with(BrowserContext context, LocalDateTime time) {
        this.context = context;
        this.time = time;
        return this;
    }

    public abstract void notify(BrowserListener var1);

    public void notifyEnabled(BrowserListener listener) {
        if (listener.isEnabled(this)) {
            this.notify(listener);
        }
    }

    public void init() {
        this.browserLabel = this.context.getBrowser().getLabel();
        this.label = this.generateLabel();
        this.filePrefix = this.context.getUtils().join("-", this.time.format(Browser.FILE_DATE_FORMATTER), this.browserLabel, this.context.getClass().getSimpleName(), this.label);
    }

    public BrowserContext getContext() {
        return this.context;
    }

    public LocalDateTime getTime() {
        return this.time;
    }

    public Browser getBrowser() {
        return this.context.getBrowser();
    }

    public <T> T getBrowser(Class<T> browser) {
        return this.context.getBrowser(browser);
    }

    public WebDriver getDriver() {
        return this.context.getDriver();
    }

    public <T> T getDriver(Class<T> driver) {
        return this.context.getDriver(driver);
    }

    public void saveFile(String content, String name, String extension) {
        this.context.saveFile(content, this.getEventFileName(name), extension);
    }

    public void saveFile(byte[] bytes, String name, String extension) {
        this.context.saveFile(bytes, this.getEventFileName(name), extension);
    }

    public void saveFile(File file, String name, String extension) {
        this.context.saveFile(file, this.getEventFileName(name), extension);
    }

    protected String getEventFileName(String name) {
        return this.context.getUtils().join("-", this.filePrefix, name);
    }

    protected String generateLabel() {
        String endTrim;
        String name = this.getClass().getSimpleName();
        return name.endsWith(endTrim = "Event") ? name.substring(0, name.length() - endTrim.length()) : name;
    }
}

