/*
 * Decompiled with CFR 0.152.
 */
package cz.etnetera.seleniumbrowser.source;

import cz.etnetera.seleniumbrowser.browser.BrowserException;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;

public interface PropertySource {
    public String getProperty(String var1);

    default public String getProperty(String key, String def) {
        String value = this.getProperty(key);
        return value == null ? def : value;
    }

    default public <T> T getProperty(String key, Class<T> cls) {
        return this.getProperty(key, cls, null);
    }

    default public <T> T getProperty(String key, Class<T> cls, T def) {
        try {
            T value = this.castString(this.getProperty(key), cls);
            return value == null ? def : value;
        }
        catch (Exception e) {
            throw new BrowserException("Unable to resolve property with type " + cls.getName() + " for key " + key);
        }
    }

    default public <T> T castString(String value, Class<T> defCls) {
        if (value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(defCls)) {
            return (T)value;
        }
        if (Boolean.class.isAssignableFrom(defCls)) {
            return (T)Boolean.valueOf(value);
        }
        if (Byte.class.isAssignableFrom(defCls)) {
            return (T)Byte.valueOf(value);
        }
        if (Character.class.isAssignableFrom(defCls)) {
            return (T)Character.valueOf(value.charAt(0));
        }
        if (Double.class.isAssignableFrom(defCls)) {
            return (T)Double.valueOf(value);
        }
        if (Float.class.isAssignableFrom(defCls)) {
            return (T)Float.valueOf(value);
        }
        if (Integer.class.isAssignableFrom(defCls)) {
            return (T)Integer.valueOf(value);
        }
        if (Long.class.isAssignableFrom(defCls)) {
            return (T)Long.valueOf(value);
        }
        if (Short.class.isAssignableFrom(defCls)) {
            return (T)Short.valueOf(value);
        }
        if (File.class.isAssignableFrom(defCls)) {
            return (T)new File(value);
        }
        if (Path.class.isAssignableFrom(defCls)) {
            return (T)Paths.get(value, new String[0]);
        }
        if (defCls.isEnum()) {
            return Enum.valueOf(defCls, value);
        }
        throw new BrowserException("Unsupported string cast type " + defCls.getName() + " for value " + value);
    }
}

